


// ***********************************************************************
//   NEWPAPER.C
//
//   Synopsis:
//      Updates WIN.INI Wallpaper specification to point to the next BMP
//      file in the specified subdirectory.
//
//   Environment:
//      Borland C++ for Windows version 3.0 used to compile program.
//      LARGE memory model - tab size 4
//
//   History:
//      07/28/90    Jim Button    Original creation.
//      06/01/92    Bob Jack      Cleaned up and modified code to compile
//                                using Borland's C++. Added user defined
//                                subdirectory for *.BMPs.
// ***********************************************************************
//
//   Instalation:
//
//   Use the NOTEPAD function in Windows to add this to your WIN.INI file
//   (WIN.INI is in your windows directory):
//
//      Under [windows] add or change to:
//         run=newpaper.exe       This runs newpaper.exe on startup.
//
//   Optional - For user defined *.BMP storage:
//
//      Under [Desktop] add or change to:
//         bmpdir=d:\bitmaps      Change "d:\bitmaps" to whatever drive/dir
//                                your bitmaps (*.BMP) are stored in.
// ***********************************************************************

#include	<windows.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dos.h>
#include	<string.h>

#define		MAX_PROF_STR	81

// ***********************************************************************

#pragma argsused

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow)
	{
	struct	ffblk	ff;
	struct	stat	buf;
	int		x, done;
	char	WallPaper []            = "Wallpaper",
			bmpdir [MAX_PROF_STR]   = "",
			npsubdir [MAX_PROF_STR] = "",
			curfile [MAX_PROF_STR]  = "",
			newfile [MAX_PROF_STR]  = "",
			*tiled;
	char	drv [3], dir [66], nam [13], ext [5];

	// Check for valid bmpdir subdirectory

	GetProfileString ("Desktop", "bmpdir", "", bmpdir, MAX_PROF_STR - 1);
	if (strlen (bmpdir) > 0)
		{
		strcpy (npsubdir, bmpdir);
		strupr (npsubdir);
		x = strlen (npsubdir) - 1;
		if (npsubdir [x] == '\\')
			npsubdir [x] = 0;
		if (access (npsubdir, 0) != 0)			// If can't find dir,
			npsubdir [0] = '\0';                // use default dir
		else
			strcat (npsubdir, "\\");
		}

	//   Get old *.BMP file name

	GetProfileString ("Desktop", WallPaper, "", curfile, MAX_PROF_STR - 1);
	fnsplit (curfile, drv, dir, nam, ext);
	strcat (nam, ext);

	//   Find first *.BMP in subdir

	sprintf (curfile, "%s%s", npsubdir, "*.BMP");
	done = findfirst (curfile, &ff, 0);
	if (!done)
		{
		sprintf (newfile, "%s%s", npsubdir, ff.ff_name);
		}

	// Find next *.BMP in subdir

	while (!done)
		{
		if (!strcmpi (ff.ff_name, nam))
			{
			done = findnext (&ff);
			if (!done)
				sprintf (newfile, "%s%s", npsubdir, ff.ff_name);
			break;
			}
		done = findnext (&ff);
		}

	// Save to WIN.INI file

	WriteProfileString ("Desktop", WallPaper, newfile);

	// Tile Wallpaper if BMP is under 100k

	if (stat (newfile, &buf) != -1)
		{
		if (buf.st_size < 100000L)			tiled = "1";
		else								tiled = "0";
		}
	WriteProfileString ("Desktop", "TileWallpaper", tiled);

	// End program - remove from memory

	return (FALSE);
	}

// ***********************************************************************



