VERSION 2.00
Begin Form fEditCustomList 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Maintain Custom List"
   ClientHeight    =   4500
   ClientLeft      =   2130
   ClientTop       =   3645
   ClientWidth     =   8730
   FillColor       =   &H00C0C0C0&
   Height          =   4905
   KeyPreview      =   -1  'True
   Left            =   2070
   LinkTopic       =   "fEditCustomList"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4500
   ScaleWidth      =   8730
   Top             =   3300
   Width           =   8850
   Begin SSPanel ListFilesDisplayHeading 
      Alignment       =   1  'Left Justify - MIDDLE
      BackColor       =   &H00C0C0C0&
      BevelOuter      =   1  'Inset
      BorderWidth     =   1
      Caption         =   "  Mode     Bitmap filename"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   240
      Left            =   135
      TabIndex        =   16
      Top             =   575
      Width           =   3975
   End
   Begin ListBox ListFilesDisplay 
      DragIcon        =   ADDFILES.FRX:0000
      Height          =   2760
      Left            =   135
      MultiSelect     =   2  'Extended
      TabIndex        =   6
      Tag             =   "ListFilesDisplay"
      Top             =   830
      Width           =   3975
   End
   Begin ListBox ListFiles 
      Height          =   225
      Left            =   135
      Sorted          =   -1  'True
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3600
      Visible         =   0   'False
      Width           =   5685
   End
   Begin SSCommand ButtonRemove 
      AutoSize        =   2  'Adjust Button Size To Picture
      Font3D          =   0  'None
      Height          =   420
      Left            =   945
      Picture         =   ADDFILES.FRX:0302
      TabIndex        =   9
      Tag             =   "ButtonRemove"
      Top             =   180
      Width           =   420
   End
   Begin SSCommand ButtonCenter 
      AutoSize        =   2  'Adjust Button Size To Picture
      Font3D          =   0  'None
      Height          =   420
      Left            =   540
      Picture         =   ADDFILES.FRX:046C
      TabIndex        =   8
      Tag             =   "ButtonCenter"
      Top             =   180
      Width           =   420
   End
   Begin SSCommand ButtonTile 
      AutoSize        =   2  'Adjust Button Size To Picture
      Font3D          =   0  'None
      Height          =   420
      Left            =   135
      Picture         =   ADDFILES.FRX:05D6
      TabIndex        =   7
      Tag             =   "ButtonTile"
      Top             =   180
      Width           =   420
   End
   Begin CommandButton ButtonOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   2880
      TabIndex        =   10
      Top             =   3915
      Width           =   1185
   End
   Begin CommandButton ButtonCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4410
      TabIndex        =   11
      Top             =   3915
      Width           =   1185
   End
   Begin DriveListBox ListDrives 
      BackColor       =   &H00FFFFFF&
      Height          =   315
      Left            =   5985
      TabIndex        =   5
      Tag             =   "ListDrives"
      Top             =   3275
      Width           =   2625
   End
   Begin DirListBox ListDirectories 
      BackColor       =   &H00FFFFFF&
      Height          =   2280
      Left            =   5985
      TabIndex        =   3
      Tag             =   "ListDirectories"
      Top             =   630
      Width           =   2580
   End
   Begin FileListBox ListBitmapFiles 
      BackColor       =   &H00FFFFFF&
      DragIcon        =   ADDFILES.FRX:0740
      ForeColor       =   &H00000000&
      Height          =   2955
      Left            =   4275
      MultiSelect     =   2  'Extended
      Pattern         =   "*.bmp"
      TabIndex        =   1
      Tag             =   "ListBitmapFiles"
      Top             =   630
      Width           =   1545
   End
   Begin Label MouseRemove 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "MouseRemove"
      DragIcon        =   ADDFILES.FRX:0A42
      Height          =   195
      Left            =   7110
      TabIndex        =   17
      Top             =   4005
      Visible         =   0   'False
      Width           =   1260
   End
   Begin Label MouseMove 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "MouseMove"
      DragIcon        =   ADDFILES.FRX:0D44
      Height          =   195
      Left            =   7200
      TabIndex        =   18
      Top             =   3735
      Visible         =   0   'False
      Width           =   1035
   End
   Begin Label MouseCopy 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "MouseCopy"
      DragIcon        =   ADDFILES.FRX:1046
      Height          =   195
      Left            =   5940
      TabIndex        =   15
      Top             =   4005
      Visible         =   0   'False
      Width           =   990
   End
   Begin Label MouseNoDrop 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "NoDrop"
      DragIcon        =   ADDFILES.FRX:1348
      Height          =   195
      Left            =   6030
      TabIndex        =   14
      Top             =   3735
      Visible         =   0   'False
      Width           =   660
   End
   Begin Label LabelFiles 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Bitmap &files"
      Height          =   240
      Left            =   4275
      TabIndex        =   0
      Top             =   405
      Width           =   1095
   End
   Begin Label LabelDrives 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Dri&ves:"
      Height          =   240
      Left            =   5985
      TabIndex        =   4
      Top             =   3050
      Width           =   690
   End
   Begin Label LabelDirectories 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Directories:"
      Height          =   240
      Left            =   5985
      TabIndex        =   2
      Top             =   180
      Width           =   1005
   End
   Begin Label LabelCurrentDir 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Current Dir Will Get Put Here"
      Height          =   195
      Left            =   5985
      TabIndex        =   12
      Top             =   405
      Width           =   2625
   End
End
Option Explicit

Dim LongestLine As Integer
Dim WaitingForDrag As Integer

Sub ButtonCancel_Click ()
    Unload Me
End Sub

Sub ButtonCenter_Click ()
    SetTileProperty (CenterFile)
End Sub

Sub ButtonCenter_DragDrop (Source As Control, X As Single, Y As Single)
    Dim fPromptOverwrite As Integer
    Dim fPromptEachFile As Integer

    If TypeOf Source Is FileListBox Then
	Source.Drag 2                       'Drop Files
	fPromptOverwrite = True
	fPromptEachFile = False

	DropFiles CenterFile, fPromptEachFile, fPromptOverwrite
    ElseIf TypeOf Source Is ListBox Then
	SetTileProperty (CenterFile)
    Else
	Source.Drag 0                       'Cancel drag
    End If
End Sub

Sub ButtonCenter_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    If State = 0 Or State = 2 Then
	If TypeOf Source Is FileListBox Then
	    Source.DragIcon = MouseCopy.DragIcon
	Else
	    Source.DragIcon = MouseMove.DragIcon
	End If
    ElseIf State = 1 Then
	Source.DragIcon = MouseNoDrop.DragIcon
    End If
End Sub

Sub ButtonOK_Click ()
    Dim aLoop As Integer
    Dim Result As Integer
    Dim Position As String

    Screen.MousePointer = IDC_WAIT
    Result = ErasePrivateProfileSection(IniSetting(IniNumberOfBitmaps, IniSection), 0&, 0&, IniFileName$)
    Result = WriteAPrivateProfileString(IniFileName, IniSetting(IniNumberOfBitmaps, IniSection), IniSetting(IniNumberOfBitmaps, IniKeyName), ListFiles.ListCount)

    IniSetting(IniNumberOfBitmaps, IniValue) = ListFiles.ListCount
    For aLoop = 0 To IniSetting(IniNumberOfBitmaps, IniValue) - 1
	Result = SaveIniSetting(IniFileName, CStr(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListBitmapPrefix$ + Format(aLoop), CVar(ListFiles.List(aLoop)), "Integer")
	Result = SaveIniSetting(IniFileName, CStr(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListTilePrefix$ + Format(aLoop), TileStrToTile(Left(ListFilesDisplay.List(aLoop), 6)), "Tile")
    Next

    If IniSetting(IniWallpaperSource, IniValue) = UseCustomList Then
	FillBitmapFilesListBox
    End If

    Screen.MousePointer = IDC_DEFAULT
    Unload Me
End Sub

Sub ButtonRemove_Click ()
    Dim aLoop As Integer

    aLoop = 0
    Do While aLoop <= ListFilesDisplay.ListCount - 1
	If ListFilesDisplay.Selected(aLoop) Then
	    ListFilesDisplay.RemoveItem aLoop
	    ListFiles.RemoveItem aLoop
	Else
	    aLoop = aLoop + 1
	End If
    Loop
End Sub

Sub ButtonRemove_DragDrop (Source As Control, X As Single, Y As Single)
    Dim aIndex As Integer
    Dim aLoop As Integer
    Dim ItemToRemove As String
    Dim TheDir As String

    If TypeOf Source Is ListBox Then
	Source.Drag 2                       'Drop files
	ButtonRemove_Click
    ElseIf TypeOf Source Is FileListBox Then
	Source.Drag 2                       'Drop files
	
	For aLoop = 0 To ListBitmapFiles.ListCount - 1
	    If ListBitmapFiles.Selected(aLoop) Then
		TheDir = StrToDir(ListBitmapFiles.Path)
		ItemToRemove = TheDir + ListBitmapFiles.List(aLoop)
		aIndex = IndexInListBox(CInt(ListFiles.hWnd), LB_SearchFromTop, ItemToRemove)
		
		If aIndex <> LB_NOTFOUND Then
		    ListFilesDisplay.RemoveItem aIndex
		    ListFiles.RemoveItem aIndex
		End If
	    End If
	Next
    Else
	Source.Drag 0                       'Cancel drag
    End If
End Sub

Sub ButtonRemove_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    If State = 0 Or State = 2 Then
	Source.DragIcon = MouseRemove.DragIcon
    ElseIf State = 1 Then
	Source.DragIcon = MouseNoDrop.DragIcon
    End If
End Sub

Sub ButtonTile_Click ()
    SetTileProperty (TileFile)
End Sub

Sub ButtonTile_DragDrop (Source As Control, X As Single, Y As Single)
    Dim fPromptOverwrite As Integer
    Dim fPromptEachFile As Integer

    If TypeOf Source Is FileListBox Then
	Source.Drag 2                       'Drop Files
	fPromptOverwrite = True
	fPromptEachFile = False

	DropFiles TileFile, fPromptEachFile, fPromptOverwrite
    ElseIf TypeOf Source Is ListBox Then
	SetTileProperty (TileFile)
    Else
	Source.Drag 0                       'Cancel drag
    End If
End Sub

Sub ButtonTile_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    If State = 0 Or State = 2 Then
	If TypeOf Source Is FileListBox Then
	    Source.DragIcon = MouseCopy.DragIcon
	Else
	    Source.DragIcon = MouseMove.DragIcon
	End If
    ElseIf State = 1 Then
	Source.DragIcon = MouseNoDrop.DragIcon
    End If
End Sub

Sub DropFile (ByVal ItemToAdd As String, ByVal Tile As Integer, fPromptEachFile As Integer, fOverwriteOK As Integer, fPromptOverwrite As Integer)
    Dim Exists As Integer
    Dim OKPushed As Integer
    Dim OverwriteOK As Integer
    Dim TheWidth As Integer
    Dim OldIndex As Long
    Dim MsgResult As Long
    Dim TileMsg As String
    Dim aString As String
    
    '--------------------
    ' Check if ItemToAdd already is in the list.
    ' If already in the list, then ask if okay to
    ' overwrite.
    '--------------------
    aString = ItemToAdd
    OldIndex = SendMessage(ListFiles.hWnd, LB_FINDSTRINGEXACT, LB_SearchFromTop, ItemToAdd)
    Exists = OldIndex <> LB_NOTFOUND
    
    If Exists And fPromptOverwrite Then
	Load fOverwriteEntry
	fOverwriteEntry.FileName = ItemToAdd
	fOverwriteEntry.Show 1
	OverwriteOK = (fOverwriteEntry.ButtonPushed = IDOVERWRITE)
	fPromptOverwrite = Not -Abs(Val(fOverwriteEntry.ApplyToAll.Text))
	If Not fPromptOverwrite Then
	    fOverwriteOK = OverwriteOK
	End If
	Unload fOverwriteEntry
    Else
	OverwriteOK = fOverwriteOK
    End If

    If OverwriteOK Then
	TileMsg = TileToTileStr(Tile)

	If Exists Then
	    ListFiles.RemoveItem OldIndex
	    ListFilesDisplay.RemoveItem OldIndex
	End If

	ListFiles.AddItem ItemToAdd
	ListFilesDisplay.AddItem TileMsg + aTab$ + ItemToAdd, ListFiles.NewIndex

	'--------------------
	' Size the scrollbar if necessary
	'--------------------
	ScaleMode = 3
	TheWidth = TextWidth(TileMsg + Chr(9) + ItemToAdd) + 10
	ScaleMode = 1
	If TheWidth > LongestLine Then
	    LongestLine = TheWidth
	    MsgResult = SendMessage(ListFilesDisplay.hWnd, LB_SETHORIZONTALEXTENT, LongestLine, 0&)
	End If
    End If
End Sub

Sub DropFiles (TilePref As Integer, fPromptEachFile As Integer, fPromptOverwrite As Integer)
    Dim aLoop As Integer
    Dim fPrompt As Integer
    Dim fOverwriteOK As Integer
    Dim OKPushed As Integer
    Dim Remaining As Integer
    Dim Tile As Integer
    Dim ItemToAdd As String
    Dim TheDir As String

    Screen.MousePointer = IDC_WAIT
    fOverwriteOK = True

    For aLoop = 0 To ListBitmapFiles.ListCount - 1
	If ListBitmapFiles.Selected(aLoop) Then
	    TheDir = StrToDir(ListBitmapFiles.Path)
	    ItemToAdd = TheDir + ListBitmapFiles.List(aLoop)

	    '--------------------
	    ' Prompt if user selected "Prompt for each"
	    '--------------------
	    If fPromptEachFile Then
		Load fTileDroppedFile
		fTileDroppedFile.FileName = ItemToAdd
		fTileDroppedFile.OptionCenterOrTile(TilePref) = True
		fTileDroppedFile.CheckRemaining.Value = False
		fTileDroppedFile.Show 1
		fPromptEachFile = Not -Abs(fTileDroppedFile.CheckRemaining.Value)
		OKPushed = fTileDroppedFile.ButtonPushed
		Tile = Val(fTileDroppedFile.Tile.Text)
		Unload fTileDroppedFile
	    Else
		Tile = TilePref
		OKPushed = IDOK
	    End If

	    If OKPushed = IDOK And Tile <> SkipFile Then
		DropFile ItemToAdd, Tile, fPromptEachFile, fOverwriteOK, fPromptOverwrite
	    End If
	End If
    Next

    Screen.MousePointer = IDC_DEFAULT
End Sub

Sub Form_DragDrop (Source As Control, X As Single, Y As Single)
    Source.Drag 0
'   Source.MousePointer = 0   ' Use default mouse pointer.
End Sub

Sub Form_KeyPress (KeyAscii As Integer)
    If KeyAscii = KEY_ESCAPE Then
	ButtonCancel_Click
    End If
End Sub

Sub Form_Load ()
    Const NumTabStops = 1

    Dim aLoop As Integer
    Dim Result As Integer
    Dim TileSetting As Integer
    Dim MsgResult As Long
    Dim FileName As String

    Screen.MousePointer = IDC_WAIT

    ' Add the scroll bar.
    MsgResult = SendMessage(ListFilesDisplay.hWnd, LB_GETHORIZONTALEXTENT, 0, 0&)
    LongestLine = MsgResult
    MsgResult = SendMessage(ListFilesDisplay.hWnd, LB_SETHORIZONTALEXTENT, MsgResult, 0&)

    ListBitmapFiles.Pattern = "*.bmp"
    CenterForm Me

    For aLoop = 0 To IniSetting(IniNumberOfBitmaps, IniValue) - 1
	FileName = RetrieveIniSetting(IniFileName, CVar(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListBitmapPrefix$ + Format$(aLoop), "", "String")
	TileSetting = RetrieveIniSetting(IniFileName, CVar(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListTilePrefix$ + Format$(aLoop), "", "Tile")
	DropFile FileName, TileSetting, False, True, False
    Next

    Screen.MousePointer = IDC_DEFAULT
End Sub

Sub ListBitmapFiles_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    If (State = 0 Or State = 2) And LCase(Source.Tag) <> "listfilesdisplay" Then
	Source.DragIcon = MouseCopy.DragIcon
    ElseIf State = 1 Then
	Source.DragIcon = MouseNoDrop.DragIcon
    End If
End Sub

Sub ListBitmapFiles_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim FileIndex As Integer
    
    WaitingForDrag = 0
    FileIndex = ListBitmapFiles.ListIndex
    If FileIndex < ListBitmapFiles.ListCount Then
	If ListBitmapFiles.Selected(FileIndex) = False Then  ' Was it selected
	    If Button And 1 Then
		If (Shift = 0) Or Shift And 2 Then
		    WaitingForDrag = hWnd
		    ListBitmapFiles.Selected(FileIndex) = True
		End If
	    End If
	End If
    End If
End Sub

Sub ListBitmapFiles_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim FileIndex As Integer
    
    If Button = 1 Then
	If (Shift = 0) Or Shift And 2 Then
	    FileIndex = ListBitmapFiles.ListIndex

	    If FileIndex < ListBitmapFiles.ListCount Then
		If ListBitmapFiles.Selected(FileIndex) Then  ' Was it selected
		    ListBitmapFiles.Move ListBitmapFiles.Left
		    ListBitmapFiles.Drag 1                   ' Drag outline
		End If
	    End If
	End If
    End If
End Sub

Sub ListBitmapFiles_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If WaitingForDrag = hWnd Then
	ListBitmapFiles.Selected(ListBitmapFiles.ListIndex) = False
    End If
    
    WaitingForDrag = 0
End Sub

Sub ListDirectories_Change ()
    ListBitmapFiles.Path = ListDirectories.Path
    LabelCurrentDir.Caption = ListBitmapFiles.Path
End Sub

Sub ListDrives_Change ()
    Dim Answer As Integer
    Dim ErrMsg As String

    ' Handle drive not ready
    If ERR_NONE = IsValidDirectory(Left(ListDrives.Drive, 2)) Then
	ListDirectories.Path = ListDrives.Drive
    Else
	ListDrives.Drive = GetDriveFromPath(CStr(ListDirectories.Path))
    End If
End Sub

Sub ListFilesDisplay_DragDrop (Source As Control, X As Single, Y As Single)
    Dim fPromptOverwrite As Integer
    Dim fPromptEachFile As Integer
    Dim OKPushed As Integer
    Dim Tile As Integer

    If TypeOf Source Is FileListBox Then
	Source.Drag 2                       'Drop Files
	fTileDroppedFiles.CheckConfirmOverwrite.Value = 1
	fTileDroppedFiles.Show 1
	Tile = Val(fTileDroppedFiles.Tile.Text)

	fPromptOverwrite = fTileDroppedFiles.CheckConfirmOverwrite
	fPromptEachFile = fTileDroppedFiles.CheckConfirmEach
	OKPushed = fTileDroppedFiles.ButtonPushed
	Unload fTileDroppedFiles

	If OKPushed <> IDSKIP Then
	    DropFiles Tile, fPromptEachFile, fPromptOverwrite
	End If
    Else
	Source.Drag 0                       'Cancel drag
    End If
End Sub

Sub ListFilesDisplay_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    If State = 0 Or State = 2 Then
	If LCase(Source.Tag) = "listfilesdisplay" Then
	    Source.DragIcon = MouseMove.DragIcon
	Else
	    Source.DragIcon = MouseCopy.DragIcon
	End If
    ElseIf State = 1 Then
	Source.DragIcon = MouseNoDrop.DragIcon
    End If
End Sub

Sub ListFilesDisplay_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim FileIndex As Integer
    
    WaitingForDrag = 0
    FileIndex = ListFilesDisplay.ListIndex
    If FileIndex < ListFilesDisplay.ListCount Then
	If ListFilesDisplay.Selected(FileIndex) = False Then  ' Was it selected
	    If Button And 1 Then
		If (Shift = 0) Or Shift And 2 Then
		    WaitingForDrag = hWnd
		    ListFilesDisplay.Selected(FileIndex) = True
		End If
	    End If
	End If
    End If
End Sub

Sub ListFilesDisplay_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim FileIndex As Integer
    
    If Button = 1 Then
	If (Shift = 0) Or Shift And 2 Then
	    FileIndex = ListFilesDisplay.ListIndex

	    If FileIndex < ListFilesDisplay.ListCount Then
		If ListFilesDisplay.Selected(FileIndex) Then  ' Was it selected
		    ListFilesDisplay.Move ListFilesDisplay.Left
		    ListFilesDisplay.Drag 1                   ' Drag outline
		End If
	    End If
	End If
    End If
End Sub

Sub ListFilesDisplay_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If WaitingForDrag = hWnd Then
	ListFilesDisplay.Selected(ListFilesDisplay.ListIndex) = False
    End If
    
    WaitingForDrag = 0
End Sub

Sub SetTileProperty (Tile As Integer)
    Dim aLoop As Integer
    Dim TileMsg As String

    TileMsg = TileToTileStr(Tile)
    If TileMsg = "" Then
	MsgBox "Program Error in AddFiles:SetTileProperty", MB_OK Or MB_ICONSTOP, WindowTitle$
	End
    End If
    
    For aLoop = 0 To ListFilesDisplay.ListCount - 1
	If ListFilesDisplay.Selected(aLoop) Then
	    ListFilesDisplay.RemoveItem aLoop
	    ListFilesDisplay.AddItem TileMsg + aTab$ + ListFiles.List(aLoop), aLoop
	    ListFilesDisplay.Selected(aLoop) = True
	End If
    Next
End Sub

