VERSION 2.00
Begin Form fMain 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   1965
   ClientLeft      =   5115
   ClientTop       =   2115
   ClientWidth     =   4785
   ForeColor       =   &H00000000&
   Height          =   2655
   Icon            =   FMAIN.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   5055
   LinkTopic       =   "FormMain"
   MaxButton       =   0   'False
   Picture         =   FMAIN.FRX:0302
   ScaleHeight     =   1965
   ScaleWidth      =   4785
   Top             =   1485
   Width           =   4905
   Begin SSCheck CheckTile 
      Caption         =   "&Tiled"
      Font3D          =   0  'None
      Height          =   195
      Left            =   135
      TabIndex        =   2
      Top             =   675
      Width           =   690
   End
   Begin ComboBox ComboBitmapFiles 
      Height          =   300
      Left            =   135
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   315
      Width           =   4515
   End
   Begin FileListBox BitmapFiles 
      Height          =   420
      Left            =   1440
      Pattern         =   "*.bmp"
      TabIndex        =   3
      Top             =   1125
      Visible         =   0   'False
      Width           =   1995
   End
   Begin Timer Timer1 
      Left            =   4095
      Top             =   1125
   End
   Begin Label LabelCurrentWallPaper 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Current &wallpaper:"
      ForeColor       =   &H00000000&
      Height          =   195
      Left            =   135
      TabIndex        =   0
      Top             =   90
      Width           =   1560
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu FileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu OptionsMenu 
      Caption         =   "&Options"
      Begin Menu OptionsSelection 
         Caption         =   "&Selection..."
      End
      Begin Menu OptionsMisc 
         Caption         =   "&Miscelleanous..."
      End
      Begin Menu OptionsEditCustomList 
         Caption         =   "Edit Custom &List..."
      End
      Begin Menu Sep1 
         Caption         =   "-"
      End
      Begin Menu OptionsEnabled 
         Caption         =   "&Enabled"
      End
      Begin Menu OptionsHideIcon 
         Caption         =   "&Hide Icon"
      End
   End
   Begin Menu ChangeNow 
      Caption         =   "&Change Now!"
   End
   Begin Menu HelpMenu 
      Caption         =   "&Help"
      Begin Menu HelpAbout 
         Caption         =   "&About..."
      End
   End
End
Option Explicit

Dim KeyDown As Integer

Sub ChangeNow_Click ()
    ChangeWallpaper
End Sub

Sub CheckTile_Click (Value As Integer)
    Dim fileindex As Integer
    Dim Result As Integer
    Dim Tile As Integer
    Dim FileName As String

    Screen.MousePointer = IDC_WAIT
    fileindex = ComboBitmapFiles.ListIndex
    Tile = TileStrToTile(Value)

    If (Mode = ModeIdle) Then
	If IniSetting(IniWallpaperSource, IniValue) = UseDirectory Then
	    IniSetting(IniTile, IniValue) = Tile
	Else
	    If fileindex >= 0 Then
		Result = SaveIniSetting(IniFileName, CStr(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListTilePrefix$ + Format(fileindex), Tile, "Tile")
	    End If
	End If
    End If
    
    If (Mode And (ModeInitializing Or ModeUpdateCheckMark Or ModeUpdateComboBox)) = 0 Then
	SetWallpaper LastWallpaperFileName, Tile
    End If
    
    Screen.MousePointer = IDC_DEFAULT
End Sub

Sub ComboBitmapFiles_Click ()
    Dim fileindex As Integer
    Dim PrevMode As Integer
    Dim Tile As Integer
    Dim FileName As String

    If (Mode = ModeIdle) And (KeyDown = 0 Or KeyDown = KEY_RETURN) Then
	Screen.MousePointer = IDC_WAIT
	PrevMode = Mode
	Mode = Mode Or ModeChanging
	
	If ComboBitmapFiles.ListIndex <> LastWallPaperIndex Then
	    fileindex = ComboBitmapFiles.ListIndex
	    FileName = SetNewWallpaper(fileindex)
	    
	    If IniSetting(IniWallpaperSource, IniValue) = UseDirectory Then
		Tile = IniSetting(IniTile, IniValue)
	    Else
		Tile = RetrieveIniSetting(IniFileName, CVar(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListTilePrefix$ + Format$(fileindex), CenterFile, "Tile")
	    End If

	    If fMain.CheckTile <> (Tile = TileFile) Then
		fMain.CheckTile = Tile = TileFile
	    Else
		SetWallpaper FileName, Tile
	    End If
	End If

	Mode = PrevMode
	Screen.MousePointer = IDC_DEFAULT
    End If
End Sub

Sub ComboBitmapFiles_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim PrevMode As Integer

    KeyDown = KeyCode

    PrevMode = Mode
    Mode = Mode Or ModeUpdateCheckMark
    CheckTile = GetTileSetting()
    Mode = PrevMode
End Sub

Sub ComboBitmapFiles_KeyUp (KeyCode As Integer, Shift As Integer)
    Dim PrevMode As Integer

    KeyDown = 0
    If KeyCode = KEY_RETURN Then
	ComboBitmapFiles_Click
    Else
	If KeyCode = KEY_ESCAPE Then
	    ComboBitmapFiles.ListIndex = LastWallPaperIndex
	End If
	
	PrevMode = Mode
	Mode = Mode Or ModeUpdateCheckMark
	CheckTile = GetTileSetting()
	Mode = PrevMode
    End If
End Sub

Sub FileExit_Click ()
    End
End Sub

Sub Form_Load ()
    Dim hPrevInstance As Integer

    ' If already running a copy, show that window and
    ' exit. If not already running a copy, then continue
    ' with normal execution.
    hPrevInstance = ShowPrevInstance(WindowTitle$)
    If hPrevInstance <> 0 Then   ' Show copy & then stop
	End     'End this program
    End If
    
    ' If we get here, then not already running another
    ' copy.  So, lets set the title of the window.
    App.Title = WindowTitle$
    fMain.Caption = WindowTitle$

    CenterForm Me
    KeyDown = 0
    Options_UpdateCheckMarks
    
    If IniSetting(IniCumulativeTime, IniValue) Then
	Minutes = IniSetting(IniMinutesSinceChange, IniValue)
    Else
	Minutes = 0
    End If

    If IniSetting(IniEnabled, IniValue) <> 0 Then
	Timer1.Interval = 60000
    Else
	Timer1.Interval = 0
    End If
End Sub

Sub Form_Resize ()
    Const MIN = 1
    If IniSetting(IniHideIcon, IniValue) <> False And WindowState = MIN Then
       Visible = False
    End If
End Sub

Sub Form_Unload (Cancel As Integer)
    IniSetting(IniMinutesSinceChange, IniValue) = Minutes
    SaveIniSettings IniMinutesSinceChange, IniMinutesSinceChange
    End
End Sub

Function GetTileSetting ()
    If IniSetting(IniWallpaperSource, IniValue) = UseDirectory Then
	GetTileSetting = IniSetting(IniTile, IniValue)
    Else
	If ComboBitmapFiles.ListIndex >= 0 Then
	    GetTileSetting = RetrieveIniSetting(IniFileName, CVar(IniSetting(IniNumberOfBitmaps, IniSection)), CustomListTilePrefix$ + Format$(ComboBitmapFiles.ListIndex), CenterFile, "Tile")
	Else
	    GetTileSetting = CenterFile
	End If
    End If
End Function

Sub HelpAbout_Click ()
    fAbout.Show
End Sub

Sub Options_UpdateCheckMarks ()
    OptionsEnabled_Check
    OptionsHideIcon_Check
End Sub

Sub OptionsEditCustomList_Click ()
    fEditCustomList.Show 1
End Sub

Sub OptionsEnabled_Check ()
    OptionsEnabled.Checked = IniSetting(IniEnabled, IniValue)
    Timer1.Enabled = IniSetting(IniEnabled, IniValue)
End Sub

Sub OptionsEnabled_Click ()
    IniSetting(IniEnabled, IniValue) = Not IniSetting(IniEnabled, IniValue)
    SaveIniSettings IniEnabled, IniEnabled
    OptionsEnabled_Check
End Sub

Sub OptionsHideIcon_Check ()
    OptionsHideIcon.Checked = IniSetting(IniHideIcon, IniValue)
End Sub

Sub OptionsHideIcon_Click ()
    IniSetting(IniHideIcon, IniValue) = Not IniSetting(IniHideIcon, IniValue)
    SaveIniSettings IniHideIcon, IniHideIcon
    OptionsHideIcon_Check
End Sub

Sub OptionsMisc_Click ()
    Dim OldSetting As Integer

    OldSetting = IniSetting(IniEnabled, IniValue)
    fMiscOptions.Show 1

    If IniSetting(IniEnabled, IniValue) <> OldSetting Then
	If IniSetting(IniEnabled, IniValue) Then
	    Timer1.Interval = 60000
	Else
	    Timer1.Interval = 0
	End If
    End If
    
    Options_UpdateCheckMarks
End Sub

Sub OptionsSelection_Click ()
    Dim aTile As Integer

    fSelectionOptions.Show 1
    
    If IniSetting(IniWallpaperSource, IniValue) = UseDirectory And IniSetting(IniTile, IniValue) <> CheckTile.Value Then
	CheckTile.Value = IniSetting(IniTile, IniValue) = TileFile
    End If
End Sub

Sub Timer1_Timer ()
    Minutes = Minutes + 1
    If Minutes >= IniSetting(IniChangeFrequency, IniValue) Then
	Minutes = 0
	ChangeWallpaper
    End If
End Sub

