VERSION 2.00
Begin Form fSelectionOptions 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Selection Options"
   ClientHeight    =   4260
   ClientLeft      =   4785
   ClientTop       =   4080
   ClientWidth     =   5820
   ForeColor       =   &H00000000&
   Height          =   4665
   Left            =   4725
   LinkTopic       =   "fSelectionOptions"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4260
   ScaleWidth      =   5820
   Top             =   3735
   Width           =   5940
   Begin CommandButton ButtonChangeNow 
      Caption         =   "Change Now"
      Height          =   375
      Left            =   4320
      TabIndex        =   12
      Top             =   3060
      Width           =   1300
   End
   Begin TextBox EditChangeFreq 
      Height          =   286
      Left            =   1800
      TabIndex        =   11
      Top             =   3105
      Width           =   735
   End
   Begin SpinButton SpinUpdateFreq 
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Left            =   2520
      ShadowBackColor =   &H00C0C0C0&
      TdThickness     =   1
      Top             =   3105
      Width           =   255
   End
   Begin SSFrame GrpSelMethod 
      Caption         =   "Selection Method"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   690
      Left            =   135
      TabIndex        =   8
      Top             =   2295
      Width           =   5505
      Begin SSOption SelectionMethod 
         Caption         =   "&Sequential"
         Font3D          =   0  'None
         ForeColor       =   &H00000000&
         Height          =   285
         Index           =   1
         Left            =   1485
         TabIndex        =   10
         Top             =   270
         Width           =   1230
      End
      Begin SSOption SelectionMethod 
         Caption         =   "Random"
         Font3D          =   0  'None
         ForeColor       =   &H00000000&
         Height          =   285
         Index           =   0
         Left            =   135
         TabIndex        =   9
         Top             =   270
         Width           =   1005
      End
   End
   Begin CommonDialog DlgCommon 
      DefaultExt      =   ".TXT"
      Left            =   90
      Top             =   3645
   End
   Begin CommandButton ButtonCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2925
      TabIndex        =   14
      Top             =   3690
      Width           =   1300
   End
   Begin SSFrame GrpWallPaperList 
      Caption         =   "Wallpaper List"
      Font3D          =   0  'None
      Height          =   2085
      Left            =   135
      TabIndex        =   0
      Top             =   90
      Width           =   5505
      Begin TextBox WallpaperListEditBox 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Index           =   1
         Left            =   360
         TabIndex        =   6
         Top             =   1620
         Width           =   3615
      End
      Begin CommandButton ButtonBrowse 
         Caption         =   "Bro&wse..."
         Height          =   375
         Index           =   1
         Left            =   4140
         TabIndex        =   7
         Top             =   1575
         Width           =   1230
      End
      Begin SSCheck CheckTile 
         Caption         =   "&Tile Wallpaper"
         Font3D          =   0  'None
         Height          =   285
         Left            =   360
         TabIndex        =   3
         Top             =   945
         Width           =   1545
      End
      Begin CommandButton ButtonBrowse 
         Caption         =   "&Browse..."
         Height          =   375
         Index           =   0
         Left            =   4140
         TabIndex        =   4
         Top             =   585
         Width           =   1230
      End
      Begin TextBox WallpaperListEditBox 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Index           =   0
         Left            =   360
         TabIndex        =   2
         Top             =   630
         Width           =   3615
      End
      Begin SSOption WallpaperList 
         Caption         =   "&List File"
         Enabled         =   0   'False
         Font3D          =   0  'None
         Height          =   285
         Index           =   1
         Left            =   135
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   1305
         Width           =   1005
      End
      Begin SSOption WallpaperList 
         Caption         =   "&Directory"
         Font3D          =   0  'None
         Height          =   285
         Index           =   0
         Left            =   135
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   315
         Width           =   1140
      End
   End
   Begin CommandButton ButtonOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   1395
      TabIndex        =   13
      Top             =   3690
      Width           =   1300
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "minutes"
      Height          =   285
      Left            =   2880
      TabIndex        =   16
      Top             =   3150
      Width           =   690
   End
   Begin Label LblUpdateFreq 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Update &Frequency"
      Height          =   285
      Left            =   135
      TabIndex        =   15
      Top             =   3150
      Width           =   1635
   End
End
Option Explicit

Dim iWallpaperFromDirectory As Integer
Dim iSelectionMethod As Integer

Sub BrowseDirectory ()
    Dim Attribs As Integer
    Dim StartOfDir As Integer
    Dim ErrorMsg As String
    Dim InitialDir As String
    Dim TheDir As String
    Dim TheDrive As String
    Dim TheFile As String

    Load fGetWallDirectory
    InitialDir = Trim(WallpaperListEditBox(0).Text) + "\"
    If InitialDir = "" Then
        InitialDir = IniSetting(IniDirectory, IniValue)
    End If
    Do While Right(InitialDir, 2) = "\\"
        InitialDir = Left(InitialDir, Len(InitialDir) - 1)
    Loop

    On Error Resume Next
    '53 File Not Found (bad path)
    '64 Bad File Name (bad syntax)
    '68 Device Unavailable  (wrong drive)
    '76 Path Not Found (filename instead of directory)
    fGetWallDirectory.ListDirectories.Path = InitialDir
    If Err <> 0 Then
       ErrorMsg = "Invalid directory specified." + Chr$(13) + "The Windows directory will be used."
       MsgBox ErrorMsg, MB_OK Or MB_ICONEXCLAMATION, WindowTitle$
       On Error GoTo 0
       InitialDir = GetWindowsDir()
    End If
    
    ParseFileSpec InitialDir, TheDrive, TheDir, TheFile
    InitialDir = TheDrive + TheDir
    
    'TheDrive = Mid$(InitialDir, 1, StartOfDir - 1)
    fGetWallDirectory.ListDrives.Drive = TheDrive
    WallpaperListEditBox(0).Text = InitialDir
    fGetWallDirectory.InitialDir = InitialDir
    fGetWallDirectory.ListDirectories.Path = InitialDir
    fGetWallDirectory.Show 1

    If WallpaperListEditBox(0).Text <> fGetWallDirectory.ListDirectories.Path Then
        WallpaperListEditBox(0).Text = fGetWallDirectory.ListDirectories.Path
    End If
    
    Unload fGetWallDirectory
End Sub

Sub ButtonBrowse_Click (Index As Integer)
    If Index = 0 Then
        BrowseDirectory
    Else
        DlgCommon.DefaultExt = ".TXT"
        DlgCommon.DialogTitle = "Select Wallpaper List File"
        DlgCommon.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*"
        DlgCommon.Flags = OFN_HIDEREADONLY
        DlgCommon.InitDir = IniSetting(IniDirectory, IniValue)

        DlgCommon.Action = 1
        WallpaperListEditBox(1).Text = DlgCommon.Filename
    End If
End Sub

Sub ButtonCancel_Click ()
    Unload Me
End Sub

Sub ButtonChangeNow_Click ()
    ChangeWallpaper
End Sub

Sub ButtonOK_Click ()
    IniSetting(IniChangeFrequency, IniValue) = Val(EditChangeFreq.Text)
    IniSetting(IniDirectory, IniValue) = WallpaperListEditBox(0).Text
    IniSetting(IniListFile, IniValue) = WallpaperListEditBox(1).Text
    IniSetting(IniSelectionMethod, IniValue) = iSelectionMethod
    IniSetting(IniTile, IniValue) = CheckTile.Value
    IniSetting(IniWallpaperFromDirectory, IniValue) = iWallpaperFromDirectory
    
    SaveIniSettings IniMin, IniMax
    Unload Me
End Sub

Sub ClickSelectionMethod (Index)
    SelectionMethod(Index).Value = True
End Sub

Sub ClickWallpaperList (Index)
    WallpaperList(Index).Value = True
End Sub

Sub Form_Load ()
    CenterForm Me
    ClickWallpaperList IniSetting(IniWallpaperFromDirectory, IniValue)
    ClickSelectionMethod IniSetting(IniSelectionMethod, IniValue)
    WallpaperListEditBox(0).Text = IniSetting(IniDirectory, IniValue)
    WallpaperListEditBox(1).Text = IniSetting(IniListFile, IniValue)
    CheckTile = IniSetting(IniTile, IniValue)
    EditChangeFreq.Text = Mid$(Str$(IniSetting(IniChangeFrequency, IniValue)), 2)
End Sub

Sub SelectionMethod_Click (Index As Integer, Value As Integer)
    iSelectionMethod = Index
End Sub

Sub SpinUpdateFreq_SpinDown ()
    Dim OldVal

    OldVal = Val(EditChangeFreq.Text)

    If OldVal = 1 Then
        EditChangeFreq.Text = MaxMinutes$
    Else
        EditChangeFreq.Text = Mid$(Str$(OldVal - 1), 2)
    End If
End Sub

Sub SpinUpdateFreq_SpinUp ()
    Dim OldVal

    OldVal = Val(EditChangeFreq.Text)

    If OldVal = MaxMinutes$ Then
        EditChangeFreq.Text = 1
    Else
        EditChangeFreq.Text = Mid$(Str$(OldVal + 1), 2)
    End If
End Sub

Sub WallpaperList_Click (Index As Integer, Value As Integer)
    iWallpaperFromDirectory = Index
    'WallpaperList(Index).Value = Value

'    WallpaperList(1 - Index).Value = Not Value
    ButtonBrowse(Index).Enabled = Value
    ButtonBrowse(1 - Index).Enabled = Not Value
    WallpaperListEditBox(Index).Enabled = Value
    WallpaperListEditBox(1 - Index).Enabled = Not Value

    If Index = 0 Then
        CheckTile.Enabled = True
    Else
        CheckTile.Enabled = False
    End If
End Sub

Sub WallpaperListEditBox_Change (Index As Integer)
    WallpaperListEditBox(Index).Text = Trim(WallpaperListEditBox(Index))
End Sub

