VERSION 2.00
Begin Form fSelectionOptions 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Selection Options"
   ClientHeight    =   4050
   ClientLeft      =   4785
   ClientTop       =   2445
   ClientWidth     =   5820
   ForeColor       =   &H00000000&
   Height          =   4455
   KeyPreview      =   -1  'True
   Left            =   4725
   LinkTopic       =   "fSelectionOptions"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4050
   ScaleWidth      =   5820
   Top             =   2100
   Width           =   5940
   Begin CommandButton ButtonChangeNow 
      Caption         =   "Change &Now"
      Height          =   375
      Left            =   4320
      TabIndex        =   12
      Top             =   2880
      Width           =   1300
   End
   Begin TextBox EditChangeFreq 
      Height          =   286
      Left            =   1800
      TabIndex        =   11
      Top             =   2925
      Width           =   735
   End
   Begin SpinButton SpinUpdateFreq 
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Left            =   2520
      ShadowBackColor =   &H00C0C0C0&
      TdThickness     =   1
      Top             =   2925
      Width           =   255
   End
   Begin SSFrame GrpSelMethod 
      Caption         =   "Selection Method"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   690
      Left            =   135
      TabIndex        =   7
      Top             =   2070
      Width           =   5505
      Begin SSOption SelectionMethod 
         Caption         =   "&Sequential"
         Font3D          =   0  'None
         ForeColor       =   &H00000000&
         Height          =   285
         Index           =   1
         Left            =   1485
         TabIndex        =   9
         Top             =   270
         Width           =   1230
      End
      Begin SSOption SelectionMethod 
         Caption         =   "&Random"
         Font3D          =   0  'None
         ForeColor       =   &H00000000&
         Height          =   285
         Index           =   0
         Left            =   135
         TabIndex        =   8
         Top             =   270
         Width           =   1005
      End
   End
   Begin CommandButton ButtonCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2925
      TabIndex        =   14
      Top             =   3510
      Width           =   1300
   End
   Begin SSFrame GrpWallPaperSource 
      Caption         =   "Wallpaper Source"
      Font3D          =   0  'None
      Height          =   1860
      Left            =   135
      TabIndex        =   0
      Top             =   90
      Width           =   5505
      Begin CommandButton ButtonEditCustomList 
         Caption         =   "&Edit..."
         Height          =   375
         Index           =   1
         Left            =   1530
         TabIndex        =   6
         Top             =   1305
         Width           =   1230
      End
      Begin SSCheck CheckTile 
         Caption         =   "&Tile Wallpaper"
         Font3D          =   0  'None
         Height          =   285
         Left            =   360
         TabIndex        =   4
         Top             =   945
         Width           =   1545
      End
      Begin CommandButton ButtonBrowseWallDir 
         Caption         =   "&Browse..."
         Height          =   375
         Left            =   4140
         TabIndex        =   3
         Top             =   585
         Width           =   1230
      End
      Begin TextBox EditWallpaperDirectory 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   360
         TabIndex        =   2
         Top             =   630
         Width           =   3615
      End
      Begin SSOption WallpaperSource 
         Caption         =   "&Custom List"
         Font3D          =   0  'None
         Height          =   285
         Index           =   1
         Left            =   135
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   1350
         Width           =   1275
      End
      Begin SSOption WallpaperSource 
         Caption         =   "&Directory"
         Font3D          =   0  'None
         Height          =   285
         Index           =   0
         Left            =   135
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   315
         Width           =   1140
      End
   End
   Begin CommandButton ButtonOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   1395
      TabIndex        =   13
      Top             =   3510
      Width           =   1300
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "minutes"
      Height          =   285
      Left            =   2880
      TabIndex        =   15
      Top             =   2970
      Width           =   690
   End
   Begin Label LblUpdateFreq 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Update &Frequency"
      Height          =   285
      Left            =   135
      TabIndex        =   10
      Top             =   2970
      Width           =   1635
   End
End
Option Explicit

Dim iWallpaperSource As Integer
Dim iSelectionMethod As Integer

Sub ButtonBrowseWallDir_Click ()
    Dim InitialDir As String
    Dim TheDir As String
    Dim TheDrive As String
    Dim TheFile As String

    InitialDir = Trim(EditWallpaperDirectory.Text)
    If InitialDir = "" Then
        InitialDir = IniSetting(IniDirectory, IniValue)
    End If
    InitialDir = StrToDir(InitialDir)
    If ValidateDirectory(InitialDir) <> ERR_NONE Then
        Exit Sub
    End If

    ParseFileSpec InitialDir, TheDrive, TheDir, TheFile
    InitialDir = TheDrive + TheDir
    
    Load fGetWallDirectory
    fGetWallDirectory.ListDrives.Drive = TheDrive
    fGetWallDirectory.ListDirectories.Path = InitialDir
    fGetWallDirectory.Show 1
    
    If fGetWallDirectory.ButtonPushed = IDOK Then
        EditWallpaperDirectory.Text = fGetWallDirectory.ListDirectories.Path
    End If
    
    Unload fGetWallDirectory
End Sub

Sub ButtonCancel_Click ()
    Unload Me
End Sub

Sub ButtonChangeNow_Click ()
    ChangeWallpaper
End Sub

Sub ButtonEditCustomList_Click (Index As Integer)
    fEditCustomList.Show 1
End Sub

Sub ButtonOK_Click ()
    Dim PrevMode As Integer

    If ValidateDirectory(EditWallpaperDirectory) <> ERR_NONE Then
        Exit Sub
    End If
    
    IniSetting(IniChangeFrequency, IniValue) = Val(EditChangeFreq.Text)
    IniSetting(IniDirectory, IniValue) = EditWallpaperDirectory.Text
    IniSetting(IniSelectionMethod, IniValue) = iSelectionMethod
    
    IniSetting(IniTile, IniValue) = TileStrToTile(CheckTile)
    IniSetting(IniWallpaperSource, IniValue) = iWallpaperSource
    SaveIniSettings IniMinSelectionSettings, IniMaxSelectionSettings
    
    PrevMode = Mode
    Mode = Mode Or ModeUpdateComboBox
    FillBitmapFilesListBox
    Mode = PrevMode
    Unload Me
End Sub

Sub EditWallpaperDirectory_Change ()
    EditWallpaperDirectory.Text = Trim(EditWallpaperDirectory)
End Sub

Sub Form_KeyPress (KeyAscii As Integer)
    If KeyAscii = KEY_ESCAPE Then
        ButtonCancel_Click
    End If
End Sub

Sub Form_Load ()
    CenterForm Me
    WallpaperSource(IniSetting(IniWallpaperSource, IniValue)) = True
    SelectionMethod(IniSetting(IniSelectionMethod, IniValue)) = True
    EditWallpaperDirectory.Text = IniSetting(IniDirectory, IniValue)
    CheckTile = IniSetting(IniTile, IniValue) = TileFile
    EditChangeFreq.Text = Mid$(Str$(IniSetting(IniChangeFrequency, IniValue)), 2)
End Sub

Sub SelectionMethod_Click (Index As Integer, Value As Integer)
    iSelectionMethod = Index
End Sub

Sub SpinUpdateFreq_SpinDown ()
    Dim OldVal

    OldVal = Val(EditChangeFreq.Text)

    If OldVal = 1 Then
        EditChangeFreq.Text = MaxMinutes$
    Else
        EditChangeFreq.Text = Mid$(Str$(OldVal - 1), 2)
    End If
End Sub

Sub SpinUpdateFreq_SpinUp ()
    Dim OldVal

    OldVal = Val(EditChangeFreq.Text)

    If OldVal = MaxMinutes$ Then
        EditChangeFreq.Text = 1
    Else
        EditChangeFreq.Text = Mid$(Str$(OldVal + 1), 2)
    End If
End Sub

Function ValidateDirectory (aDirectory As Variant) As Integer
    Dim ErrorCode As Integer
    Dim ErrorMsg As String

    ErrorCode = IsValidDirectory(aDirectory)
    If ErrorCode <> ERR_NONE Then
        ErrorMsg = Error(ErrorCode) + Chr$(13) + "The Windows directory will be used."
        If MsgBox(ErrorMsg, MB_OKCANCEL Or MB_ICONEXCLAMATION, WindowTitle$) = IDCANCEL Then
            ValidateDirectory = Err
            Exit Function
        Else
            aDirectory = GetWindowsDir()
            ValidateDirectory = ERR_NONE
        End If
    End If
End Function

Sub WallpaperSource_Click (Index As Integer, Value As Integer)
    iWallpaperSource = Index
End Sub

