#ifndef lint
static char sccsid[] = "@(#)usleep.c	1.3 91/05/24 XLOCK";
#endif
/*-
 * usleep.c - OS dependant implementation of usleep().
 *
 * Copyright (c) 1991 by Patrick J. Naughton.
 *
 * Revision History:
 * 30-Aug-90: written.
 *
 * 3/1/95: Altered to work with MSDOS and MS Windows. Perry Sloope
 */
#ifdef MSDOS
#include<dos.h>
#include<time.h>
#include<stdlib.h>
#endif
#ifdef MSWIN
#include<windows.h>
#include<time.h>
#endif




int
usleep(unsigned long usec)
{
   long count,loops,count2 = -1;
   static long loopdelay = 0;
   clock_t start,end;

#ifdef MSDOS
    delay(usec);
#endif
#ifdef MSWIN                                //PKS

    if (loopdelay == 0)
    {
       count = GetTickCount();
//    i = GetTimerResolution();
       loops = 0;
       end = 0;
       while ((start = GetTickCount()) == count);  // Find start of a time update.
       while (((end = GetTickCount()) == start) && (loops > count2))loops++; // Count number of loops between updates.
       loopdelay = loops/(end-start);
    }
    else
    {
       count = usec*loopdelay;
       loops = 0;
       start = -1;
       while (((end = GetTickCount()) != start) && (loops < count))loops++;
    }

#endif

#ifdef SYSV
    poll((struct poll *) 0, (size_t) 0, usec / 1000);	/* ms resolution */
#else
  #ifndef MSDOS
    #ifndef MSWIN
       struct timeval timeout;
       timeout.tv_usec = usec % (unsigned long) 1000000;
       timeout.tv_sec = usec / (unsigned long) 1000000;
       select(0, (void *) 0, (void *) 0, (void *) 0, &timeout);
    #endif
 #endif
#endif
    return 0;
}

/*
 * returns the number of seconds since 01-Jan-70.
 * This is used to control rate and timeout in many of the animations.
 */
long
seconds()
{
#if defined(MSDOS) || defined(MSWIN)
    time_t t;

    t = time(NULL);
    return t;
#else
    struct timeval now;

    gettimeofday(&now, (struct timezone *) 0);
    return now.tv_sec;
#endif
}
