/*
 * InterViews class browser main program.
 */

#include "classbuffer.h"
#include "iclass.h"

#include <InterViews/world.h>

#include <string.h>

/*****************************************************************************/

#ifdef XD88
static PropertyData properties[] = {
    { "*Dialog*Message*font",       "*helvetica-bold-r-normal--17*" },
    { "*Message*font",              "*helvetica-bold-r-normal--14*" },
    { "*PulldownMenu*Message*font", "*helvetica-bold-r-normal--17*" },
    { "*PushButton*font",           "*helvetica-bold-r-normal--17*" },
    { "*StringBrowser*font",        "*helvetica-bold-r-normal--14*" },
    { "*StringEditor*font",         "*helvetica-bold-r-normal--14*" },
    { "*recursive",                 "false" },
    { "*verbose",                   "false" },
    { "*showButton",                "true" },
    { nil }
};
#else
static PropertyData properties[] = {
    { "*Dialog*Message*font",       "SYSTEM_FONT" },
    { "*Message*font",              "SYSTEM_FONT" },
    { "*PulldownMenu*Message*font", "SYSTEM_FONT" },
    { "*font",                      "SYSTEM_FONT" },
    { "*StringBrowser*font",        "SYSTEM_FONT" },
    { "*StringEditor*font",         "SYSTEM_FONT" },
    { "*recursive",                 "false" },
    { "*verbose",                   "false" },
    { "*showButton",                "true" },
    { nil }
};
#endif

static OptionDesc options[] = {
    { "-r", "*recursive", OptionValueImplicit, "true" },
    { "-v", "*verbose", OptionValueImplicit, "true" },
    { nil }
};

/*****************************************************************************/

int IVMain (int argc, char** argv) {
    World* world = new World("iclass", properties, options, argc, argv);
    const char* recursive = world->GetAttribute("recursive");
    const char* verbose = world->GetAttribute("verbose");
    ClassBuffer* buffer = new ClassBuffer(
        strcmp(recursive, "true") == 0, strcmp(verbose, "true") == 0
    );

    for (int i = 1; i < argc; ++i) {
        buffer->Search(argv[i]);
    }

    IClass* iclass = new IClass(buffer);
    iclass->SetName("InterViews class browser");
    iclass->SetIconName("iclass");

    world->InsertApplication(iclass);
    iclass->Run();
    return 0;
}
