/*
 *   MS Windows dependent Canvas code
 */

#include <InterViews\itable.h>
#include <Interviews\canvas.h>
#include <Interviews\color.h>
#include <Interviews\world.h>
#include <Interviews\X11\worldrep.h>
#include <string.h>

CanvasRep::CanvasRep () {
    brush = GetStockObject(WHITE_BRUSH);
}

CanvasRep::~CanvasRep () {
    if (brush != GetStockObject(WHITE_BRUSH)) {
	DeleteObject(brush);
    }
}

Canvas::Canvas (void* c) {
    id = c;
    width = 0;
    height = 0;
    status = CanvasUnmapped;
    rep = new CanvasRep;
}

Canvas::Canvas (int w, int h) {
    width = w;
    height = h;
    status = CanvasOffscreen;
    rep = new CanvasRep;
}

Canvas::~Canvas () {
    if (id != nil && id != (void*)GetDesktopWindow()) {
	if (status == CanvasOffscreen) {
	} else {
	    char class_name[9];
	    GetClassName((HWND)id, class_name, 9);
	    DestroyWindow((HWND)id);
	    if (strcmpi(class_name, "IVChild")) {
		 UnregisterClass(class_name, _world->hinstance());
	    }
	    _world->itable()->Remove(id);
	}
	id = nil;
    }
    delete rep;
}

void* Canvas::GetBackground () {
    return ((void*)rep->brush);
}

void Canvas::WaitForCopy () {
 }

void Canvas::SetBackground (Color* c) {
    ColorIntensity r, g, b;

    c->DisplayIntensities(r, g, b);
    if (rep->brush != GetStockObject(WHITE_BRUSH)) {
	DeleteObject(rep->brush);
    }
    rep->brush = CreateSolidBrush(RGB(r, g, b));
}

void Canvas::Clip (Coord, Coord, Coord, Coord) {
    /* Canvas clipping unimplemented for X11. */
}

void Canvas::NoClip () {
    /* Canvas clipping unimplemented for X11. */
}

void Canvas::ClipOn () {
    /* Canvas clipping unimplemented for X11. */
}

void Canvas::ClipOff () {
    /* Canvas clipping unimplemented for X11. */
}

boolean Canvas::IsClipped () {
    return false;
}

void Canvas::Map (Coord& x, Coord& y) {
    /* nothing to do */
}
