Option Explicit
DefInt A-Z

Dim mCaptionRect As RECT
Type BASICPRINTPROPERTIES_TYPE
   fSize As Single
   nHeight As Integer
   nDescent As Integer
End Type

Dim mBasicPrint(4) As BASICPRINTPROPERTIES_TYPE
Dim mHeadingPrint(2) As BASICPRINTPROPERTIES_TYPE

Type DEFAULT_TYPE
    sName As String
    bBold As Integer
    bItalic As Integer
    sColor As String
End Type
Dim mDefault(4) As DEFAULT_TYPE

Dim mnColumnWidth(18)

' Assigns properties to each element.
' Only called by DescribeTable.
Sub Assign_Properties (ByVal vbLanAct As Integer)
Dim N
Dim m

'
' Assign properties to each element.
'

Element(0).nProperty = 0   'Longest strings element has no special properties.

' Columns 1 & 2
For N = 1 To 2
    For m = 2 To 7
	Element(AtomicNumberAtThisSpot(N, m)).nProperty = S_BLOCK
    Next m
Next N
Element(1).nProperty = S_BLOCK Or GAS Or NONMETAL
Element(55).nProperty = S_BLOCK Or LIQUID
Element(87).nProperty = S_BLOCK Or LIQUID

' Columns 3 to 12
For N = 104 To gnNumberOfElements
    Element(N).nProperty = ARTIFICIAL
Next N
Element(43).nProperty = ARTIFICIAL
Element(80).nProperty = LIQUID

' Column 13
Element(5).nProperty = P_BLOCK Or NONMETAL
For m = 3 To 6
    Element(AtomicNumberAtThisSpot(13, m)).nProperty = P_BLOCK
Next m

' Column 14
Element(6).nProperty = P_BLOCK Or NONMETAL
Element(14).nProperty = P_BLOCK Or METALLOID
Element(32).nProperty = P_BLOCK Or METALLOID
Element(50).nProperty = P_BLOCK
Element(82).nProperty = P_BLOCK


' Column 15
Element(7).nProperty = P_BLOCK Or GAS Or NONMETAL
Element(15).nProperty = P_BLOCK Or NONMETAL
Element(33).nProperty = P_BLOCK Or METALLOID
Element(51).nProperty = P_BLOCK Or METALLOID
Element(83).nProperty = P_BLOCK

' Column 16
Element(8).nProperty = P_BLOCK Or GAS Or NONMETAL
Element(16).nProperty = P_BLOCK Or NONMETAL
Element(34).nProperty = P_BLOCK Or NONMETAL
Element(52).nProperty = P_BLOCK Or METALLOID
Element(84).nProperty = P_BLOCK Or METALLOID

' Column 17
Element(9).nProperty = P_BLOCK Or GAS Or NONMETAL
Element(17).nProperty = P_BLOCK Or GAS Or NONMETAL
Element(31).nProperty = P_BLOCK Or LIQUID
Element(35).nProperty = P_BLOCK Or LIQUID Or NONMETAL
Element(53).nProperty = P_BLOCK Or NONMETAL
Element(85).nProperty = P_BLOCK Or METALLOID

' Column 18
Element(2).nProperty = S_BLOCK Or GAS Or NONMETAL
For N = 2 To 6
    Element(AtomicNumberAtThisSpot(18, N)).nProperty = P_BLOCK Or GAS Or NONMETAL
Next N


' vbLanAct tells whether the lanthanides and actinides begin
' with Ce and Th, the default, or with La and Ac.
' vbLanAct = 0 for default, +1 for other.

' Lanthanides & Actinides
Element(57).nProperty = 0  ' 0 is Basic properties.
Element(71).nProperty = 0
Element(89).nProperty = 0
Element(103).nProperty = ARTIFICIAL
For N = 58 - vbLanAct To 71 - vbLanAct
    Element(N).nProperty = F_BLOCK
Next N
Element(61).nProperty = F_BLOCK Or ARTIFICIAL

Element(90 - vbLanAct).nProperty = F_BLOCK
Element(91 - vbLanAct).nProperty = F_BLOCK
Element(92 - vbLanAct).nProperty = F_BLOCK
For N = 93 - vbLanAct To 103 - vbLanAct
    Element(N).nProperty = F_BLOCK Or ARTIFICIAL
    ' ARTIFICIAL doesn't, of course depend on vbLanAct; hence, the next line.
Next N
Element(92).nProperty = F_BLOCK

End Sub

' Makes the first letter of element names capitals or lowercase.
' vbCapital:    if 0, makes lowercase
'              if anything else, makes capital
Sub ChangeCaps (ByVal vbCapital As Integer)
Dim N
If vbCapital = 0 Then
    For N = 1 To gnNumberOfElements
	Element(N).sName = LCase$(Element(N).sName)
    Next N
Else
    For N = 1 To gnNumberOfElements
	Mid(Element(N).sName, 1, 1) = UCase(Mid(Element(N).sName, 1, 1))
    Next N
End If
End Sub

' Assigns a row and column to each element, and tells which
' element is at a row and column position (AtomicNumberAtThisSpot).
Sub DescribeTable ()
Dim N
Dim m
Dim bLanAct

' Set the values in the row array.
' This tells which row a given element is in.
      ' Element(0) holds the longest field strings.
Element(0).iRow = 4
Element(0).iCol = 10

Element(1).iRow = 1
Element(1).iCol = 1
AtomicNumberAtThisSpot(1, 1) = 1
Element(2).iRow = 1
Element(2).iCol = 18
AtomicNumberAtThisSpot(18, 1) = 2
For N = 1 To 8
    ' Elements 3 - 10
    If N > 2 Then
	' Here, M is the column.
	m = N + 10
    Else
	m = N
    End If
    Element(N + 2).iCol = m
    Element(N + 2).iRow = 2
    AtomicNumberAtThisSpot(m, 2) = N + 2
    ' Elements 11 - 18
    Element(N + 10).iCol = m
    Element(N + 10).iRow = 3
    AtomicNumberAtThisSpot(m, 3) = N + 10
Next N

' bLanAct tells whether the lanthanides and actinides begin
' with Ce and Th, the default, or with La and Ac.
bLanAct = -frmPeriodic.mnuOptionsLanDefine(1).Checked
' bLanAct = 0 for default, +1 for other.
For N = 1 To 18
    ' Elements 19 - 36
    Element(N + 18).iCol = N
    Element(N + 18).iRow = 4
    AtomicNumberAtThisSpot(N, 4) = N + 18
    ' Elements 37 - 54
    Element(N + 36).iCol = N
    Element(N + 36).iRow = 5
    AtomicNumberAtThisSpot(N, 5) = N + 36
    ' Elements 55 - 57, and 72-86
    If N > 3 - bLanAct Then m = 68 Else m = 54
    Element(N + m).iCol = N
    Element(N + m).iRow = 6
    AtomicNumberAtThisSpot(N, 6) = N + m
    If N + 86 + 14 <= gnNumberOfElements Then
	' Elements 87 - 89, and 104 - gnNumberOfElements
	If N > 3 - bLanAct Then m = 100 Else m = 86
	Element(N + m).iCol = N
	Element(N + m).iRow = 7
	AtomicNumberAtThisSpot(N, 7) = N + m
    End If
Next N

For N = 4 To 17
    ' Elements 58 - 71 (or 57 - 70)
    Element(N + 54 - bLanAct).iCol = N
    Element(N + 54 - bLanAct).iRow = 8
    AtomicNumberAtThisSpot(N, 8) = N + 54 - bLanAct
    ' Elements 90 - 103 (or 89 - 102)
    Element(N + 86 - bLanAct).iCol = N
    Element(N + 86 - bLanAct).iRow = 9
    AtomicNumberAtThisSpot(N, 9) = N + 86 - bLanAct
Next N

' The Element(-1) signals to print the Table caption.
Element(-1).iCol = 8
Element(-1).iRow = 1
AtomicNumberAtThisSpot(8, 1) = -1

Assign_Properties (bLanAct)
End Sub

' Selects the font name and attributes for a field
' according to the group the element to show belongs to.
' Input:    viField
' Global:   giElementToShow
' Output:   rsWorkName   font name
'           rbWorkBold        bold
'           rbWorkItalic      italic
'           rlWorkColor       color
'
Sub Get_Property_Work (ByVal viField As Integer, rsWorkName As String, rbWorkBold, rbWorkItalic, rlWorkColor As Long)

' Initialize to Basic properties.
rsWorkName = TheGroup(0).TheField(viField).sName
rbWorkBold = TheGroup(0).TheField(viField).nBold
rbWorkItalic = TheGroup(0).TheField(viField).nItalic
rlWorkColor = TheGroup(0).TheField(viField).lColor

If frmPeriodic.mnuGroupActiveChoice(0).Checked Then
    ' s, p, d, and f block elements chosen.
    If Element(giElementToShow).nProperty And S_BLOCK Then
	If TheGroup(6).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(6).TheField(viField).sName
	End If
	If TheGroup(6).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(6).TheField(viField).nBold
	End If
	If TheGroup(6).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(6).TheField(viField).nItalic
	End If
	If TheGroup(6).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(6).TheField(viField).lColor
	End If
    ElseIf Element(giElementToShow).nProperty And P_BLOCK Then
	If TheGroup(7).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(7).TheField(viField).sName
	End If
	If TheGroup(7).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(7).TheField(viField).nBold
	End If
	If TheGroup(7).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(7).TheField(viField).nItalic
	End If
	If TheGroup(7).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(7).TheField(viField).lColor
	End If
    ElseIf Element(giElementToShow).nProperty And F_BLOCK Then
	If TheGroup(8).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(8).TheField(viField).sName
	End If
	If TheGroup(8).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(8).TheField(viField).nBold
	End If
	If TheGroup(8).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(8).TheField(viField).nItalic
	End If
	If TheGroup(8).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(8).TheField(viField).lColor
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(1).Checked Then
    ' Non-terrestrial elements chosen.
    If Element(giElementToShow).nProperty And ARTIFICIAL Then
	If TheGroup(1).TheField(viField).sName <> "" Then
	    ' In other words, don't change back to "Basic"; that would undo
	    ' changes made by the s, p, and f groups.
	    rsWorkName = TheGroup(1).TheField(viField).sName
	End If
	If TheGroup(1).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(1).TheField(viField).nBold
	End If
	If TheGroup(1).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(1).TheField(viField).nItalic
	End If
	If TheGroup(1).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(1).TheField(viField).lColor
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(2).Checked Then
    ' Metalloid and non-metal elements chosen.
    If Element(giElementToShow).nProperty And NONMETAL Then
       ' Test if non-metal.
	If TheGroup(3).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(3).TheField(viField).sName
	End If
	If TheGroup(3).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(3).TheField(viField).nBold
	End If
	If TheGroup(3).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(3).TheField(viField).nItalic
	End If
	If TheGroup(3).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(3).TheField(viField).lColor
	End If
    ElseIf Element(giElementToShow).nProperty And METALLOID Then
	' Test if Metalloid
	If TheGroup(2).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(2).TheField(viField).sName
	End If
	If TheGroup(2).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(2).TheField(viField).nBold
	End If
	If TheGroup(2).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(2).TheField(viField).nItalic
	End If
	If TheGroup(2).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(2).TheField(viField).lColor
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(3).Checked Then
    ' Gases and liquids chosen.
    If Element(giElementToShow).nProperty And GAS Then
	' Test if gas.
	If TheGroup(4).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(4).TheField(viField).sName
	End If
	If TheGroup(4).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(4).TheField(viField).nBold
	End If
	If TheGroup(4).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(4).TheField(viField).nItalic
	End If
	If TheGroup(4).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(4).TheField(viField).lColor
	End If
    ElseIf Element(giElementToShow).nProperty And LIQUID Then
	' Test if liquid.
	If TheGroup(5).TheField(viField).sName <> "" Then
	    rsWorkName = TheGroup(5).TheField(viField).sName
	End If
	If TheGroup(5).TheField(viField).nBold <> 1 Then
	    rbWorkBold = TheGroup(5).TheField(viField).nBold
	End If
	If TheGroup(5).TheField(viField).nItalic <> 1 Then
	    rbWorkItalic = TheGroup(5).TheField(viField).nItalic
	End If
	If TheGroup(5).TheField(viField).lColor <> COLORWILDCARD Then
	    rlWorkColor = TheGroup(5).TheField(viField).lColor
	End If
    End If
End If

End Sub

' Sets the font sizes on the printer.
Sub GetmBasicPrint ()

Dim N
For N = 0 To 3
   ' This accurately sets mBasicPrint(N).fSize.
   Printer.FontSize = 10
   Printer.FontName = TheGroup(0).TheField(N).sName
   Printer.FontSize = Basic(N).fSize
   mBasicPrint(N).fSize = Printer.FontSize
Next N

End Sub

Sub GroupFontProperties (ByVal vnField, ByVal vnIndex, rsName As String, rbBold, rbItalic, rlColor As Long)
   If TheGroup(vnField).TheField(vnIndex).sName = "" Then
      rsName = TheGroup(0).TheField(vnIndex).sName
   Else
      rsName = TheGroup(vnField).TheField(vnIndex).sName
   End If
   If TheGroup(vnField).TheField(vnIndex).nBold = 1 Then
      rbBold = TheGroup(0).TheField(vnIndex).nBold
   Else
      rbBold = TheGroup(vnField).TheField(vnIndex).nBold
   End If
   If TheGroup(vnField).TheField(vnIndex).nItalic = 1 Then
      rbItalic = TheGroup(0).TheField(vnIndex).nItalic
   Else
      rbItalic = TheGroup(vnField).TheField(vnIndex).nItalic
   End If
   If TheGroup(vnField).TheField(vnIndex).lColor = COLORWILDCARD Then
      rlColor = TheGroup(0).TheField(vnIndex).lColor
   Else
      rlColor = TheGroup(vnField).TheField(vnIndex).lColor
   End If

End Sub

Function Help_File_In_Path ()
Dim Path As String, CurrentDir As String
Dim Found, SemiColon
Dim HelpFileName As String
HelpFileName = "PERTABLE.HLP"
On Error Resume Next
    CurrentDir = App.Path
    If Right$(CurrentDir, 1) <> "\" Then CurrentDir = CurrentDir + "\"
    Found = Dir$(CurrentDir + HelpFileName) <> ""
    If Not Found Then
	Path = Environ$("PATH")
	If Path <> "" Then
	    If Right$(Path, 1) <> ";" Then Path = Path + ";"
	    SemiColon = InStr(Path, ";")
	    Do
		CurrentDir = Left$(Path, SemiColon - 1)
		If Right$(CurrentDir, 1) <> "\" Then CurrentDir = CurrentDir + "\"
		Found = Dir$(CurrentDir + HelpFileName) <> ""
		Path = Right$(Path, Len(Path) - SemiColon)
		SemiColon = InStr(Path, ";")
	    Loop While ((SemiColon <> 0) And Not Found)
	End If
    End If
    If Found Then
	gsHelpFilePath = CurrentDir + HelpFileName
	App.HelpFile = gsHelpFilePath
    End If
    Help_File_In_Path = Found
    
    On Error GoTo 0
End Function

Sub Initialize ()
' Check for Help file, and read .dat and .ini files.
Dim sWorkingDir As String
Dim sWorkingDrive As String
Dim sTemp1 As String
Dim sTemp2 As String
Dim nTemp1
Dim Ini_Heading As String, Size, N, m
Dim lP As Long
Dim Msg As String
Dim nProperties

On Error GoTo ErrHandler
NL = Chr(13) & Chr(10)

' Abort if no default printer is selected.
sTemp1 = Space(1024)
Size = GetProfileString("Windows", "Device", "", sTemp1, 1024)
If Size = 0 Then
   MsgBox "A Default printer does not exist.  A default printer must be selected before this program will run.", MB_ICONSTOP, APP_NAME
   End
End If
Printer.ScaleMode = 3   ' Use pixels instead of twips.

' Get the user's choice for units--metric or English--from WIN.INI.
N = GetProfileInt("intl", "iMeasure", 1)  'iMeasure=0 metric; =1 English
If N = 1 Then
   ' Use inches
   gfUnits = 1 / 1440
   gsUnits = "inches"
Else
   ' Use centimeters
   gfUnits = 1 / 567
   gsUnits = "cm"
End If

sWorkingDir = App.Path 'Get application's directory.
If Mid(sWorkingDir, 2, 1) = ":" Then
    sWorkingDrive = Mid(sWorkingDir, 1, 2)
    sWorkingDir = Mid(sWorkingDir, 3)
    If Not sWorkingDir = "\" Then
      sWorkingDir = sWorkingDir & "\"
    End If
Else
    sWorkingDrive = ""   ' Because networks can have no drive. (?)
End If
' This makes gsWorkingDir & gsWorkingDrive refer to "Working
' Directory" in the "Program Item Properties" window.

gsDataFile = sWorkingDrive & sWorkingDir & "PERTABLE.DAT"

If Not Help_File_In_Path() Then
    Msg = "PerTable.hlp not found in your path." + NL + NL
    Msg = Msg + "Windows searches your PATH environment variable for help files, "
    Msg = Msg + "so you need to copy PerTable.hlp to a directory included in your "
    Msg = Msg + "PATH if you wish to obtain help."
    MsgBox Msg, 48, "PerTable's Help File Not Found"
End If

' Initialize the column heading array.
gsColumnHeadingStyle(0, 1) = "1A"
gsColumnHeadingStyle(0, 2) = "2A"
gsColumnHeadingStyle(0, 3) = "3A"
gsColumnHeadingStyle(0, 4) = "4A"
gsColumnHeadingStyle(0, 5) = "5A"
gsColumnHeadingStyle(0, 6) = "6A"
gsColumnHeadingStyle(0, 7) = "7A"
gsColumnHeadingStyle(0, 8) = "L"
gsColumnHeadingStyle(0, 9) = "8A"
gsColumnHeadingStyle(0, 10) = "R"
gsColumnHeadingStyle(0, 11) = "1B"
gsColumnHeadingStyle(0, 12) = "2B"
gsColumnHeadingStyle(0, 13) = "3B"
gsColumnHeadingStyle(0, 14) = "4B"
gsColumnHeadingStyle(0, 15) = "5B"
gsColumnHeadingStyle(0, 16) = "6B"
gsColumnHeadingStyle(0, 17) = "7B"
gsColumnHeadingStyle(0, 18) = "8B"
gsColumnHeadingStyle(1, 1) = "1A"
gsColumnHeadingStyle(1, 2) = "2A"
gsColumnHeadingStyle(1, 3) = "3B"
gsColumnHeadingStyle(1, 4) = "4B"
gsColumnHeadingStyle(1, 5) = "5B"
gsColumnHeadingStyle(1, 6) = "6B"
gsColumnHeadingStyle(1, 7) = "7B"
gsColumnHeadingStyle(1, 8) = "L"
gsColumnHeadingStyle(1, 9) = "8B"
gsColumnHeadingStyle(1, 10) = "R"
gsColumnHeadingStyle(1, 11) = "1B"
gsColumnHeadingStyle(1, 12) = "2B"
gsColumnHeadingStyle(1, 13) = "3A"
gsColumnHeadingStyle(1, 14) = "4A"
gsColumnHeadingStyle(1, 15) = "5A"
gsColumnHeadingStyle(1, 16) = "6A"
gsColumnHeadingStyle(1, 17) = "7A"
gsColumnHeadingStyle(1, 18) = "8A"
gsColumnHeadingStyle(2, 1) = "IA"
gsColumnHeadingStyle(2, 2) = "IIA"
gsColumnHeadingStyle(2, 3) = "IIIA"
gsColumnHeadingStyle(2, 4) = "IVA"
gsColumnHeadingStyle(2, 5) = "VA"
gsColumnHeadingStyle(2, 6) = "VIA"
gsColumnHeadingStyle(2, 7) = "VIIA"
gsColumnHeadingStyle(2, 8) = "L"
gsColumnHeadingStyle(2, 9) = "VIIIA"
gsColumnHeadingStyle(2, 10) = "R"
gsColumnHeadingStyle(2, 11) = "IB"
gsColumnHeadingStyle(2, 12) = "IIB"
gsColumnHeadingStyle(2, 13) = "IIIB"
gsColumnHeadingStyle(2, 14) = "IVB"
gsColumnHeadingStyle(2, 15) = "VB"
gsColumnHeadingStyle(2, 16) = "VIB"
gsColumnHeadingStyle(2, 17) = "VIIB"
gsColumnHeadingStyle(2, 18) = "VIIIB"
gsColumnHeadingStyle(3, 1) = "IA"
gsColumnHeadingStyle(3, 2) = "IIA"
gsColumnHeadingStyle(3, 3) = "IIIB"
gsColumnHeadingStyle(3, 4) = "IVB"
gsColumnHeadingStyle(3, 5) = "VB"
gsColumnHeadingStyle(3, 6) = "VIB"
gsColumnHeadingStyle(3, 7) = "VIIB"
gsColumnHeadingStyle(3, 8) = "L"
gsColumnHeadingStyle(3, 9) = "VIIIB"
gsColumnHeadingStyle(3, 10) = "R"
gsColumnHeadingStyle(3, 11) = "IB"
gsColumnHeadingStyle(3, 12) = "IIB"
gsColumnHeadingStyle(3, 13) = "IIIA"
gsColumnHeadingStyle(3, 14) = "IVA"
gsColumnHeadingStyle(3, 15) = "VA"
gsColumnHeadingStyle(3, 16) = "VIA"
gsColumnHeadingStyle(3, 17) = "VIIA"
gsColumnHeadingStyle(3, 18) = "VIIIA"

' Elements at the top of a row are associated with a heading.
Element(0).iHeading = 9
Element(1).iHeading = 1
Element(4).iHeading = 2
Element(21).iHeading = 3
Element(22).iHeading = 4
Element(23).iHeading = 5
Element(24).iHeading = 6
Element(25).iHeading = 7
Element(26).iHeading = 8
Element(27).iHeading = 9
Element(28).iHeading = 10
Element(29).iHeading = 11
Element(30).iHeading = 12
Element(5).iHeading = 13
Element(6).iHeading = 14
Element(7).iHeading = 15
Element(8).iHeading = 16
Element(9).iHeading = 17
Element(2).iHeading = 18

' Initialize the WildCard Display properties.
TheGroup(-1).TheField(0).sName = ""
TheGroup(-1).TheField(0).nBold = 1
TheGroup(-1).TheField(0).nItalic = 1
TheGroup(-1).TheField(0).lColor = COLORWILDCARD
For N = 1 To 3
   TheGroup(-1).TheField(N) = TheGroup(-1).TheField(0)
Next N

'**************** Read the contents of the initialization file *************
gsTableNumber(0) = "0"
gsTableNumber(1) = "1"
gsTableNumber(2) = "2"
gsTableNumber(3) = "3"
gsTableNumber(4) = "4"

sTemp1 = Space$(144)
' Get all the table captions.
For N = 1 To 4
   Size = GetPrivateProfileString("Periodic Table " & gsTableNumber(N), "Caption", "Default", sTemp1, 144, INI_FILENAME)
   gsTableCaption(N) = Left(sTemp1, Size)
   ' Put the table captions in the file/load menu.
   frmPeriodic.mnuFileLoadChoice(N).Caption = "&" & gsTableNumber(N) & "  " & gsTableCaption(N)
Next N

Ini_Heading = "Periodic Table " & gsTableNumber(giTableNumber)
nProperties = GetPrivateProfileInt(Ini_Heading, "Various_Properties", 0, INI_FILENAME)
lP = 1
' Retrieve the Heading and Table Title properties.
For N = 0 To 2
   If N = 0 Then
      sTemp2 = "HeadingIUPAC_"
   ElseIf N = 1 Then
      sTemp2 = "HeadingIIIVA_"
   Else
      sTemp2 = "TableTitle_"
   End If
      Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Name", "Arial", sTemp1, 144, INI_FILENAME)
   HeadingProperties(N).sName = Left(sTemp1, Size)
      Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Size", "12", sTemp1, 144, INI_FILENAME)
   HeadingProperties(N).nSize = Val(Left(sTemp1, Size))
   
   HeadingProperties(N).bBold = (nProperties And lP) > 0
   lP = lP * 2
   HeadingProperties(N).bItalic = (nProperties And lP) > 0
   lP = lP * 2
      
   HeadingProperties(N).nHeight = GetPrivateProfileInt(Ini_Heading, sTemp2 & "Height", 270, INI_FILENAME)
      Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Color", "0", sTemp1, 144, INI_FILENAME)
   HeadingProperties(N).lColor = Val(Left(sTemp1, Size))
Next N
frmPeriodic.chkTitleSameSize = -((nProperties And 64) > 0)
   Size = GetPrivateProfileString(Ini_Heading, "TableTitle_Caption", "Periodic Table of the Elements", sTemp1, 144, INI_FILENAME)
frmPeriodic.txtTableTitle = Left(sTemp1, Size)

' Basic properties.
For N = 0 To 3
   sTemp2 = "Basic" & N & "_"
   Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Size", "12", sTemp1, 144, INI_FILENAME)
      Basic(N).fSize = Val(Left(sTemp1, Size))
   Basic(N).nHeight = GetPrivateProfileInt(Ini_Heading, sTemp2 & "Height", 270, INI_FILENAME)
   Basic(N).nDescent = GetPrivateProfileInt(Ini_Heading, sTemp2 & "Descent", 45, INI_FILENAME)
			   ' gsTableNumber contains an integer as a string
   ' These next two aren't basic properties.
   Size = GetPrivateProfileString(Ini_Heading, "ItalicChoices" & gsTableNumber(N), "174760", sTemp1, 144, INI_FILENAME)
      glItalicProperty(N) = Val(Left(sTemp1, Size))
   Size = GetPrivateProfileString(Ini_Heading, "BoldChoices" & gsTableNumber(N), "174760", sTemp1, 144, INI_FILENAME)
      glBoldProperty(N) = Val(Left(sTemp1, Size))
Next N
Size = GetPrivateProfileString(Ini_Heading, "BoxFillColor0", "&H00FFFFFF&", sTemp1, 144, INI_FILENAME)
   glBoxFillColor(0) = Val(Left(sTemp1, Size))

For N = 0 To 3
    sTemp2 = "Property0Field" & N & "_"
    
    Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Name", "Arial", sTemp1, 144, INI_FILENAME)
    mDefault(N).sName = Left(sTemp1, Size)
    TheGroup(0).TheField(N).sName = mDefault(N).sName

    TheGroup(0).TheField(N).nBold = -(glBoldProperty(N) And 1)
    mDefault(N).bBold = TheGroup(0).TheField(N).nBold
    
    TheGroup(0).TheField(N).nItalic = -(glItalicProperty(N) And 1)
    mDefault(N).bItalic = TheGroup(0).TheField(N).nItalic
    
    Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Color", "0", sTemp1, 144, INI_FILENAME)
    mDefault(N).sColor = Left(sTemp1, Size)
    TheGroup(0).TheField(N).lColor = Val(mDefault(N).sColor)
Next N

lP = 4 ' The case of lP=1 is handled in the last For loop.
For m = 1 To 8
   For N = 0 To 3
      sTemp2 = "Property" & m & "Field" & N & "_"
      
      Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Name", "", sTemp1, 144, INI_FILENAME)
      TheGroup(m).TheField(N).sName = Left(sTemp1, Size)
      Size = GetPrivateProfileString(Ini_Heading, sTemp2 & "Color", Str$(COLORWILDCARD), sTemp1, 144, INI_FILENAME)
      TheGroup(m).TheField(N).lColor = Val(Left(sTemp1, Size))
      
      If (glItalicProperty(N) And lP) Then
	 TheGroup(m).TheField(N).nItalic = True
      ElseIf (glItalicProperty(N) And 2 * lP) Then
	 TheGroup(m).TheField(N).nItalic = 1
      End If
      If (glBoldProperty(N) And lP) Then
	 TheGroup(m).TheField(N).nBold = True
      ElseIf (glBoldProperty(N) And 2 * lP) Then
	 TheGroup(m).TheField(N).nBold = 1
      End If
   Next N
   lP = lP * 4
   Size = GetPrivateProfileString(Ini_Heading, "BoxFillColor" & m, Str$(COLORWILDCARD), sTemp1, 144, INI_FILENAME)
   glBoxFillColor(m) = Val(Left(sTemp1, Size))
Next m

gbOmitName = (nProperties And 128) > 0
frmPeriodic.chkCapital = -((nProperties And 256) > 0)

' Diagonal line
' Diagonal.Checked and period.Checked are set opposite to actual values.
' Click events in frmPeriodic_Load set it right.
frmPeriodic.mnuOptionsDiagonal.Checked = Not (nProperties And 512) > 0
' Period numbers
frmPeriodic.mnuOptionsPeriod.Checked = Not (nProperties And 1024) > 0
' Width method
frmPeriodic.mnuOptionsWidthMethod(0).Checked = (nProperties And 2048) > 0
frmPeriodic.mnuOptionsWidthMethod(1).Checked = False
frmPeriodic.mnuOptionsWidthMethod(2).Checked = False
If Not frmPeriodic.mnuOptionsWidthMethod(0).Checked Then
   frmPeriodic.mnuOptionsWidthMethod(1).Checked = (nProperties And 4096) > 0
   If Not frmPeriodic.mnuOptionsWidthMethod(1).Checked Then
      frmPeriodic.mnuOptionsWidthMethod(2).Checked = True
   End If
End If

' Column headings
frmPeriodic.chkColHead(0) = -((nProperties And 8192) > 0)
frmPeriodic.chkColHead(1) = -((nProperties And 16384) > 0)
' Line width
    Size = GetPrivateProfileString(Ini_Heading, "LineWidth", "30", sTemp1, 144, INI_FILENAME)
   ' Have to set .Max first, in case it is less than the value, which gives an error.
   ' DrawBox triggers a reset of .Max.
frmPeriodic.hsbLineWidth(0).Max = Val(Left(sTemp1, Size)) / Screen.TwipsPerPixelX
frmPeriodic.hsbLineWidth(0) = frmPeriodic.hsbLineWidth(0).Max
' Diagonal width
    Size = GetPrivateProfileString(Ini_Heading, "DiagonalLineWidth", "120", sTemp1, 144, INI_FILENAME)
frmPeriodic.hsbLineWidth(1).Max = Val(Left(sTemp1, Size)) / Screen.TwipsPerPixelX
frmPeriodic.hsbLineWidth(1) = frmPeriodic.hsbLineWidth(1).Max
' Extra space
    Size = GetPrivateProfileString(Ini_Heading, "ExtraSpace", "0", sTemp1, 144, INI_FILENAME)
frmPeriodic.hsbExtraSpace.Max = Val(Left(sTemp1, Size)) / Screen.TwipsPerPixelX
frmPeriodic.hsbExtraSpace = frmPeriodic.hsbExtraSpace.Max
' The maximum scrollbar values are reset in DrawBox.

' Heading Style
giColumnHeadingStyleChoice = GetPrivateProfileInt(Ini_Heading, "ColumnHeadingStyleChoice", 0, INI_FILENAME)
For N = 0 To 3
   ' Remove all check marks.  (Besides start up, this procedure is also called by file load.)
   frmPeriodic.mnuOptionsHeadingStyle(N).Checked = False
Next N
frmPeriodic.mnuOptionsHeadingStyle(giColumnHeadingStyleChoice).Checked = True

frmPeriodic.hsbMaxFig = GetPrivateProfileInt(Ini_Heading, "SigFigures", 6, INI_FILENAME)
' Line color
    Size = GetPrivateProfileString(Ini_Heading, "LineColor", "0", sTemp1, 144, INI_FILENAME)
glLineColor = Val(Left(sTemp1, Size))
    Size = GetPrivateProfileString(Ini_Heading, "DiagonalColor", "0", sTemp1, 144, INI_FILENAME)
' Diagonal color
glDiagonalColor = Val(Left(sTemp1, Size))
N = GetPrivateProfileInt(Ini_Heading, "Lanthanide/ActinideDefinition", 0, INI_FILENAME)
' Lanthanide/Actinide definition
frmPeriodic.mnuOptionsLanDefine(N).Checked = True
frmPeriodic.mnuOptionsLanDefine(Abs(N - 1)).Checked = Not frmPeriodic.mnuOptionsLanDefine(N).Checked
' Active groups.
N = GetPrivateProfileInt(Ini_Heading, "ActiveChoices", 0, INI_FILENAME)
frmPeriodic.mnuGroupActiveChoice(0).Checked = (N And 1)
frmPeriodic.mnuGroupActiveChoice(1).Checked = (N And 2)
frmPeriodic.mnuGroupActiveChoice(2).Checked = (N And 4)
frmPeriodic.mnuGroupActiveChoice(3).Checked = (N And 8)
' Omit name.
frmPeriodic.chkOmitName = -gbOmitName
frmPeriodic.hsbLineWidth(0).Min = 1 ' Forces at least one hsbLineWidth_Change event.
frmPeriodic.hsbMaxFig.Max = nReadDataFile()' Get element data, number of elements, and longest mass.
frmPeriodic.hsbMaxFig.Enabled = True
frmPeriodic.lblSigFigs = frmPeriodic.hsbMaxFig

' Initialize TextMetric array (used to get text "descender").
    ' Old Heading descent
frmPeriodic.picScroll.FontName = HeadingProperties(1).sName
frmPeriodic.picScroll.FontSize = HeadingProperties(1).nSize
frmPeriodic.picScroll.FontBold = HeadingProperties(1).bBold
frmPeriodic.picScroll.FontItalic = HeadingProperties(1).bItalic
m = GetTextMetrics(frmPeriodic.picScroll.hDC, FontInfo)
gnDescentHeadingOld = FontInfo.tmDescent * Screen.TwipsPerPixelY

ChangeCaps (frmPeriodic.chkCapital)
Max ' Max finds longest name and symol.
DescribeTable
Exit Sub

ErrHandler:
   MsgBox "Unanticipated error encountered.  " & Err & ":  " & Error, MB_ICONSTOP, APP_NAME
   Close 1
   Unload frmPeriodic

End Sub

Function lGet_Color_Box_Fill () As Long
' Returns the box fill color.
Dim lWorkColor As Long
lWorkColor = glBoxFillColor(0)
If frmPeriodic.mnuGroupActiveChoice(0).Checked Then
    ' s, p, d, and f block elements chosen.
    If Element(giElementToShow).nProperty And S_BLOCK Then
	If glBoxFillColor(6) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(6)
	End If
    ElseIf Element(giElementToShow).nProperty And P_BLOCK Then
	If glBoxFillColor(7) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(7)
	End If
    ElseIf Element(giElementToShow).nProperty And F_BLOCK Then
	If glBoxFillColor(8) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(8)
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(1).Checked Then
    ' Non-terrestrial elements chosen.
    If Element(giElementToShow).nProperty And ARTIFICIAL Then
	If glBoxFillColor(1) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(1)
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(2).Checked Then
    ' Metalloid and non-metal elements chosen.
    If Element(giElementToShow).nProperty And NONMETAL Then
	If glBoxFillColor(3) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(3)
	End If
    ElseIf Element(giElementToShow).nProperty And METALLOID Then
	If glBoxFillColor(2) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(2)
	End If
    End If
End If
If frmPeriodic.mnuGroupActiveChoice(3).Checked Then
    ' Gases and liquids chosen.
    If Element(giElementToShow).nProperty And GAS Then
	If glBoxFillColor(4) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(4)
	End If
    ElseIf Element(giElementToShow).nProperty And LIQUID Then
	If glBoxFillColor(5) <> COLORWILDCARD Then
	    lWorkColor = glBoxFillColor(5)
	End If
    End If
End If
lGet_Color_Box_Fill = lWorkColor
End Function

Function lGet_String_Width (ByVal viField, ByVal vMsg As String, ByVal vbSameProperty) As Long

Dim sWorkName As String, bWorkBold, bWorkItalic, lWorkColor As Long
Dim nLetterNumber
Dim lMsgWidth As Long, N

' Don't check property unless different from last time.
If Not vbSameProperty Then
   Get_Property_Work viField, sWorkName, bWorkBold, bWorkItalic, lWorkColor
   If frmPeriodic.picScroll.FontSize <> Basic(viField).fSize Or frmPeriodic.picScroll.FontName <> sWorkName Then
      ' These lines take a long time to process.
      frmPeriodic.picScroll.FontSize = 10
      frmPeriodic.picScroll.FontName = sWorkName
      frmPeriodic.picScroll.FontSize = Basic(viField).fSize
   End If
   frmPeriodic.picScroll.FontBold = bWorkBold
   frmPeriodic.picScroll.FontItalic = bWorkItalic
End If
lMsgWidth = frmPeriodic.picScroll.TextWidth(vMsg)
If bWorkItalic Then
   nLetterNumber = Asc(Left$(vMsg, 1))
   N = GetCharABCWidths(frmPeriodic.picScroll.hDC, nLetterNumber, nLetterNumber, ABCsize)
   If N <> 0 Then
      ' Function was successful (non-TrueType fonts are allowed, which would return 0).
      If ABCsize.abcA < 0 Then
	 ' First character in string has an underhang.  Add to string length.
	 lMsgWidth = lMsgWidth - 2 * ABCsize.abcA * Screen.TwipsPerPixelX
      End If
      nLetterNumber = Asc(Right$(vMsg, 1))
      N = GetCharABCWidths(frmPeriodic.picScroll.hDC, nLetterNumber, nLetterNumber, ABCsize)
      If ABCsize.abcC < 0 Then
	 ' Last character in string has an overhang.  Add to string length.
	 lMsgWidth = lMsgWidth - 2 * ABCsize.abcC * Screen.TwipsPerPixelX
      End If
   End If
End If
lGet_String_Width = lMsgWidth

End Function

Function lGet_String_Width_Printer (ByVal viField, ByVal vMsg As String, ByVal vbSameProperty) As Long

Dim sWorkName As String, bWorkBold, bWorkItalic, lWorkColor As Long
Dim nLetterNumber
Dim lMsgWidth As Long, N

' Don't check property unless different from last time.
If Not vbSameProperty Then
   Get_Property_Work (viField), sWorkName, bWorkBold, bWorkItalic, lWorkColor
   If Printer.FontSize <> mBasicPrint(viField).fSize Or Printer.FontName <> sWorkName Then
      ' These lines take a long time to process.
      Printer.FontSize = 10
      Printer.FontName = sWorkName
      Printer.FontSize = mBasicPrint(viField).fSize
   End If
   Printer.FontBold = bWorkBold
   Printer.FontItalic = bWorkItalic
End If
lMsgWidth = Printer.TextWidth(vMsg)
If bWorkItalic Then
   nLetterNumber = Asc(Left$(vMsg, 1))
   N = GetCharABCWidths(Printer.hDC, nLetterNumber, nLetterNumber, ABCsize)
   If N <> 0 Then
      ' Function was successful (non-TrueType fonts are allowed, which would return 0).
      If ABCsize.abcA < 0 Then
	 ' First character in string has an underhang.  Add to string length.
	 lMsgWidth = lMsgWidth - 2 * ABCsize.abcA
      End If
      nLetterNumber = Asc(Right$(vMsg, 1))
      N = GetCharABCWidths(Printer.hDC, nLetterNumber, nLetterNumber, ABCsize)
      If ABCsize.abcC < 0 Then
	 ' Last character in string has an overhang.  Add to string length.
	 lMsgWidth = lMsgWidth - 2 * ABCsize.abcC
      End If
   End If
End If
lGet_String_Width_Printer = lMsgWidth

End Function

' Determines the width of the widest string
' in the table, or the widest box in a column, depending
' on the setting of mnuOptionsWidthMethod.
' This is widest on the screen; a different function is be used for widest
' on the printer.
' Input value:   an element's column (ignored, if using widest in table)
' Return value:  width of the widest string
Function lWidest_Box (ByVal vColumnToCheck) As Long

Dim N
Dim lTemp As Long
Dim lWidestSoFar As Long
Dim RowToCheck
Dim AnybodyThere
Dim nPropertyLast
Dim nSave

nSave = giElementToShow
If frmPeriodic.mnuOptionsWidthMethod(0).Checked Then
   ' Find the widest symbol in column.
   
   nPropertyLast = -1
   ' The boolean argument (nPropertyLast = Element(AnybodyThere).nProperty)
   ' is passed to the function lGet_String_Width, which in turn calls
   ' nGet_Property_Work if that argument is false.
   For RowToCheck = 1 To 9  ' Check all elements in column.
      AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
      If AnybodyThere > 1 Then  ' Skip if no element at this position.
	 giElementToShow = AnybodyThere
	 lTemp = lGet_String_Width(1, Element(AnybodyThere).sSymbol, (nPropertyLast = Element(AnybodyThere).nProperty))
	 If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(AnybodyThere).nProperty
      End If
   Next RowToCheck
   
   If Not gbOmitName Then
      ' Find the widest name in column.
      nPropertyLast = -1
      For RowToCheck = 1 To 9  ' Check all elements in column.
	 AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
	 If AnybodyThere > 0 Then
	    giElementToShow = AnybodyThere
	    lTemp = lGet_String_Width(2, Element(AnybodyThere).sName, (nPropertyLast = Element(AnybodyThere).nProperty))
	    If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	    End If
	    nPropertyLast = Element(AnybodyThere).nProperty
	 End If
      Next RowToCheck
   End If
   
   ' Find the widest mass in column.
   nPropertyLast = -1
   For RowToCheck = 1 To 9  ' Check all elements in column.
      AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
      If AnybodyThere > 0 Then
	 giElementToShow = AnybodyThere
	 lTemp = lGet_String_Width(3, Element(AnybodyThere).sMass, (nPropertyLast = Element(AnybodyThere).nProperty))
	 If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(AnybodyThere).nProperty
      End If
   Next RowToCheck
   
ElseIf frmPeriodic.mnuOptionsWidthMethod(1).Checked Then
   ' Find the widest string in the entire table.  FAST SEARCH.
   
   ' Find the widest symbol.
   frmPeriodic.picScroll.FontSize = 10
   frmPeriodic.picScroll.FontName = TheGroup(0).TheField(1).sName
   frmPeriodic.picScroll.FontSize = Basic(1).fSize
   frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(1).nBold
   frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(1).nItalic
   For N = 1 To gnNumberOfElements
      lTemp = frmPeriodic.picScroll.TextWidth(Element(N).sSymbol)
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
   Next N
   
   If Not gbOmitName Then
      ' Find the widest name, if wider than widest symbol.
      frmPeriodic.picScroll.FontSize = 10
      frmPeriodic.picScroll.FontName = TheGroup(0).TheField(2).sName
      frmPeriodic.picScroll.FontSize = Basic(2).fSize
      frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(2).nBold
      frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(2).nItalic
      For N = 1 To gnNumberOfElements
	 lTemp = frmPeriodic.picScroll.TextWidth(Element(N).sName)
	 If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	 End If
      Next N
   End If
   
   ' Find the widest mass, if wider than widest name or symbol.
   frmPeriodic.picScroll.FontSize = 10
   frmPeriodic.picScroll.FontName = TheGroup(0).TheField(3).sName
   frmPeriodic.picScroll.FontSize = Basic(3).fSize
   frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(3).nBold
   frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(3).nItalic
   For N = 1 To gnNumberOfElements
      lTemp = frmPeriodic.picScroll.TextWidth(Element(N).sMass)
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
   Next N

Else
   ' Find the widest string in the entire table.  SLOW BUT ACCURATE SEARCH.
   ' The slower search is needed if italics are used.
   
   ' Widest symbol.
   nPropertyLast = -1
   For N = 1 To gnNumberOfElements
      giElementToShow = N
      lTemp = lGet_String_Width(1, Element(N).sSymbol, (nPropertyLast = Element(N).nProperty))
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
      nPropertyLast = Element(N).nProperty
   Next N
   
   If Not gbOmitName Then
      ' Find the widest name, if wider than widest symbol.
      nPropertyLast = -1
      For N = 1 To gnNumberOfElements
	 giElementToShow = N
	 lTemp = lGet_String_Width(2, Element(N).sName, (nPropertyLast = Element(N).nProperty))
	 If lTemp > lWidestSoFar Then
	    lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(N).nProperty
      Next N
   End If
   
   ' Find the widest mass, if wider than widest name or symbol.
   nPropertyLast = -1
   For N = 1 To gnNumberOfElements
      giElementToShow = N
      lTemp = lGet_String_Width(3, Element(N).sMass, (nPropertyLast = Element(N).nProperty))
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
      nPropertyLast = Element(N).nProperty
   Next N

End If
giElementToShow = nSave
lWidest_Box = lWidestSoFar

End Function

' Determines the width of the widest string
' in the table, or the widest box in a column, depending
' on the setting of mnuOptionsWidthMethod.
' This is widest on the printer; lWidest_Box is used for widest
' on the screen.
'
' Input value:   an element's column (ignored, if using widest in table)
' Return value:  width of the widest string
Function lWidest_Box_Printer (ByVal vColumnToCheck) As Long

Dim N
Dim lTemp As Long
Dim lWidestSoFar As Long
Dim RowToCheck
Dim AnybodyThere
Dim nPropertyLast
Dim nSave

nSave = giElementToShow
If frmPeriodic.mnuOptionsWidthMethod(0).Checked Then
   ' Find the widest symbol in column.
   
   nPropertyLast = -1
   ' The boolean argument (nPropertyLast = Element(AnybodyThere).nProperty)
   ' is passed to the function lGet_String_Width_Printer, which in turn calls
   ' nGet_Property_Work if that argument is false.
   For RowToCheck = 1 To 9  ' Check all elements in column.
      AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
      If AnybodyThere > 1 Then  ' Skip if no element at this position.
	 giElementToShow = AnybodyThere
	 lTemp = lGet_String_Width_Printer(1, Element(AnybodyThere).sSymbol, (nPropertyLast = Element(AnybodyThere).nProperty))
	 If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(AnybodyThere).nProperty
      End If
   Next RowToCheck
   
   If Not gbOmitName Then
      ' Find the widest name in column.
      nPropertyLast = -1
      For RowToCheck = 1 To 9  ' Check all elements in column.
	 AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
	 If AnybodyThere > 0 Then
	    giElementToShow = AnybodyThere
	    lTemp = lGet_String_Width_Printer(2, Element(AnybodyThere).sName, (nPropertyLast = Element(AnybodyThere).nProperty))
	    If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	    End If
	    nPropertyLast = Element(AnybodyThere).nProperty
	 End If
      Next RowToCheck
   End If
   
   ' Find the widest mass in column.
   nPropertyLast = -1
   For RowToCheck = 1 To 9  ' Check all elements in column.
      AnybodyThere = AtomicNumberAtThisSpot(vColumnToCheck, RowToCheck)
      If AnybodyThere > 0 Then
	 giElementToShow = AnybodyThere
	 lTemp = lGet_String_Width_Printer(3, Element(AnybodyThere).sMass, (nPropertyLast = Element(AnybodyThere).nProperty))
	 If lTemp > lWidestSoFar Then
	       lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(AnybodyThere).nProperty
      End If
   Next RowToCheck
   
Else
   ' Find the widest string in the entire table.  SLOW BUT ACCURATE SEARCH.
   ' The slower search is needed if italics are used.
   
   ' Widest symbol.
   nPropertyLast = -1
   For N = 1 To gnNumberOfElements
      giElementToShow = N
      lTemp = lGet_String_Width_Printer(1, Element(N).sSymbol, (nPropertyLast = Element(N).nProperty))
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
      nPropertyLast = Element(N).nProperty
   Next N
   
   If Not gbOmitName Then
      ' Find the widest name, if wider than widest symbol.
      nPropertyLast = -1
      For N = 1 To gnNumberOfElements
	 giElementToShow = N
	 lTemp = lGet_String_Width_Printer(2, Element(N).sName, (nPropertyLast = Element(N).nProperty))
	 If lTemp > lWidestSoFar Then
	    lWidestSoFar = lTemp
	 End If
	 nPropertyLast = Element(N).nProperty
      Next N
   End If
   
   ' Find the widest mass, if wider than widest name or symbol.
   nPropertyLast = -1
   For N = 1 To gnNumberOfElements
      giElementToShow = N
      lTemp = lGet_String_Width_Printer(3, Element(N).sMass, (nPropertyLast = Element(N).nProperty))
      If lTemp > lWidestSoFar Then
	 lWidestSoFar = lTemp
      End If
      nPropertyLast = Element(N).nProperty
   Next N

End If
giElementToShow = nSave
lWidest_Box_Printer = lWidestSoFar

End Function

Sub Max ()
Dim N
Dim Temp As Single
Dim Longest As Single
Dim nLongestName
Dim nLongestSymbol

' Determine longest atomic symbol.
frmPeriodic.picScroll.FontSize = 10
frmPeriodic.picScroll.FontName = TheGroup(0).TheField(1).sName
frmPeriodic.picScroll.FontSize = Basic(1).fSize
frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(1).nBold
frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(1).nItalic
Longest = 0
For N = 1 To gnNumberOfElements
    Temp = frmPeriodic.picScroll.TextWidth(Element(N).sSymbol)
    If Temp > Longest Then
	Longest = Temp
	nLongestSymbol = N
    End If
Next N
Element(0).sSymbol = Element(nLongestSymbol).sSymbol

' Determine Element with longest name.
frmPeriodic.picScroll.FontSize = 10
frmPeriodic.picScroll.FontName = TheGroup(0).TheField(2).sName
frmPeriodic.picScroll.FontSize = Basic(2).fSize
frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(2).nBold
frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(2).nItalic
Longest = 0
For N = 1 To gnNumberOfElements
    Temp = frmPeriodic.picScroll.TextWidth(Element(N).sName)
    If Temp > Longest Then
	Longest = Temp
	nLongestName = N
    End If
Next N
Element(0).sName = Element(nLongestName).sName

End Sub

Function nReadDataFile ()
' Open the Data file, get atomic number, symbol, name, & mass.
' Also determine element with longest mass.

Dim N
Dim Longest As Single
Dim Temp As Single
Dim LongestString
Dim Length
Dim Mass As Variant
Dim DecimalPoint
Dim DecimalDigits
Dim LastNumber As Variant
Dim nLongestMass
Dim nScrollbarValue
Dim Msg As String

On Error GoTo ErrDataFile
Open gsDataFile For Input As 1
N = 0
LongestString = 0
nScrollbarValue = frmPeriodic.hsbMaxFig.Value
Do While Not EOF(1)
    N = N + 1
    ' Input the data.
    Input #1, Element(N).sNumber, Element(N).sSymbol, Element(N).sName, Mass
    Length = Len(Mass)
    
    ' LongestString sets the maximum on the sig. fig. scroll bar.
    If Length > LongestString Then LongestString = Length
    
    ' Round off the mass to the desired number of significant figures.
    If Left(Mass, 1) <> "(" Then   ' Ignore numbers in parentheses.
	' Don't change short number strings.
	If Length > nScrollbarValue + 1 Then ' the + 1 is for the decimal point.
	    ' If the truncated digit is 5 or greater, then add 1.
	    LastNumber = Mid(Mass, nScrollbarValue + 2, 1)
	    If LastNumber >= 5 Then
		' Find the decimal point.
		DecimalPoint = InStr(Mass, ".")
		' Find number of digits after decimal point.
		DecimalDigits = nScrollbarValue + 1 - DecimalPoint
		' Add one to what, after truncating, will be the last digit.
		Mass = Mass + 1 * 10 ^ -DecimalDigits
	    End If
	    Mass = Left(Mass, nScrollbarValue + 1)
	    ' Remove the decimal point if it is the last character.
	    If Right(Mass, 1) = "." Then Mass = Left(Mass, nScrollbarValue)
	End If
    End If
    Element(N).sMass = Mass
Loop
Close 1
gnNumberOfElements = N
nReadDataFile = LongestString - 1

' Determine longest mass.
frmPeriodic.picScroll.FontSize = 10
frmPeriodic.picScroll.FontName = TheGroup(0).TheField(3).sName
frmPeriodic.picScroll.FontSize = Basic(3).fSize
frmPeriodic.picScroll.FontBold = TheGroup(0).TheField(3).nBold
frmPeriodic.picScroll.FontItalic = TheGroup(0).TheField(3).nItalic
Longest = 0
For N = 1 To gnNumberOfElements
    Temp = frmPeriodic.TextWidth(Element(N).sMass)
    If Temp > Longest Then
	Longest = Temp
	nLongestMass = N
    End If
Next N
Element(0).sMass = Element(nLongestMass).sMass
Element(0).sNumber = Element(108).sNumber
Exit Function

ErrDataFile:
Select Case Err
   Case 53     ' Couldn't find data file.
      MsgBox "Program ends because the data file was not found:  " & gsDataFile, MB_ICONSTOP, APP_NAME
      Unload frmPeriodic
   Case 76
      MsgBox "Path or drive invalid:  " & gsDataFile, 48, "Reading Data File"
      Unload frmPeriodic
   Case 380
      Msg = "This may occur if a font name in the PERTABLE.INI file is not on this machine.  Program ends."
      MsgBox "Error 380:  " & Error & NL & Msg, MB_ICONSTOP, "Data File"
      Close 1
      Unload frmPeriodic
   Case Else
      MsgBox "Unanticipated error encountered.  " & Err & ":  " & Error, MB_ICONSTOP, "Data File"
      Close 1
      Unload frmPeriodic
End Select
End Function

' Draws the contents of one box, with column heading and period number (if
' requested), on the printer.
'Input:  vnBoxWidth         Box dimensions
'        vnBoxHeight
'        vnHeadingHeight    Heading height
'        vnExtraSpaceTwipsY Extra space in box
'        vlTop              Current page limits--used to skip printing
'        vlBottom                                fields that aren't on
'                                                the present page.
'
'Global: uses giElementToShow, HeadingProperties(), PeriodRect and TheRect,
'        glLineColor, glDiagonalColor, mBasicPrint(), gbOmitName,
'        and Element(giElementToShow).
'
Sub PrintBox (ByVal vnBoxWidth, ByVal vnBoxHeight, ByVal vnHeadingHeight, ByVal vnExtraSpaceLineWidth, ByVal vlTop As Long, ByVal vlBottom As Long, ByVal vnHeadingSpace)
Dim Msg As String
Dim MsgWidth
Dim nFlags
Dim nPosition
Dim nLinePoint1, nLinePoint2  ' Used in old-style headings.
' Line widths and spacings.
Dim nLineWidthHeading
Dim nLineTop, nLineLeft, nLineBottom, nLineRight
Dim nDiagTop, nDiagBottom

Dim fTemp As Single
Dim N
Dim nBorderLineWidthX, nBorderLineWidthY

' Can't use Printer.CurrentY (a known bug:  top to bottom of printed area
' cannot exceed 32768 twips, instead of intended range of +/- 32768).
Dim lMyPrinter_CurrentY As Long

lMyPrinter_CurrentY = vnHeadingSpace

' Get printer linewidth.
Printer.DrawWidth = frmPeriodic.hsbLineWidth(0) * Screen.TwipsPerPixelX / Printer.TwipsPerPixelX
nBorderLineWidthX = Printer.DrawWidth
nBorderLineWidthY = nBorderLineWidthX * Printer.TwipsPerPixelX / Printer.TwipsPerPixelY

' Define half line widths.  These integers sum to the total linewidth.
nLineLeft = nBorderLineWidthX \ 2
nLineRight = nBorderLineWidthX - nLineLeft
nLineTop = nBorderLineWidthY \ 2
nLineBottom = nBorderLineWidthY - nLineTop

' ************************** Print Heading *********************************
If Element(giElementToShow).iHeading <> 0 Then
   lMyPrinter_CurrentY = -vnHeadingHeight
   
   ' Group Number, IUPAC style.
   If gbColumnHeading(0) Then
      Printer.FontSize = 10
      Printer.FontName = HeadingProperties(0).sName
      Printer.FontSize = mHeadingPrint(0).fSize
      Printer.FontBold = HeadingProperties(0).bBold
      Printer.FontItalic = HeadingProperties(0).bItalic
      Printer.ForeColor = HeadingProperties(0).lColor
      Msg = LTrim$(Str$(Element(giElementToShow).iHeading))
      
      TheRect.Top = lMyPrinter_CurrentY - Printer.ScaleTop
      TheRect.Bottom = TheRect.Top + mHeadingPrint(0).nHeight
      nFlags = DT_SINGLELINE Or DT_TOP Or DT_CENTER Or DT_EXTERNALLEADING
      N = DrawText(Printer.hDC, Msg, -1, TheRect, nFlags)
      Printer.Print "";
      lMyPrinter_CurrentY = lMyPrinter_CurrentY + mHeadingPrint(0).nHeight
   End If
   
   ' Group Number, old style (e.g., 1A - 8B).
   If gbColumnHeading(1) Then
      
      Printer.FontSize = 10
      Printer.FontName = HeadingProperties(1).sName
      Printer.FontSize = mHeadingPrint(1).fSize
      Printer.FontBold = HeadingProperties(1).bBold
      Printer.FontItalic = HeadingProperties(1).bItalic
      Printer.ForeColor = HeadingProperties(1).lColor
      
      fTemp = mHeadingPrint(1).fSize / 3
      ' Make the line 2/3 as thick if a bold font isn't used.
      If Not HeadingProperties(1).bBold Then fTemp = fTemp * 2 / 3
      If fTemp < 1 Then
	 Printer.DrawWidth = 1
      Else
	 Printer.DrawWidth = fTemp
      End If
      
      nLineWidthHeading = Printer.DrawWidth
      
      TheRect.Top = lMyPrinter_CurrentY - Printer.ScaleTop
      TheRect.Bottom = TheRect.Top + mHeadingPrint(1).nHeight
      nFlags = DT_SINGLELINE Or DT_TOP Or DT_CENTER Or DT_EXTERNALLEADING
      
      If Element(giElementToShow).iHeading = 8 Then
      ' Draw "/-----"
      ' Some ends of lines are allowed to extend to edge of box.  When printed,
      ' this will make it easier to put together.  (The alternative is to have
      ' the lines end in the middle of the box edge.  In other words, if the
      ' box edge was 6 pixels wide, the line could have ended in the middle,
      ' or 3 pixels from the edge.)
	 nPosition = lMyPrinter_CurrentY
	 nLinePoint1 = vnBoxWidth \ 4 + nLineWidthHeading \ 2
	 nLinePoint2 = mHeadingPrint(1).nHeight
	 ' straight line 2         z2'                                  z3
	 Printer.Line (nLinePoint1, nPosition + nLinePoint2 \ 2)-(vnBoxWidth + nLineRight, nPosition + nLinePoint2 \ 2)
	 ' slanted line, line 1    z2                                    z1        text height - descent
	 Printer.Line (nLinePoint1, nPosition + nLinePoint2 \ 2)-(0, nPosition + nLinePoint2 - mHeadingPrint(1).nDescent - nLineWidthHeading \ 2)
      ElseIf Element(giElementToShow).iHeading = 9 Then
      ' Draw --VIIIA--
	 nPosition = lMyPrinter_CurrentY
	 ' Print the heading text.
	 Msg = gsColumnHeadingStyle(giColumnHeadingStyleChoice, Element(giElementToShow).iHeading)
	 MsgWidth = Printer.TextWidth(Msg)
	 N = DrawText(Printer.hDC, Msg, -1, TheRect, nFlags)
	 ' Draw the lines on each side of text.
	 nLinePoint1 = (vnBoxWidth - MsgWidth) \ 2 - nLineWidthHeading
	 nLinePoint2 = nPosition + (mHeadingPrint(1).nHeight) \ 2
	 Printer.Line (-nLineLeft, nLinePoint2)-(nLinePoint1, nLinePoint2)
	 Printer.Line (vnBoxWidth - nLinePoint1, nLinePoint2)-(vnBoxWidth + nLineRight, nLinePoint2)
      ElseIf Element(giElementToShow).iHeading = 10 Then
      ' Draw "-----\"
	 nPosition = lMyPrinter_CurrentY
	 nLinePoint1 = nLineWidthHeading \ 2 + 3 * (vnBoxWidth - nLineWidthHeading) \ 4
	 nLinePoint2 = mHeadingPrint(1).nHeight
	 ' straight line 2         z2'                                                                                z3
	 Printer.Line (-nLineLeft, nPosition + nLinePoint2 \ 2)-(nLinePoint1, nPosition + nLinePoint2 \ 2)
	 ' slanted line, line 1    z2                                                                    z1
	 Printer.Line (nLinePoint1, nPosition + nLinePoint2 \ 2)-(vnBoxWidth, nPosition + nLinePoint2 - mHeadingPrint(1).nDescent - nLineWidthHeading \ 2)
      Else
	 ' Normal heading without lines.
	 Msg = gsColumnHeadingStyle(giColumnHeadingStyleChoice, Element(giElementToShow).iHeading)
	 N = DrawText(Printer.hDC, Msg, -1, TheRect, nFlags)
      End If
   End If
   Printer.DrawWidth = nBorderLineWidthX
End If

' **************************** Print Box ********************************

' Add the background color to the box.
Printer.Line (0, 0)-(vnBoxWidth, vnBoxHeight), lGet_Color_Box_Fill(), BF
' Draw the box.
Printer.Line (0, 0)-(vnBoxWidth, vnBoxHeight), glLineColor, B

If frmPeriodic.mnuOptionsDiagonal.Checked Then
   ' Draw the heavy diagonal line that separates metals from nonmetals.
   Printer.DrawWidth = frmPeriodic.hsbLineWidth(1) * Screen.TwipsPerPixelY \ Printer.TwipsPerPixelY
   nDiagTop = Printer.DrawWidth \ 2
   nDiagBottom = Printer.DrawWidth - nDiagTop
   Select Case giElementToShow
      Case 5
	 ' Draw a line on left & a line on bottom.
	       ' horizontal
	 Printer.Line (0, vnBoxHeight)-(vnBoxWidth, vnBoxHeight), glDiagonalColor
	       ' vertical
	 Printer.Line (0, nDiagBottom - nLineTop)-(0, vnBoxHeight), glDiagonalColor
			  ' nDiagBottom is larger than nDiagTop.
      Case 13, 32, 51
	 ' Draw a line on top and right.
	 Printer.Line (0, 0)-(vnBoxWidth, 0), glDiagonalColor
	 Printer.Line (vnBoxWidth, 0)-(vnBoxWidth, vnBoxHeight), glDiagonalColor
      Case 14, 33, 52
	 ' Draw a line on left and bottom.
	 Printer.Line (0, 0)-(0, vnBoxHeight), glDiagonalColor
	 Printer.Line (0, vnBoxHeight)-(vnBoxWidth, vnBoxHeight), glDiagonalColor
      Case 84
	 ' Draw a line on top and right.
	 Printer.Line (0, 0)-(vnBoxWidth, 0), glDiagonalColor 'Top
	 Printer.Line (vnBoxWidth, 0)-(vnBoxWidth, vnBoxHeight - nDiagBottom + nLineBottom), glDiagonalColor
      Case 85
	 ' Draw a vertical line on left.
	 Printer.Line (0, 0)-(0, vnBoxHeight - nDiagBottom + nLineBottom), glDiagonalColor
   End Select
End If

	 ' Leave space for the line...         &     Extra space
lMyPrinter_CurrentY = nLineTop + vnExtraSpaceLineWidth

' ************************** Print Each Field *******************************
' Printing is done in the procedure PrintBox_Fields.

' Atomic Number.
If (lMyPrinter_CurrentY + mBasicPrint(0).nHeight - mBasicPrint(0).nDescent) > vlTop And lMyPrinter_CurrentY < vlBottom Then
   PrintBox_Fields 0, Element(giElementToShow).sNumber, lMyPrinter_CurrentY
   lMyPrinter_CurrentY = lMyPrinter_CurrentY - mBasicPrint(0).nDescent
Else
   lMyPrinter_CurrentY = lMyPrinter_CurrentY + mBasicPrint(0).nHeight - mBasicPrint(0).nDescent
End If

' Atomic Symbol.
If (lMyPrinter_CurrentY + mBasicPrint(1).nHeight) > vlTop And lMyPrinter_CurrentY < vlBottom Then
   PrintBox_Fields 1, Element(giElementToShow).sSymbol, lMyPrinter_CurrentY
Else
   lMyPrinter_CurrentY = lMyPrinter_CurrentY + mBasicPrint(1).nHeight
End If

' Name of Element.
If Not gbOmitName Then
   If (lMyPrinter_CurrentY + mBasicPrint(2).nHeight) > vlTop And lMyPrinter_CurrentY < vlBottom Then
      PrintBox_Fields 2, Element(giElementToShow).sName, lMyPrinter_CurrentY
   Else
      lMyPrinter_CurrentY = lMyPrinter_CurrentY + mBasicPrint(2).nHeight
   End If
End If

' Mass of Element.
If (lMyPrinter_CurrentY + mBasicPrint(3).nHeight) > vlTop And lMyPrinter_CurrentY < vlBottom Then
   PrintBox_Fields 3, Element(giElementToShow).sMass, lMyPrinter_CurrentY
Else
   lMyPrinter_CurrentY = lMyPrinter_CurrentY + mBasicPrint(3).nHeight
End If

End Sub

Sub PrintBox_Control ()
' Program flow is controled here.

Dim N, m
Dim MsgWidth
Dim nPageWidth, nPageLength
Dim nTotalPosWidth
Dim nTotalPosHeight
Dim nInitialTop, nInitialLeft
' These are the total positive height and width.
' (headings and period numbers are printed on the negative side).
Dim lHeightCounter As Long
Dim nPagesWide, nPagesHigh

Dim nLongName, nLongMass, nLongSymbol
Dim nBoxWidth, nBoxHeight
Dim nHeadingHeight

Dim nBorderLineWidthX, nBorderLineWidthY
Dim nExtraSpaceWidthX, nExtraSpaceWidthY
Dim nLineTop, nLineLeft, nLineBottom, nLineRight
Dim nDiagTop, nDiagLeft, nDiagBottom, nDiagRight


Dim lTop As Long, lBottom As Long, lLeft As Long, lRight As Long
Dim nNumberOfPages, nStartPage, nEndPage, nPageNumber

On Error GoTo PrinterError
Printer.ScaleMode = 3   ' Use pixels instead of twips.
   ' This must be called before every print job.  Apparently changing the
   ' other scale values causes it to change back to one when it leaves this
   ' procedure.

' If drawing requires more than one sheet of paper, display printer dialog.
nNumberOfPages = Val(frmPeriodic!hsbScroll.Tag)
If nNumberOfPages > 1 Then
   frmPeriodic!CMDialog1.HelpFile = gsHelpFilePath
   frmPeriodic!CMDialog1.HelpContext = 6
   frmPeriodic!CMDialog1.HelpCommand = HELP_CONTEXT
   frmPeriodic!CMDialog1.Flags = PD_SHOWHELP Or PD_NOSELECTION Or PD_USEDEVMODECOPIES Or PD_HIDEPRINTTOFILE
   frmPeriodic!CMDialog1.Min = 1
   frmPeriodic!CMDialog1.Max = nNumberOfPages
   frmPeriodic!CMDialog1.FromPage = 1
   frmPeriodic!CMDialog1.ToPage = nNumberOfPages
   frmPeriodic!CMDialog1.CancelError = True
   frmPeriodic!CMDialog1.PrinterDefault = False  'Don't make changes to WIN.INI.
   frmPeriodic!CMDialog1.Action = 5
   frmPeriodic!CMDialog1.HelpCommand = HELP_QUIT
   
   If (frmPeriodic!CMDialog1.Flags And PD_PAGENUMS) = PD_PAGENUMS Then
      ' Starting & ending pages were selected.
      nStartPage = frmPeriodic!CMDialog1.FromPage
      nEndPage = frmPeriodic!CMDialog1.ToPage
   Else
      ' Print all.
      nStartPage = 1
      nEndPage = nNumberOfPages
   End If
Else
   ' Just printing a one-page document.
   nEndPage = 1
End If

' ******************** Font & Line Properties on Printer *******************
GetmBasicPrint ' Define mBasicPrint font sizes.
PrintMaxDescentAndHeight

For N = 0 To 1
   ' Get headinging properties.
   Printer.FontSize = 10
   Printer.FontName = HeadingProperties(N).sName
   Printer.FontSize = HeadingProperties(N).nSize
   Printer.FontBold = HeadingProperties(N).bBold
   Printer.FontItalic = HeadingProperties(N).bItalic
   m = GetTextMetrics(Printer.hDC, FontInfo)
   mHeadingPrint(N).fSize = Printer.FontSize
   mHeadingPrint(N).nHeight = FontInfo.tmHeight
Next N
mHeadingPrint(1).nDescent = FontInfo.tmDescent  'mHeadingPrint(0).nDescent is never used.

' Get printer linewidth.
Printer.DrawWidth = frmPeriodic.hsbLineWidth(0) * Screen.TwipsPerPixelX / Printer.TwipsPerPixelX
nBorderLineWidthX = Printer.DrawWidth
nBorderLineWidthY = nBorderLineWidthX * Printer.TwipsPerPixelX / Printer.TwipsPerPixelY

' Define half line widths.  These integers sum to the total linewidth.
nLineLeft = nBorderLineWidthX \ 2
nLineRight = nBorderLineWidthX - nLineLeft
nLineTop = nBorderLineWidthY \ 2
nLineBottom = nBorderLineWidthY - nLineTop

'Extra space.                             Want same appearance as on screen.
nExtraSpaceWidthX = frmPeriodic.hsbExtraSpace * Screen.TwipsPerPixelX / Printer.TwipsPerPixelX
nExtraSpaceWidthY = nExtraSpaceWidthX * Printer.TwipsPerPixelX / Printer.TwipsPerPixelY

' Dimensions of paper.
nPageWidth = Printer.ScaleWidth  ' Useable width of paper (Printer.Width gives physical width).
nPageLength = Printer.ScaleHeight

' ******************** Select element to show *****************************
If giElementToShow = 0 Then
   
   ' Determine Width of box.
   Printer.FontSize = 10
   Printer.FontName = TheGroup(0).TheField(1).sName
   Printer.FontSize = Basic(1).fSize
   Printer.FontBold = TheGroup(0).TheField(1).nBold
   Printer.FontItalic = TheGroup(0).TheField(1).nItalic
   nLongSymbol = Printer.TextWidth(Element(0).sSymbol)
   
   Printer.FontSize = 10
   Printer.FontName = TheGroup(0).TheField(3).sName
   Printer.FontSize = Basic(3).fSize
   Printer.FontBold = TheGroup(0).TheField(3).nBold
   Printer.FontItalic = TheGroup(0).TheField(3).nItalic
   nLongMass = Printer.TextWidth(Element(0).sMass)
   
   If nLongMass > nLongSymbol Then
      nBoxWidth = nLongMass
   Else
      nBoxWidth = nLongSymbol
   End If
   If Not gbOmitName Then
      Printer.FontSize = 10
      Printer.FontName = TheGroup(0).TheField(2).sName
      Printer.FontSize = Basic(2).fSize
      Printer.FontBold = TheGroup(0).TheField(2).nBold
      Printer.FontItalic = TheGroup(0).TheField(2).nItalic
      nLongName = Printer.TextWidth(Element(0).sName)
      If nLongName > nBoxWidth Then nBoxWidth = nLongName
   End If
Else
   ' lWidest_Box finds the width of the widest box in the table or column.
   nBoxWidth = CInt(lWidest_Box_Printer(Element(giElementToShow).iCol))
End If

' *************************** Get size parameters **************************
' Box Width.
      ' Add a line width on each side of text, plus a line width for the box.
      ' The extra line width in the box is to prevent text from touching the box.
nBoxWidth = nBoxWidth + 3 * nBorderLineWidthX  'Inside width of box.
nBoxWidth = nBoxWidth + 2 * nExtraSpaceWidthX 'Extra space.
' nBoxWidth is the line-center to line-center width of the box.

' Heading height.
nHeadingHeight = nLineTop   ' Includes 1/2 linewidth.
If Element(giElementToShow).iHeading <> 0 Then
   nHeadingHeight = mHeadingPrint(0).nHeight * frmPeriodic.chkColHead(0) + nHeadingHeight
   nHeadingHeight = mHeadingPrint(1).nHeight * frmPeriodic.chkColHead(1) + nHeadingHeight
End If
nInitialTop = -nHeadingHeight  ' Printing: top starting position.

' Box Height.
nBoxHeight = mBasicPrint(0).nHeight
nBoxHeight = nBoxHeight + mBasicPrint(1).nHeight + mBasicPrint(3).nHeight
nBoxHeight = nBoxHeight - mBasicPrint(0).nDescent
If Not gbOmitName Then nBoxHeight = nBoxHeight + mBasicPrint(2).nHeight
nBoxHeight = nBoxHeight + 2 * nExtraSpaceWidthY
				       
nBoxHeight = nBoxHeight + nBorderLineWidthY
' nBoxHeight is now the line-center to line-center height of the box.

If frmPeriodic.mnuOptionsDiagonal.Checked Then
   ' If a diagonal line will be drawn, all boxes will have an extra left
   ' border and top border, except for heading boxes.
   Printer.DrawWidth = frmPeriodic.hsbLineWidth(1) * Screen.TwipsPerPixelY / Printer.TwipsPerPixelY
   nDiagTop = Printer.DrawWidth \ 2
   nDiagBottom = Printer.DrawWidth - nDiagTop
   nDiagLeft = Printer.DrawWidth \ 2
   nDiagRight = Printer.DrawWidth - nDiagLeft
   nTotalPosHeight = nBoxHeight + nDiagBottom
   nTotalPosWidth = nBoxWidth + nLineRight
   If Element(giElementToShow).iHeading <> 0 Then
      ' Where printing starts (top).
      nInitialTop = -nHeadingHeight
   Else
      nInitialTop = -nDiagTop
   End If
   ' Where printing starts (left).
   nInitialLeft = -nDiagLeft
   Select Case giElementToShow
      ' Where printing ends (right and bottom).
      Case 5
	 nTotalPosHeight = nBoxHeight + nDiagBottom
	 nTotalPosWidth = nBoxWidth + nDiagRight
      Case 13, 14, 32, 33, 51, 52
	 nTotalPosHeight = nBoxHeight + nDiagBottom
	 nTotalPosWidth = nBoxWidth + nDiagRight
      Case 84
	 nTotalPosHeight = nBoxHeight + nLineBottom
	 nTotalPosWidth = nBoxWidth + nDiagRight
      Case 85
	 nTotalPosHeight = nBoxHeight + nLineBottom
	 nTotalPosWidth = nBoxWidth + nLineRight
      Case Else
	 nTotalPosHeight = nBoxHeight + nLineBottom
	 nTotalPosWidth = nBoxWidth + nLineRight
   End Select
Else
   nTotalPosWidth = nBoxWidth + nLineRight
   nTotalPosHeight = nBoxHeight + nLineBottom
   nInitialLeft = -nLineLeft
End If

' Width contribution of the period number.
If frmPeriodic.mnuOptionsPeriod.Checked And Element(giElementToShow).iCol = 1 And Element(giElementToShow).iRow < 8 Then
   Printer.FontSize = 10
   Printer.FontName = HeadingProperties(0).sName
   Printer.FontSize = mHeadingPrint(0).fSize
   Printer.FontBold = HeadingProperties(0).bBold
   Printer.FontItalic = HeadingProperties(0).bItalic
   ' Column width is one character + one character blank.
   MsgWidth = Printer.TextWidth("7 ")
   nInitialLeft = -MsgWidth - nLineLeft
End If

' ************************** Call the Print Routine ************************

Load frmPrintCancel
' When the cancel printing button is pressed, cmdCancel.Tag is set to "True".

' All text printing is done with Windows API calls to "DrawText".  Printing
' requires characters to be clipped at the edge of the paper.  Although
' graphics are clipped, text printed with the "Print" command is printed on
' the next page if it extends past the page border.  DrawText prints text as
' graphics, so extra pages are not printed.

nPageNumber = 1
lLeft = nInitialLeft
N = SetBkMode(Printer.hDC, TRANSPARENT)
Do  ' Width loop.
   Printer.ScaleLeft = lLeft
   lRight = lLeft + nPageWidth - 1
   
   ' DrawText prints in the rectangle "TheRect".  Text is centered in this
   ' rectangle (except for period numbers, which are left-aligned).
   TheRect.Left = -lLeft   ' Coordinates of box edge relative to current page.
   TheRect.Right = TheRect.Left + nBoxWidth - 1

   ' DrawText prints the period number in the "PeriodRect" rectangle.
   PeriodRect.Left = nInitialLeft - lLeft
   PeriodRect.Right = TheRect.Left
   
   lTop = nInitialTop
   Do  ' Height loop.
      Printer.ScaleTop = lTop
      lBottom = lTop + nPageLength - 1
      
      If nPageNumber >= nStartPage And nPageNumber <= nEndPage Then
	 frmPrintCancel!lblPageNumber = "Now printing page" & Str$(nPageNumber) & " on"
	 DoEvents ' Give chance for cancel to register.
	 If frmPrintCancel!cmdCancel.Tag = "True" Then GoTo PRINT_CANCEL_SELECTED
	 PrintBox_Period nBoxHeight, lLeft
	 PrintBox nBoxWidth, nBoxHeight, nHeadingHeight, nExtraSpaceWidthY, lTop, lBottom, 0
	 If frmPeriodic!mnuPrintImmediate.Checked Then
	    Printer.EndDoc
	    For N = 0 To 200
	       DoEvents
	       If frmPrintCancel!cmdCancel.Tag = "True" Then GoTo PRINT_CANCEL_SELECTED
	    Next N
	    Printer.ScaleMode = 3   ' EndDoc sets scale mode back to twips.
	 Else
	    Printer.NewPage
	 End If
	 ' Next line seems to be needed at start of each new page by some printers.
	 N = SetBkMode(Printer.hDC, TRANSPARENT)
      End If
      nPageNumber = nPageNumber + 1
      lTop = lBottom + 1
   Loop While lBottom < nTotalPosHeight + nInitialTop
   lLeft = lRight + 1
Loop While lRight < nTotalPosWidth + nInitialLeft

DoEvents
PRINT_CANCEL_SELECTED:
If frmPrintCancel!cmdCancel.Tag = "True" Then
   N = AbortDoc(Printer.hDC)
Else
   gbSuccessfulPrintCompletion = True
End If
Printer.EndDoc

Exit Sub

PrinterError:
Select Case Err
   Case 482    ' 482 is printer error.
      ' Occurs on print to file when cancel is selected.
      If frmPrintCancel!cmdCancel.Tag = "True" Then
	 MsgBox "Printing has been canceled", MB_ICONEXCLAMATION, "Periodic Table"
      Else
	 MsgBox "Error number " & Err & ":  " & Error & NL & "A printer error has occurred.  Printing will be canceled", MB_ICONEXCLAMATION, "Periodic Table"
      End If
      Exit Sub
   Case CDERR_CANCEL
      ' User chose cancel in the printer dialog.
      frmPeriodic!CMDialog1.HelpCommand = HELP_QUIT
      Exit Sub
   Case Else
      MsgBox "Unanticipated error occurred.  Program ends." & Err & ":  " & Error & NL & "Program stops", MB_ICONSTOP, "ANALYZE"
      Unload frmPeriodic
End Select

End Sub

Sub PrintBox_Fields (ByVal viField, ByVal vMsg As String, rlPrinterCurrentY As Long)
Dim sWorkName As String, bWorkBold, bWorkItalic, lWorkColor As Long
Dim N, m, P, MsgWidth
Dim nLetterNumber
Dim nFlags
Dim nExitPosition

Get_Property_Work viField, sWorkName, bWorkBold, bWorkItalic, lWorkColor
Printer.FontSize = 10
Printer.FontName = sWorkName
Printer.FontSize = mBasicPrint(viField).fSize
Printer.FontBold = bWorkBold
Printer.FontItalic = bWorkItalic
Printer.ForeColor = lWorkColor

' Align text with "Basic" baseline.
   ' Following is where "CurrentY" should be when exit.
nExitPosition = rlPrinterCurrentY + mBasicPrint(viField).nHeight
N = GetTextMetrics(Printer.hDC, FontInfo) ' Get tmDescent.
						' Distance to baseline, desired                          Distance to baseline, presently
rlPrinterCurrentY = rlPrinterCurrentY + (mBasicPrint(viField).nHeight - mBasicPrint(viField).nDescent) - (FontInfo.tmHeight - FontInfo.tmDescent)

TheRect.Top = rlPrinterCurrentY - Printer.ScaleTop
TheRect.Bottom = TheRect.Top + mBasicPrint(viField).nHeight
nFlags = DT_SINGLELINE Or DT_TOP Or DT_CENTER Or DT_EXTERNALLEADING
N = DrawText(Printer.hDC, vMsg, -1, TheRect, nFlags)
Printer.Print "";  ' Tells the Printer object that printing occured on this page.
rlPrinterCurrentY = nExitPosition

End Sub

' Print the period number.
Sub PrintBox_Period (ByVal vnBoxHeight, ByVal vlLeft As Long)
Dim Msg As String
Dim nFlags
Dim N

If frmPeriodic.mnuOptionsPeriod.Checked And Element(giElementToShow).iCol = 1 And Element(giElementToShow).iRow < 8 Then
   If vlLeft < 0 Then
      Printer.FontSize = 10
      Printer.FontName = HeadingProperties(0).sName
      Printer.FontSize = mHeadingPrint(0).fSize
      Printer.FontBold = HeadingProperties(0).bBold
      Printer.FontItalic = HeadingProperties(0).bItalic
      Printer.ForeColor = HeadingProperties(0).lColor
      ' Column width is one character + one character blank.
      Msg = Format$(Element(giElementToShow).iRow)
      PeriodRect.Top = -Printer.ScaleTop
      PeriodRect.Bottom = PeriodRect.Top + vnBoxHeight - 1
      nFlags = DT_SINGLELINE Or DT_VCENTER Or DT_LEFT
      N = DrawText(Printer.hDC, Msg, -1, PeriodRect, nFlags)
   End If
End If

End Sub

' Get the maximum Ascent and Height for each field.
' Output:  sets the value of the following global variables:
'                       mBasicPrint(iField).nDescent
'                       mBasicPrint(iField).nHeight
Sub PrintMaxDescentAndHeight ()
Dim iField, iGroup, N, nLargestAscent, nLargestDescent, bCheckIt
Dim sName As String, bBold, bItalic, lColor As Long

For iField = 0 To 3
   ' For each field, check all groups that are active.
   nLargestDescent = 0
   nLargestAscent = 0
   For iGroup = 0 To 8
      bCheckIt = False  ' Active groups set bCheckIt to true.
      Select Case iGroup
	 Case 0   ' Basic
	    bCheckIt = True
	 Case 1   ' Nonterrestrial
	    If frmPeriodic!mnuGroupActiveChoice(1).Checked Then bCheckIt = True
	 Case 2, 3   ' NonMetals
	    If frmPeriodic!mnuGroupActiveChoice(2).Checked Then bCheckIt = True
	 Case 4, 5   ' Gases & liquids
	    If frmPeriodic!mnuGroupActiveChoice(3).Checked Then bCheckIt = True
	 Case 6, 7, 8   ' s, p, d, and f block
	    If frmPeriodic!mnuGroupActiveChoice(0).Checked Then bCheckIt = True
      End Select
      If bCheckIt Then
	 ' Get the largest descent and ascent.
	 GroupFontProperties iGroup, iField, sName, bBold, bItalic, lColor
	 Printer.FontSize = 10
	 Printer.FontName = sName
	 Printer.FontSize = mBasicPrint(iField).fSize
	 Printer.FontBold = bBold
	 Printer.FontItalic = bItalic
	 N = GetTextMetrics(Printer.hDC, FontInfo)
	 If FontInfo.tmDescent > nLargestDescent Then
	    nLargestDescent = FontInfo.tmDescent
	 End If
	 If FontInfo.tmAscent > nLargestAscent Then
	    nLargestAscent = FontInfo.tmAscent
	 End If
      End If
   Next iGroup
   ' The largest height is sum of largest ascent and descent.
   mBasicPrint(iField).nDescent = nLargestDescent
   mBasicPrint(iField).nHeight = (nLargestAscent + nLargestDescent)
Next iField
End Sub

' Prints the table caption.
' Called by PrintTable_Control.
' Input:
'               viCol = column presently being printed
'        vlLeftMargin = starting position of caption in pixels
'         vlMsgLength = caption length in pixels
'  vnNumLettersInTitle = number of letters in the title
'     vnTitleUnderhang = underhang in first letter of title
Sub PrintTable_Caption (ByVal viCol, ByVal vlWhereAtNow As Long, ByVal vlLeftMargin As Long, ByVal vlMsgLength As Long, ByVal vnNumLettersInTitle, ByVal vnTitleUnderhang)

Dim nFlags, N
Dim sCaptionLetters As String
Dim NumLetters
Dim nMsgLength
Dim nPreviousMsgLength
Dim nCaptionStart, nFirstLetter
Dim lRightSidePosition As Long
Dim nStartingLetter

' Exit sub if title doesn't exist.
If vnNumLettersInTitle = 0 Then Exit Sub

' Exit if haven't reached caption yet.
lRightSidePosition = vlWhereAtNow + mnColumnWidth(viCol)
If lRightSidePosition < vlLeftMargin Then Exit Sub

' Exit if caption is already complete.
If vlWhereAtNow > (vlLeftMargin + vlMsgLength) Then Exit Sub

' If make it this far, part of the caption will be printed.
Printer.FontSize = 10
Printer.FontName = HeadingProperties(2).sName
Printer.FontSize = mHeadingPrint(2).fSize
Printer.FontBold = HeadingProperties(2).bBold
Printer.FontItalic = HeadingProperties(2).bItalic
Printer.ForeColor = HeadingProperties(2).lColor

' About vnTitleUnderhang:  right-aligned DrawText begins printing
' at mCaptionRect.Left.  This does not include the underhang, which
' wouldn't print at all without the NO_CLIP flag.  To center the message,
' it must be "offset" by the amount of the underhang.

' Where caption begins relative to column's left side:   (outdated)
'   Page    |   ___                         Periodic Table of the Elements
'   edge--->|  | H |<----------------------|left margin
'           |  |___|<--------------------|Column position - width
'           |<---------------------------|TheRect.Left
'           |                         -->| |<-- Amount to add to TheRect.Left
   
' Find the first letter that is at least partially within the column,
' and get the starting position.
If vlWhereAtNow < vlLeftMargin Then
   ' This is the first column to contain the caption.
   nCaptionStart = (vlLeftMargin - vlWhereAtNow)   ' Positive value
   nFirstLetter = 1
Else
   Do
      NumLetters = NumLetters + 1
      nPreviousMsgLength = nMsgLength
      sCaptionLetters = Mid$(frmPeriodic!txtTableTitle, 1, NumLetters)
      nMsgLength = Printer.TextWidth(sCaptionLetters)
   Loop Until nMsgLength + vlLeftMargin >= vlWhereAtNow Or NumLetters >= vnNumLettersInTitle
   nFirstLetter = NumLetters
   nCaptionStart = -(vlWhereAtNow - vlLeftMargin - nPreviousMsgLength)  'Negative value
End If
mCaptionRect.Left = TheRect.Left + nCaptionStart - vnTitleUnderhang  'Minus a negative is pos.
mCaptionRect.Right = TheRect.Right

' Get the portion of the caption to be printed.
NumLetters = 0
Do
   NumLetters = NumLetters + 1
   sCaptionLetters = Mid$(frmPeriodic!txtTableTitle, nFirstLetter, NumLetters)
   nMsgLength = Printer.TextWidth(sCaptionLetters)
Loop Until nMsgLength + nCaptionStart >= lRightSidePosition Or NumLetters + nStartingLetter - 1 >= vnNumLettersInTitle

' Print the desired portion of the caption.
nFlags = DT_SINGLELINE Or DT_TOP Or DT_LEFT Or DT_EXTERNALLEADING Or DT_NOCLIP
' Note that the "no clipping" flag is necessary with the "left alignment" flag.
' Without the no clipping flag, underhang in the first letter of the title
' is cut off.  This is especially noticeable if the first letter is italic "f".
'
N = DrawText(Printer.hDC, sCaptionLetters, -1, mCaptionRect, nFlags)
Printer.Print "";

End Sub

' Determine Caption length.
Sub PrintTable_Caption_Length (rlCaptionLength As Long, rnCaptionCharacters, rnCaptionUnderhang1st)
' Returns:
'              rlCaptionLength = Caption length.
'          rnCaptionCharacters = Number of characters in caption.
'        rnCaptionUnderhang1st = Underhang of the first letter in caption.
' Returned caption length includes under and overhang of 1st & last letters.
' Returned underhang is 0 if abcA is positive.

Dim sCaption As String, nCaption
Dim N, m
Dim nA

' Had I known that TextWidth() is long, I would have done this differently.
Printer.FontSize = 10
Printer.FontName = HeadingProperties(2).sName
Printer.FontSize = mHeadingPrint(2).fSize
Printer.FontBold = HeadingProperties(2).bBold
Printer.FontItalic = HeadingProperties(2).bItalic
sCaption = frmPeriodic.txtTableTitle
rnCaptionCharacters = Len(sCaption)
For N = 1 To rnCaptionCharacters
   nCaption = Asc(Mid$(sCaption, N, 1))
   m = GetCharABCWidths(Printer.hDC, nCaption, nCaption, ABCsize)
   nA = ABCsize.abcA
   If nA < 0 And N = 1 Then
      ' Pass underhang of first character back to PrintTable_Control.
      rnCaptionUnderhang1st = nA
      ' Add underhang of first character to caption length.
      nA = -nA
   End If
   rlCaptionLength = rlCaptionLength + nA + ABCsize.abcB + ABCsize.abcC
Next N
If ABCsize.abcC < 0 Then
   ' Add overhang of last character to caption length.
   rlCaptionLength = rlCaptionLength - ABCsize.abcC ' Last character.
End If

End Sub

' Program flow for printing the table is controled here.
Sub PrintTable_Control ()

Dim Msg As String
Dim N, m, lL As Long
Dim nCaptionFontSize
Dim nNumberOfPages, nStartPage, nEndPage, nPageNumber
Dim nPageWidth, nPageHeight
Dim nBorderLineWidthX, nBorderLineWidthY
Dim nLineTop, nLineLeft, nLineBottom, nLineRight
Dim nExtraSpaceWidthX, nExtraSpaceWidthY
Dim nHeadingHeight
Dim nInitialTop, nInitialLeft
Dim nBoxHeight, nBoxWidth
Dim lTableWidth As Long, lTableHeight As Long
Dim nPagesHigh, nPagesWide
Dim lWidest As Long
Dim iFirstColumn
Dim iRow, iCol
Dim lMsgLength As Long
Dim lLeftMargin As Long
Dim saveElement
Dim lTop As Long, lBottom As Long, lLeft As Long, lRight As Long
Dim lPositionLeft As Long, lPositionTop As Long
Dim nHeightIncrement
Dim nPageBottom
Dim nNumLettersInTitle
Dim nTitleUnderhang
Dim nHeadingSpace
Dim nRoomForHeading

On Error GoTo TablePrintError
Printer.ScaleMode = 3   ' Use pixels instead of twips.

' ******************** Font & Line Properties on Printer *******************
GetmBasicPrint
PrintMaxDescentAndHeight

For N = 0 To 1 ' Headings
   Printer.FontSize = 10
   Printer.FontName = HeadingProperties(N).sName
   Printer.FontSize = HeadingProperties(N).nSize
   Printer.FontBold = HeadingProperties(N).bBold
   Printer.FontItalic = HeadingProperties(N).bItalic
   m = GetTextMetrics(Printer.hDC, FontInfo)
   mHeadingPrint(N).fSize = Printer.FontSize
   mHeadingPrint(N).nHeight = FontInfo.tmHeight
Next N
mHeadingPrint(1).nDescent = FontInfo.tmDescent

' If the Title-Same-Size-as-Symbol box is checked, make sure it isn't an oversight.
If frmPeriodic!chkTitleSameSize = 1 Then
   Msg = "Did you really mean to leave the " & Chr(34) & "table title same size as atomic symbols" & Chr(34) & " box checked?"
   N = MsgBox(Msg, MB_YESNO Or MB_ICONQUESTION, "Printing Table")
   If N = IDNO Then
      Exit Sub
   End If
   nCaptionFontSize = mBasicPrint(1).fSize
Else
   nCaptionFontSize = HeadingProperties(2).nSize
End If

Printer.FontSize = 10   ' Caption
Printer.FontName = HeadingProperties(2).sName
Printer.FontSize = nCaptionFontSize
Printer.FontBold = HeadingProperties(2).bBold
Printer.FontItalic = HeadingProperties(2).bItalic
m = GetTextMetrics(Printer.hDC, FontInfo)
mHeadingPrint(2).fSize = Printer.FontSize
mHeadingPrint(2).nHeight = FontInfo.tmHeight  ' This one's in pixels.

' Get box border linewidth.
   ' On dot matrix printer, Printer.TwipsPerPixelX = 6 and Y = 10,
   ' yet, a box drawn with linewidth = 12 pixels has the same width on all
   ' sides.  Something about logical pixels and mapping mode. A printing
   ' experiment shows that the linewidth is 12 in the X direction (for a line
   ' going in the Y direction), and 12 * 6 / 10 in the Y direction.
Printer.DrawWidth = frmPeriodic.hsbLineWidth(0) * Screen.TwipsPerPixelX / Printer.TwipsPerPixelX
' The help file says TwipsPerPixelX is an integer; not true. It is 4.8 on
' an HP IIP plus (300 pixels/inch).
nBorderLineWidthX = Printer.DrawWidth
nBorderLineWidthY = nBorderLineWidthX * Printer.TwipsPerPixelX / Printer.TwipsPerPixelY

' Define half line widths.  These integers sum to the total linewidth.
nLineLeft = nBorderLineWidthX \ 2
nLineRight = nBorderLineWidthX - nLineLeft
nLineTop = nBorderLineWidthY \ 2
nLineBottom = nBorderLineWidthY - nLineTop

'Extra space.                             Want same appearance as on screen.
nExtraSpaceWidthX = frmPeriodic.hsbExtraSpace * Screen.TwipsPerPixelX / Printer.TwipsPerPixelX
nExtraSpaceWidthY = nExtraSpaceWidthX * Printer.TwipsPerPixelX / Printer.TwipsPerPixelY

' ******************************* Get heights ******************************
' Heading height.
nHeadingHeight = nLineTop   ' Includes 1/2 linewidth.
If Element(giElementToShow).iHeading <> 0 Then
   nHeadingHeight = mHeadingPrint(0).nHeight * frmPeriodic.chkColHead(0) + nHeadingHeight
   nHeadingHeight = mHeadingPrint(1).nHeight * frmPeriodic.chkColHead(1) + nHeadingHeight
End If
nInitialTop = -nHeadingHeight  ' Printing: top starting position.

' Box Height.
nBoxHeight = mBasicPrint(0).nHeight
nBoxHeight = nBoxHeight + mBasicPrint(1).nHeight + mBasicPrint(3).nHeight
nBoxHeight = nBoxHeight - mBasicPrint(0).nDescent
If Not gbOmitName Then nBoxHeight = nBoxHeight + mBasicPrint(2).nHeight
nBoxHeight = nBoxHeight + 2 * nExtraSpaceWidthY
nBoxHeight = nBoxHeight + nBorderLineWidthY
' nBoxHeight is the line-center to line-center height of the box.

lTableHeight = 9 * CLng(nBoxHeight) + nHeadingHeight + nBorderLineWidthY
lTableHeight = lTableHeight + nBoxHeight \ 3 + nLineBottom

'****************************** Column widths ******************************
' The period number width.
If frmPeriodic.mnuOptionsPeriod.Checked Then
   iFirstColumn = 0
   Printer.FontSize = 10
   Printer.FontName = HeadingProperties(0).sName
   Printer.FontSize = mHeadingPrint(0).fSize
   Printer.FontBold = HeadingProperties(0).bBold
   Printer.FontItalic = HeadingProperties(0).bItalic
   ' Column width is arbitrarily one character + one character blank.
   mnColumnWidth(0) = Printer.TextWidth("7 ")   ' At this point, have ignored a half line width.
   lTableWidth = mnColumnWidth(0)
   mnColumnWidth(0) = mnColumnWidth(0) + nLineLeft
Else
   iFirstColumn = 1
   mnColumnWidth(0) = 0
End If
nInitialLeft = -nLineLeft

' Column widths.
For iCol = 1 To 18
   lWidest = lWidest_Box_Printer(iCol)  'Widest string in column (or table).
   ' Width is widest string + box line width + 2 more line widths for inside margins.
   lWidest = lWidest + 3 * nBorderLineWidthX ' Line-center to line-center width of box.
   ' Add more extra space that may have been requested.
   lWidest = lWidest + 2 * nExtraSpaceWidthX
   If lWidest * Printer.TwipsPerPixelX > 32767 Then
      ' Box is too wide.
      Msg = "Column" & iCol & " is too wide to print.  Reduce the WIDTH and try again.  "
      Msg = Msg & "(Evidently that column is wider than the column containing the presently displayed element."
      MsgBox Msg, MB_ICONEXCLAMATION Or MB_OK, "Printing Table"
      Exit Sub
   End If
   
   mnColumnWidth(iCol) = lWidest
   lTableWidth = lTableWidth + lWidest
   If Not frmPeriodic.mnuOptionsWidthMethod(0).Checked Then
      'Using the longest string in table, so set all
      'column widths the same and exit the for/next loop.
      For m = 2 To 18
	 mnColumnWidth(m) = lWidest
      Next m
      lTableWidth = lTableWidth + 17 * lWidest
      Exit For
   End If
'Debug.Print iCol, mnColumnWidth(iCol), lTableWidth
Next iCol
lTableWidth = lTableWidth + nBorderLineWidthX

' ********************** How many pages to print? **************************
' Get dimensions of paper.
nPageHeight = Printer.ScaleHeight
nPageWidth = Printer.ScaleWidth  ' Useable width of paper (Printer.Width gives actual width).

nPagesHigh = lTableHeight \ nPageHeight
If lTableHeight Mod nPageHeight > 0 Then
   ' Don't add extra page if picture is exactly same size as paper.
   nPagesHigh = nPagesHigh + 1
End If

nPagesWide = lTableWidth \ nPageWidth
If lTableWidth Mod nPageWidth > 0 Then nPagesWide = nPagesWide + 1

nNumberOfPages = nPagesHigh * nPagesWide
If nNumberOfPages > 1 Then
   ' If table requires more than one sheet of paper, display printer dialog.
   frmPeriodic!CMDialog1.HelpFile = gsHelpFilePath
   frmPeriodic!CMDialog1.HelpContext = 6
   frmPeriodic!CMDialog1.HelpCommand = HELP_CONTEXT
   frmPeriodic!CMDialog1.Flags = PD_SHOWHELP Or PD_NOSELECTION Or PD_HIDEPRINTTOFILE Or PD_USEDEVMODECOPIES
   frmPeriodic!CMDialog1.Min = 1
   frmPeriodic!CMDialog1.Max = nNumberOfPages
   frmPeriodic!CMDialog1.FromPage = 1
   frmPeriodic!CMDialog1.ToPage = nNumberOfPages
   frmPeriodic!CMDialog1.CancelError = True
   frmPeriodic!CMDialog1.PrinterDefault = False  ' Don't make changes to WIN.INI.
   frmPeriodic!CMDialog1.Action = 5
   frmPeriodic!CMDialog1.HelpCommand = HELP_QUIT
   
   If (frmPeriodic!CMDialog1.Flags And PD_PAGENUMS) = PD_PAGENUMS Then
      nStartPage = frmPeriodic!CMDialog1.FromPage
      nEndPage = frmPeriodic!CMDialog1.ToPage
   Else
      nStartPage = 1
      nEndPage = nNumberOfPages
   End If
Else
   nStartPage = 1
   nEndPage = nNumberOfPages
End If

'frmPeriodic.MousePointer = 11  ' Hourglass

' ******************** Prepare Table Caption *******************************
' Get caption length.
PrintTable_Caption_Length lMsgLength, nNumLettersInTitle, nTitleUnderhang
' Determine the left margin when the caption is centered.
lLeftMargin = (lTableWidth - lMsgLength) \ 2 - nInitialLeft
' lLeftMargin is the distance to the caption from the start of the table.
If lLeftMargin - (mnColumnWidth(0) + mnColumnWidth(1)) <= 0 Then
   ' The caption must fit between H & He.
   frmPeriodic.MousePointer = 0  ' Default
   Msg = "The table caption, " & Chr$(34) & frmPeriodic.txtTableTitle & Chr$(34) & ", is too long to fit between H and He.  Aborting the print job."
   N = MsgBox(Msg, MB_OK Or MB_ICONEXCLAMATION, "Printing Table")
   Exit Sub
End If
' The caption is printed by PrintTable_Caption using a DrawText call.
' The text is printed in the box defined by mCaptionRect.
mCaptionRect.Top = 0
mCaptionRect.Bottom = mCaptionRect.Top + nBoxHeight - 1

' ************************** Call the Print Routine ************************
' The method used to draw any size periodic table is to print the entire
' table for each piece of paper, shifting the starting point from page to
' page.
' As in PrintBox, printing proceeds down, then across.

Load frmPrintCancel
' When the cancel printing button is pressed, cmdCancel.Tag is set to "True".

saveElement = giElementToShow
nPageNumber = 1
N = SetBkMode(Printer.hDC, TRANSPARENT)

' The first two loops shift the page down and across the periodic table.
' The inner two loops print the rows and columns of the table.
lLeft = nInitialLeft
Do ' Across the page loop.
   lRight = lLeft + nPageWidth - 1
   lTop = nInitialTop
   Do ' Down the page loop.
      lBottom = lTop + nPageHeight - 1
      If nPageNumber >= nStartPage And nPageNumber <= nEndPage Then
	 frmPrintCancel!lblPageNumber = "Now printing page" & Str$(nPageNumber) & " on"
	 frmPrintCancel.Refresh ' Update label on frmPrintCancel.
	 
	 ' Print the entire table.
	 For iRow = 1 To 9
	    If iRow = 1 Then
	       lPositionTop = lTop  ' Initialize
	    ElseIf iRow = 8 Then
	       ' Move the f-block elements down 1/3 of a row, + 1 linewidth.
	       lPositionTop = lPositionTop - nBoxHeight - nBoxHeight \ 3 - nBorderLineWidthY
	    Else
	       ' Go to the bottom of the last row.
	       lPositionTop = lPositionTop - nBoxHeight
	    End If
	    
	    If iRow = 1 Or iRow = 2 Or iRow = 4 Then
	       ' Needed for pages that only contain part of the heading of a column.
	       nRoomForHeading = nHeadingHeight
	    Else
	       nRoomForHeading = 0
	    End If
	    ' Skip this row if it won't be printed on this page.
	    '   Top of row is before page bottom      Bottom of row is after page top.
	    If -lPositionTop - nRoomForHeading < nPageHeight And -lPositionTop + nBoxHeight > 0 Then
	       Printer.ScaleTop = lPositionTop
	       TheRect.Top = -lPositionTop ' TheRect.Bottom is defined in most procedures that use it.
	       
	       lPositionLeft = lLeft   ' Left side margin.
	       For iCol = iFirstColumn To 18
		  ' Skip this column if it won't be printed on this page.
		  If -lPositionLeft > nPageWidth Then
		     ' Left side beyond right edge; no more printing in this row.
		     Exit For
		  ElseIf -lPositionLeft + mnColumnWidth(iCol) >= 0 Then
		     ' Right side not before left edge, so this column prints on this page.
		     Printer.ScaleLeft = lPositionLeft
		     TheRect.Left = -lPositionLeft
		     If iCol = 0 Then
			' Print the period number for the first 7 rows.
			If iRow < 8 Then
			   PrintTable_Period iRow, nBoxHeight
			End If
		     Else
			' Print some other part of table.
			TheRect.Right = TheRect.Left + mnColumnWidth(iCol) - 1
			
			giElementToShow = AtomicNumberAtThisSpot(iCol, iRow) 'Get element to draw.
			If giElementToShow > 0 Then
			   ' If giElementToShow is positive, print box; do nothing if zero.
			   If Element(giElementToShow).iHeading <> 0 Then
			      ' Leave space for the heading for elements with headings.
			      nHeadingSpace = -nHeadingHeight
			   Else
			      nHeadingSpace = 0
			   End If
			   PrintBox mnColumnWidth(iCol), nBoxHeight, nHeadingHeight, nExtraSpaceWidthY, lPositionTop, lPositionTop + nPageHeight - 1, nHeadingSpace
			ElseIf giElementToShow < 1 And iRow = 1 Then
			   ' giElementToShow is set negative in every box of row 1 except
			   ' H, He, and period number.  PrintTable_Caption is called for
			   ' these negative values.
			   PrintTable_Caption iCol, lLeft - lPositionLeft, lLeftMargin, lMsgLength, nNumLettersInTitle, nTitleUnderhang
			End If
		     End If
		  End If   ' Tests for width being on page.
		  lPositionLeft = lPositionLeft - mnColumnWidth(iCol)
	       Next iCol
	       DoEvents
	       If frmPrintCancel!cmdCancel.Tag = "True" Then GoTo CancelSelected
	    End If   ' Tests for height being on page.
	 Next iRow
	 If frmPeriodic!mnuPrintImmediate.Checked Then
	    Printer.EndDoc
	    ' Give Print Manager a chance to print a page.
	    For N = 0 To 200
	       DoEvents
	       If frmPrintCancel!cmdCancel.Tag = "True" Then GoTo CancelSelected
	    Next N
	    Printer.ScaleMode = 3   ' EndDoc sets scale mode back to twips.
	 Else
	    Printer.NewPage
	 End If
	 N = SetBkMode(Printer.hDC, TRANSPARENT)   ' Some printers seem to need reminding to stay transparent.
      End If
      nPageNumber = nPageNumber + 1
      lTop = lBottom + 1
   Loop While lTop < lTableHeight + nInitialTop
   lLeft = lRight + 1
Loop While lLeft < lTableWidth + nInitialLeft

DoEvents ' Last chance to cancel!

CancelSelected:
frmPrintCancel.Hide
If frmPrintCancel!cmdCancel.Tag = "True" Then
    N = AbortDoc(Printer.hDC)
Else
   gbSuccessfulPrintCompletion = True
End If
Printer.EndDoc

giElementToShow = saveElement 'Exit with element to show same as before drawing table.
frmPeriodic.MousePointer = 0  ' Default
Exit Sub

TablePrintError:
Select Case Err
   Case 482 ' Printer error; occurs on print to file when cancel is selected.
      frmPeriodic.MousePointer = 0  ' Default
      If frmPrintCancel!cmdCancel.Tag = "True" Then
	 MsgBox "Printing has been canceled", MB_ICONEXCLAMATION, "Table Print Control"
      Else
	 MsgBox "Error number " & Err & ":  " & Error & NL & "A printer error has occurred.  Printing will be canceled", MB_ICONEXCLAMATION, "Table Print Control"
	 giElementToShow = saveElement
      End If
      Exit Sub
   Case CDERR_CANCEL
      ' User chose cancel in the printer dialog.
      frmPeriodic!CMDialog1.HelpCommand = HELP_QUIT
      frmPeriodic.MousePointer = 0  ' Default
      Exit Sub
   Case Else
      frmPeriodic.MousePointer = 0  ' Default
      MsgBox "Unanticipated error occurred.  Program ends.  " & Err & ":  " & Error, MB_ICONSTOP, "Table Print Control"
      Unload frmPeriodic
End Select


End Sub

' Print the period number.
Sub PrintTable_Period (ByVal viRow, ByVal vnBoxHeight)

If frmPeriodic!mnuOptionsPeriod.Checked = False Then Exit Sub

Dim nFlags
Dim N

TheRect.Right = TheRect.Left + mnColumnWidth(0) - 1
TheRect.Bottom = TheRect.Top + vnBoxHeight - 1

Printer.FontSize = 10
Printer.FontName = HeadingProperties(0).sName
Printer.FontSize = mHeadingPrint(0).fSize
Printer.FontBold = HeadingProperties(0).bBold
Printer.FontItalic = HeadingProperties(0).bItalic
Printer.ForeColor = HeadingProperties(0).lColor
nFlags = DT_SINGLELINE Or DT_VCENTER Or DT_LEFT
N = DrawText(Printer.hDC, Format$(viRow), -1, TheRect, nFlags)
' Every page must have at least one print command on it by the printer object,
' or else it is treated as a blank page and not printed.
Printer.Print

End Sub

Sub Remove_Items_From_Sysmenu (A_Form As Form)
    Dim HSysMenu
    Dim r
    ' Obtain the handle to the form's System menu
    '
    HSysMenu = GetSystemMenu(A_Form.hWnd, 0)
  
    ' Remove all but the MOVE and CLOSE options.  The menu items
    ' must be removed starting with the last menu item.
    '
    r = RemoveMenu(HSysMenu, 8, MF_BYPOSITION) 'Switch to
    r = RemoveMenu(HSysMenu, 7, MF_BYPOSITION) 'Separator
    r = RemoveMenu(HSysMenu, 5, MF_BYPOSITION) 'Separator

End Sub

