// ttview.h : interface of the CTtView class
//
/////////////////////////////////////////////////////////////////////////////
//class MacComm;

class XYModem;

class CTtView : public CView
{
protected: // create from serialization only
        CTtView();
        DECLARE_DYNCREATE(CTtView)

// Attributes
public:
        CTtDoc*         GetDocument();
    CDC                 cdcTTY;
    CString     strTemp;
    MacComm*    commObj;
    MacTerm*    termObj;
    XYModem*    xferObj;
    
    CString     DLPath;
    CString     ULPath;
    BOOL                initFlag;
    int                 DefaultTextColor;
    int                 DefaultBackgroundColor;
     
// Operations
public:

void UpdateStatusBar(int Pane, LPSTR NewText);

// Implementation
public:
        virtual ~CTtView();
        virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
        virtual void AssertValid() const;
        virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
        //{{AFX_MSG(CTtView)
        afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
        afx_msg void OnHelpStat();
        afx_msg void OnUtilsHangup();
        afx_msg void OnSize(UINT nType, int cx, int cy);
        afx_msg void OnFileNew();
        afx_msg void OnUtilsFastscroll();
        afx_msg void OnUpdateUtilsFastscroll(CCmdUI* pCmdUI);
        afx_msg void OnSetFocus(CWnd* pOldWnd);
        afx_msg void OnKillFocus(CWnd* pNewWnd);
        afx_msg void OnFileClosecapturefile();
        afx_msg void OnUpdateFileClosecapturefile(CCmdUI* pCmdUI);
        afx_msg void OnFileOpencapturefile();
        afx_msg void OnUpdateFileOpencapturefile(CCmdUI* pCmdUI);
        afx_msg void OnViewSettextcolor();
        afx_msg void OnViewSetbackgroundcolor();
        afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
        afx_msg void OnDLXmodem();
        afx_msg void OnDLYmodem();
        afx_msg void OnUtilsCheckCarrier();
        afx_msg void OnAbortdl();
        afx_msg void OnUpdateAbortdl(CCmdUI* pCmdUI);
        afx_msg void OnUpdateDLXmodem(CCmdUI* pCmdUI);
        afx_msg void OnUpdateDLYmodem(CCmdUI* pCmdUI);
        afx_msg void OnDLYmodemg();
        afx_msg void OnUpdateDLYmodemg(CCmdUI* pCmdUI);
        afx_msg void OnULXmodem();
        afx_msg void OnUpdateULXmodem(CCmdUI* pCmdUI);
        afx_msg void OnULYmodem();
        afx_msg void OnUpdateULYmodem(CCmdUI* pCmdUI);
        afx_msg void OnULYmodemg();
        afx_msg void OnUpdateULYmodemg(CCmdUI* pCmdUI);
        afx_msg void OnULXmodem128bytecrc();
        afx_msg void OnUpdateULXmodem128bytecrc(CCmdUI* pCmdUI);
        afx_msg void OnULXmodem1k();
        afx_msg void OnUpdateULXmodem1k(CCmdUI* pCmdUI);
        afx_msg void OnUtilsSetupUldir();
        afx_msg void OnUtilsSetupDldir();
        afx_msg void OnUpdateUtilsHangup(CCmdUI* pCmdUI);
        afx_msg void OnUpdateUtilsSetupDldir(CCmdUI* pCmdUI);
        afx_msg void OnUpdateUtilsSetupUldir(CCmdUI* pCmdUI);
        afx_msg void OnUpdateViewSetbackgroundcolor(CCmdUI* pCmdUI);
        afx_msg void OnUpdateViewSettextcolor(CCmdUI* pCmdUI);
        afx_msg void OnUpdateUtilsResetport(CCmdUI* pCmdUI);
        afx_msg void OnUtilsResetport();
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ttview.cpp
inline CTtDoc* CTtView::GetDocument()
   { return (CTtDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

// ttview.cpp : implementation of the CTtView class
//

#include "windows.h"
#include <commdlg.h>
#include "stdafx.h"
#include "tt.h"
#include "maccomm.h" 
#include "macterm.h"
#include "xymodem.h"
//#include "setup.h"

#include "statdlg.h"
#include "ttdoc.h"
#include "ttview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CTtView

IMPLEMENT_DYNCREATE(CTtView, CView)

BEGIN_MESSAGE_MAP(CTtView, CView)
        //{{AFX_MSG_MAP(CTtView)
        ON_WM_SHOWWINDOW()
        ON_COMMAND(ID_HELP_STAT, OnHelpStat)
        ON_COMMAND(ID_UTILS_HANGUP, OnUtilsHangup)
        ON_WM_SIZE()
        ON_COMMAND(ID_FILE_NEW, OnFileNew)
        ON_COMMAND(ID_UTILS_FASTSCROLL, OnUtilsFastscroll)
        ON_UPDATE_COMMAND_UI(ID_UTILS_FASTSCROLL, OnUpdateUtilsFastscroll)
        ON_WM_SETFOCUS()
        ON_WM_KILLFOCUS()
        ON_COMMAND(ID_FILE_CLOSECAPTUREFILE, OnFileClosecapturefile)
        ON_UPDATE_COMMAND_UI(ID_FILE_CLOSECAPTUREFILE, OnUpdateFileClosecapturefile)
        ON_COMMAND(ID_FILE_OPENCAPTUREFILE, OnFileOpencapturefile)
        ON_UPDATE_COMMAND_UI(ID_FILE_OPENCAPTUREFILE, OnUpdateFileOpencapturefile)
        ON_COMMAND(ID_VIEW_SETTEXTCOLOR, OnViewSettextcolor)
        ON_COMMAND(ID_VIEW_SETBACKGROUNDCOLOR, OnViewSetbackgroundcolor)
        ON_WM_CHAR()
        ON_WM_KEYDOWN()
        ON_WM_KEYUP()
        ON_COMMAND(ID_DL_XMODEM, OnDLXmodem)
        ON_COMMAND(ID_DL_YMODEM, OnDLYmodem)
        ON_COMMAND(ID_UTILS_CHECKCARRIER, OnUtilsCheckCarrier)
        ON_COMMAND(ID_ABORTDL, OnAbortdl)
        ON_UPDATE_COMMAND_UI(ID_ABORTDL, OnUpdateAbortdl)
        ON_UPDATE_COMMAND_UI(ID_DL_XMODEM, OnUpdateDLXmodem)
        ON_UPDATE_COMMAND_UI(ID_DL_YMODEM, OnUpdateDLYmodem)
        ON_COMMAND(ID_DL_YMODEMG, OnDLYmodemg)
        ON_UPDATE_COMMAND_UI(ID_DL_YMODEMG, OnUpdateDLYmodemg)
        ON_COMMAND(ID_UL_XMODEM, OnULXmodem)
        ON_UPDATE_COMMAND_UI(ID_UL_XMODEM, OnUpdateULXmodem)
        ON_COMMAND(ID_UL_YMODEM, OnULYmodem)
        ON_UPDATE_COMMAND_UI(ID_UL_YMODEM, OnUpdateULYmodem)
        ON_COMMAND(ID_UL_YMODEMG, OnULYmodemg)
        ON_UPDATE_COMMAND_UI(ID_UL_YMODEMG, OnUpdateULYmodemg)
        ON_COMMAND(ID_UL_XMODEM128BYTECRC, OnULXmodem128bytecrc)
        ON_UPDATE_COMMAND_UI(ID_UL_XMODEM128BYTECRC, OnUpdateULXmodem128bytecrc)
        ON_COMMAND(ID_UL_XMODEM1K, OnULXmodem1k)
        ON_UPDATE_COMMAND_UI(ID_UL_XMODEM1K, OnUpdateULXmodem1k)
        ON_COMMAND(ID_UTILS_SETUP_ULDIR, OnUtilsSetupUldir)
        ON_COMMAND(ID_UTILS_SETUP_DLDIR, OnUtilsSetupDldir)
        ON_UPDATE_COMMAND_UI(ID_UTILS_HANGUP, OnUpdateUtilsHangup)
        ON_UPDATE_COMMAND_UI(ID_UTILS_SETUP_DLDIR, OnUpdateUtilsSetupDldir)
        ON_UPDATE_COMMAND_UI(ID_UTILS_SETUP_ULDIR, OnUpdateUtilsSetupUldir)
        ON_UPDATE_COMMAND_UI(ID_VIEW_SETBACKGROUNDCOLOR, OnUpdateViewSetbackgroundcolor)
        ON_UPDATE_COMMAND_UI(ID_VIEW_SETTEXTCOLOR, OnUpdateViewSettextcolor)
        ON_UPDATE_COMMAND_UI(ID_UTILS_RESETPORT, OnUpdateUtilsResetport)
        ON_COMMAND(ID_UTILS_RESETPORT, OnUtilsResetport)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTtView construction/destruction

CTtView::CTtView()  {

     // create instances of objects
        commObj = new MacComm;
    termObj = new MacTerm;
        xferObj = new XYModem;    

    initFlag = FALSE;
}

CTtView::~CTtView()
{    // clean up
        delete commObj;
        delete termObj;
    delete xferObj;
}

/////////////////////////////////////////////////////////////////////////////
// CTtView drawing

void CTtView::OnDraw(CDC* pDC)  {

        CTtDoc* pDoc = GetDocument();
        ASSERT_VALID(pDoc);

        // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CTtView diagnostics

#ifdef _DEBUG
void CTtView::AssertValid() const  {

        CView::AssertValid();
}

void CTtView::Dump(CDumpContext& dc) const  {

        CView::Dump(dc);
}

CTtDoc* CTtView::GetDocument()  {   // non-debug version is inline

        ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTtDoc)));
        return (CTtDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTtView message handlers
 

//*****************************************************
// screen stuff...
//  Here we initialize the commObj, initialize the termObj and cross link
//  the two objects. (each has a pointer to to the other. 

void CTtView::OnShowWindow(BOOL bShow, UINT nStatus)  {

        CView::OnShowWindow(bShow, nStatus);
        


    // here we call the PortSetup() member function of the commObj.
    // we also could set the port parameters in the public data members
    // of the commObj.
    if(commObj->idCom1 == -1)   {         // -1 means not initialized
                if(commObj->PortSetup() )  {      // do the setup dialog
                        if(commObj->OpenPort(this) )  // open the port, pass owner pointer (this)
                                AfxMessageBox("Error in CommMsgAssign");
                        }
                }       


        if(termObj->OpenScreen(this) )         // create screen, pass owner pointer(this)               
                AfxMessageBox("Error in TermOpen");

    commObj->Screen = termObj;   //  cross link comm obj and assoc screen
    termObj->Comm   = commObj;                        

        // recover defaults
    DLPath = AfxGetApp()->GetProfileString("Main", "DLDir","C:\\" );
    ULPath = AfxGetApp()->GetProfileString("Main", "ULDir","C:\\" );
    DefaultBackgroundColor = AfxGetApp()->GetProfileInt("Main", 
                                                        "BackGroundColor", 1);
    DefaultTextColor = AfxGetApp()->GetProfileInt("Main", "TextColor", 15);
        
        termObj->SetTextColor(DefaultTextColor);     // set colors
        termObj->SetBkgndColor(DefaultBackgroundColor);
}                                                     
 
//////////////////////////////
//  This displays the char buffer stats from menu

void CTtView::OnHelpStat()  {

        StatDlg it;
        it.SetData(commObj);
        it.DoModal();
}


/////////////////////////////
//  Calls HangUp function in commObj
void CTtView::OnUtilsHangup()  {

        commObj->HangUp();      
}


/////////////////////////////
//  This is a workaround for the WM_COMMNOTIFY notifications stopping for
//  some reason upon sizing.  The VerifyInt() function does just that.
void CTtView::OnSize(UINT nType, int cx, int cy)  {

        CView::OnSize(nType, cx, cy);
        
        commObj->VerifyInt();
}

void CTtView::OnSetFocus(CWnd* pOldWnd)  {

        CView::OnSetFocus(pOldWnd);
        
        commObj->VerifyInt();
}

// this was not used, just too lazy to take it out
void CTtView::OnKillFocus(CWnd* pNewWnd)  {

        CView::OnKillFocus(pNewWnd);
        
        // TODO: Add your message handler code here
}

//////////////////////////////////
// cheap re-dial - sends A/ to comm port for repeat last.
void CTtView::OnFileNew()  {

        commObj->CommSendString("a/");
}

//////////////////////////////////
//  Key handling
//  These member functions map key strokes fro the application over the the commObj.
//  There are other ways to do this, but this works the best, leaving key message
//  processing in the view of the app.

void CTtView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)   {

        commObj->OnKeyDown(nChar, nRepCnt, nFlags);
        
        CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CTtView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)    {

        commObj->OnKeyUp(nChar, nRepCnt, nFlags);
        
        CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CTtView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)   {

        commObj->OnChar(nChar, nRepCnt, nFlags);
    
        CView::OnChar(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////
//  The first function toggles on/off the fastscroll option in the termObj.
//  The second function updates the menu check status for this selection
void CTtView::OnUtilsFastscroll()   {

                // toggle Fastscroll
        if(termObj->fFastScroll) termObj->fFastScroll = FALSE;
        else termObj->fFastScroll = TRUE;       
}
void CTtView::OnUpdateUtilsFastscroll(CCmdUI* pCmdUI)  {


        if(termObj->fFastScroll) pCmdUI->SetCheck(1);
        else pCmdUI->SetCheck(0);
}

/////////////////////////////////////////////////////
// these functions control the capture file and graying menu choices

void CTtView::OnFileClosecapturefile()  {

        commObj->CloseCaptureFile();
    UpdateStatusBar(4,"Capture - OFF");
}

void CTtView::OnUpdateFileClosecapturefile(CCmdUI* pCmdUI)  {

        if(!commObj->fp1) pCmdUI->Enable(FALSE);        
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnFileOpencapturefile()  {

        if(commObj->OpenCaptureFile() ) 
         UpdateStatusBar(4,"Capture - OFF");
        else UpdateStatusBar(4,"Capture - ON ");
}

void CTtView::OnUpdateFileOpencapturefile(CCmdUI* pCmdUI)  {

        if(commObj->fp1) pCmdUI->Enable(FALSE); 
    else pCmdUI->Enable(TRUE);

}

//////////////////////////////////////////////////
//  These functions set the screen colors.  

void CTtView::OnViewSettextcolor()  {

int Color = termObj->SetTextColor();

        if(Color == -1) return;
        
        if(Color != DefaultTextColor)   {
            DefaultTextColor = Color;
        AfxGetApp()->WriteProfileInt("Main", "TextColor", Color);
                }               
}

void CTtView::OnViewSetbackgroundcolor()  {

int Color = termObj->SetBkgndColor();

        if(Color == -1) return;
        
        if(Color != DefaultBackgroundColor)     {
            DefaultBackgroundColor = Color;
        AfxGetApp()->WriteProfileInt("Main", "BackGroundColor", Color);
                }               
}

     // disable during file xfers
void CTtView::OnUpdateViewSetbackgroundcolor(CCmdUI* pCmdUI)  {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}
     // disable during file xfers
void CTtView::OnUpdateViewSettextcolor(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}



////////////////////////////////////////////////////////
//  function to update status bar

void CTtView::UpdateStatusBar(int Pane, LPSTR NewText)  {

CStatusBar *StatusBar = ( CStatusBar * )
        AfxGetApp()->m_pMainWnd->GetDescendantWindow( AFX_IDW_STATUS_BAR );

        if( StatusBar != 0 )
        {
                StatusBar->SetPaneText( Pane, NewText );
        }

}


///////////////////////////////////////////////////////
// Downloading functions
void CTtView::OnDLXmodem()   {

        xferObj->ReceiveXY (commObj, DLPath.GetBuffer(DLPath.GetLength()), 'X');
        DLPath.ReleaseBuffer();
}                                                   

void CTtView::OnDLYmodem()   {

    xferObj-> ReceiveFile(commObj, DLPath.GetBuffer(DLPath.GetLength()), "", 'Y');
        DLPath.ReleaseBuffer();
}

void CTtView::OnDLYmodemg()  {

    xferObj->ReceiveFile(commObj, DLPath.GetBuffer(DLPath.GetLength()), "", 'G');
        DLPath.ReleaseBuffer();
}

///////////////////////////////////////////////////////
// Uploading functions

   // Std Xmodem - 128 byte - checksum
void CTtView::OnULXmodem()  {

        xferObj->SendXY (commObj, ULPath.GetBuffer(ULPath.GetLength()), 'X');
        ULPath.ReleaseBuffer();
}
  // XModem - 128 byte - CRC
void CTtView::OnULXmodem128bytecrc()   {

        xferObj->SendXY (commObj, ULPath.GetBuffer(ULPath.GetLength()), 'C');
        ULPath.ReleaseBuffer();
}
  // 1K XModem - CRC
void CTtView::OnULXmodem1k()   {
                                
        xferObj->SendXY (commObj, ULPath.GetBuffer(ULPath.GetLength()), 'K');
        ULPath.ReleaseBuffer();
}                               
  // YModem/Batch
void CTtView::OnULYmodem()   {

        xferObj->SendXY (commObj, ULPath.GetBuffer(ULPath.GetLength()), 'Y');
        ULPath.ReleaseBuffer();
}
  // YModem-g/Batch 
void CTtView::OnULYmodemg()   {
                              
        xferObj->SendXY (commObj, ULPath.GetBuffer(ULPath.GetLength()), 'G');
        ULPath.ReleaseBuffer();
}

////////////////////////////////////////////////
//  Check Carrier state flag

void CTtView::OnUtilsCheckCarrier()   {

        if( commObj->CarrierDetect() ) AfxMessageBox("We have Carrier !!");
        else AfxMessageBox("Wah ! No Carrier !");
}



/////////////////////////////////////////////////
// Setup Default Upload Directory
void CTtView::OnUtilsSetupUldir()  {

                CFileDialog LoadDlg(TRUE,NULL,"SELECT",OFN_HIDEREADONLY,
                               NULL, NULL);
            
            LoadDlg.m_ofn.lpstrTitle = "Select Upload Directory";
                
                CString TempCS = ULPath;  // set temp CString
                int index;
                if( (index = TempCS.ReverseFind('\\') ) != -1) 
                                TempCS = TempCS.Left(index);

                LoadDlg.m_ofn.lpstrInitialDir = TempCS;
                if( LoadDlg.DoModal() == IDOK  )        {
                        ULPath = LoadDlg.GetPathName();
                        if( (index = ULPath.ReverseFind('\\') ) != -1) 
                                ULPath = ULPath.Left(index +1);
                AfxGetApp()->WriteProfileString("Main", "ULDir", ULPath);
                }           
}

//////////////////////////////////////////////////
//  Setup Default Download Directory 

void CTtView::OnUtilsSetupDldir()   {

                CFileDialog LoadDlg(TRUE,NULL,"SELECT",OFN_HIDEREADONLY,
                               NULL, NULL);
            
            LoadDlg.m_ofn.lpstrTitle = "Select Download Directory";
                
                CString TempCS = DLPath;  // set temp CString
                int index;
                if( (index = TempCS.ReverseFind('\\') ) != -1) 
                                TempCS = TempCS.Left(index);

                LoadDlg.m_ofn.lpstrInitialDir = TempCS;
                if( LoadDlg.DoModal() == IDOK  )        {
                        DLPath = LoadDlg.GetPathName();
                        if( (index = DLPath.ReverseFind('\\') ) != -1) 
                                DLPath = DLPath.Left(index +1);
                AfxGetApp()->WriteProfileString("Main", "DLDir", DLPath);
                }           
}

//////////////////////////////////////////
//  Sets abort flag in commObj
void CTtView::OnAbortdl()  {

        commObj->bAbortDownload = TRUE;
}

///////////////////////////////////////
//  Resets over-run rcv buffer
void CTtView::OnUtilsResetport()  {

        if(commObj->CommGetError() && 1) 
            commObj->FlushReceiveQueue();
}

//////////////////////////////////////////////////
//   UI Updating for menu items - gray/disable during file xfers

void CTtView::OnUpdateAbortdl(CCmdUI* pCmdUI)   {

        if(!commObj->bDownloadActive) pCmdUI->Enable(FALSE);    
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateDLXmodem(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateDLYmodem(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateDLYmodemg(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateULXmodem(CCmdUI* pCmdUI)    {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateULYmodem(CCmdUI* pCmdUI)    {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateULYmodemg(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateULXmodem128bytecrc(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateULXmodem1k(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateUtilsHangup(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateUtilsSetupDldir(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateUtilsSetupUldir(CCmdUI* pCmdUI)   {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

void CTtView::OnUpdateUtilsResetport(CCmdUI* pCmdUI)  {

        if(commObj->bDownloadActive) pCmdUI->Enable(FALSE);     
    else pCmdUI->Enable(TRUE);
}

