char wprintf_c[]="$Header: d:/wilhelm/winrsh/RCS/wprintf.c%v 1.6 1994/11/07 04:40:07 wcheung Exp wcheung $";
/*************************************************************************
 *
 * wprintf - Window's printf Module
 *
 * Copyright(C) 1994 William K. W. Cheung, Dimitrios P. Bouras
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * WinRSH/WinRSH32 - Remote Shell for Windows
 * Author: William K. W. Cheung (wcheung@ee.ubc.ca)
 * Date:   November 4, 1994
 *
 ************************************************************************/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "wprintf.h"
#include "err.h"

int MaxWindowLines = 200;

// Variables internal to wprintf
static HWND hListWnd;
static HFONT hListFnt = NULL;
static WNDPROC lpfnLBOldProc;
static FARPROC lpfnLBNewProc;
static int ixMaxCol=0, nViewLin;
static int ixChar, iyChar, ixUpper;
static int ixClient, iyClient;

// These are defined further down
static void DoAddLine(LPSTR szString);
LRESULT CALLBACK _export LBNewProc(HWND hwnd, UINT message,
													WPARAM wParam, LPARAM lParam);

void DoInitWprintf(HWND hWnd, HINSTANCE hInst)
{
	hListWnd = CreateWindow("listbox", NULL,
							WS_CHILD|WS_VISIBLE|
							WS_VSCROLL|WS_HSCROLL|
							LBS_HASSTRINGS|LBS_USETABSTOPS|LBS_NOINTEGRALHEIGHT,
							0, 0, 0, 0,
							hWnd, (HMENU)LB_ID, hInst, NULL);
	lpfnLBOldProc = (WNDPROC)GetWindowLong(hListWnd, GWL_WNDPROC);
	lpfnLBNewProc = MakeProcInstance((FARPROC)LBNewProc, hInst);
	SetWindowLong(hListWnd, GWL_WNDPROC, (LONG)lpfnLBNewProc);
	SendMessage(hListWnd, WM_SETFONT, (WPARAM)hListFnt, (LPARAM)FALSE);
}

void wcls(void)
{
	SendMessage(hListWnd, LB_RESETCONTENT, 0, 0L);
	SendMessage(hListWnd, LB_SETHORIZONTALEXTENT, (WPARAM)0, (LPARAM)0L);
}

void wputs(LPSTR lpszStr)
{
	static BOOL	fPartial=FALSE;
	HGLOBAL	hGlb;
	LPSTR	lpBuf;
	LPSTR pch, psz;
	UINT nLine, nSize;

	SendMessage(hListWnd, WM_SETREDRAW, FALSE, 0L);
	psz = lpszStr;
	if (fPartial)
	{
		nLine = (UINT)SendMessage(hListWnd, LB_GETCOUNT, 0, 0L);
		nSize = (UINT)SendMessage(hListWnd, LB_GETTEXTLEN, (WPARAM)(nLine-1), 0L);
		pch = strchr(psz, '\n');
		if (pch)
			nSize += (int)pch - (int)psz + 1;
		else
			nSize += strlen(psz);
		hGlb = GlobalAlloc(GPTR, sizeof(char)*nSize);
		if (hGlb == NULL)
		{
			ErrPrintf(ERR_WARN, "Out of memory");
			return;
		}
		lpBuf = (LPSTR)GlobalLock(hGlb);
		SendMessage(hListWnd, LB_GETTEXT, (WPARAM)(nLine-1), (LPARAM)lpBuf);
		SendMessage(hListWnd, LB_DELETESTRING, (WPARAM)(nLine-1), 0L);
		if (pch)
		{
			*pch = '\0';
			lstrcat(lpBuf, (LPSTR)psz);
			DoAddLine(lpBuf);
			*pch = '\n';
			psz = pch + 1;
			fPartial = FALSE;
		}
		else
		{
			lstrcat(lpBuf, (LPSTR)psz);
			DoAddLine(lpBuf);
		}
		GlobalUnlock(hGlb);
		GlobalFree(hGlb);
	}
	for(; pch=strchr(psz, '\n'), pch; pch++, psz=pch)
	{
		*pch = '\0';
		DoAddLine((LPSTR)psz);
		*pch = '\n';
	}
	if (!fPartial && *psz)
	{
		DoAddLine((LPSTR)psz);
		fPartial=TRUE;
	}

	SendMessage(hListWnd, WM_KEYDOWN, (WPARAM)VK_END, 0L);
	SendMessage(hListWnd, WM_SETREDRAW, TRUE, 0L);
}

void wprintf(char *szFormat, ...)
{
	va_list     vaArgs;
	char        szBuf[_WPRINTF_BUFSIZ];

	va_start(vaArgs, szFormat);
	if (vsprintf(szBuf, szFormat, vaArgs) != EOF)
		wputs(szBuf);
	va_end(vaArgs);
}

static void DoAddLine(LPSTR szString)
{
	UINT 	nLine;
	int	ixMaxWidth;

	if (szString) {
		ixMaxCol = max(lstrlen(szString), ixMaxCol);
		ixMaxWidth = ixMaxCol * (4*ixChar+ixUpper)/5 + ixChar;
		SendMessage(hListWnd, LB_SETHORIZONTALEXTENT,
						(WPARAM)ixMaxWidth, (LPARAM)0L);
		nLine = (UINT)SendMessage(hListWnd, LB_GETCOUNT, 0, 0L);
		if (nLine >= MaxWindowLines)
			SendMessage(hListWnd, LB_DELETESTRING, (WPARAM)0, (LPARAM)0);
		SendMessage(hListWnd, LB_INSERTSTRING,(WPARAM)-1, (LPARAM)szString);
	}
}

void DoWprintfKeys(WPARAM wParam, LPARAM lParam)
{
	SendMessage(hListWnd, WM_KEYDOWN, wParam, lParam);
}

int DoWprintfSize(LPARAM lParam, UINT nOffset)
{
	if (lParam)
	{
		iyClient = HIWORD (lParam) - nOffset;
		ixClient = LOWORD (lParam);
		nViewLin = iyClient/iyChar;
		MoveWindow(hListWnd, 0, 0, ixClient, iyClient, TRUE);
		return TRUE;
	}
	return FALSE;
}

void SetFont(LPSTR lpszFntName, int clfh, int clfw)
{
	HDC         hdc;
	LOGFONT     lfont;
	TEXTMETRIC  tm;

	hdc = GetDC(hListWnd);

	lfont.lfHeight         =  clfh;
	lfont.lfWidth          =  clfw;
	lfont.lfEscapement     =  0;
	lfont.lfOrientation    =  0;
	lfont.lfWeight         =  FW_NORMAL;
	lfont.lfItalic         =  FALSE;
	lfont.lfUnderline      =  FALSE;
	lfont.lfStrikeOut      =  FALSE;
	lfont.lfCharSet        =  ANSI_CHARSET;
	lfont.lfOutPrecision   =  OUT_DEFAULT_PRECIS;
	lfont.lfClipPrecision  =  CLIP_DEFAULT_PRECIS;
	lfont.lfQuality        =  DEFAULT_QUALITY;
	lfont.lfPitchAndFamily =  FIXED_PITCH | FF_DONTCARE;
	lstrcpy(lfont.lfFaceName, lpszFntName);

	hListFnt = CreateFontIndirect((LPLOGFONT) &lfont);
	if (hListFnt)
		SelectObject(hdc, hListFnt);
	else
		ErrPrintf(ERR_WARN, "Can't use font %s", lpszFntName);

	GetTextMetrics(hdc, &tm);
	ixChar = tm.tmAveCharWidth;
	iyChar = tm.tmHeight + tm.tmExternalLeading;
	ixUpper = (tm.tmPitchAndFamily & 1 ? 3 : 2) * ixChar/2;
	ReleaseDC(hListWnd, hdc);
}

void ClearFont(void)
{
	if (hListFnt)
		DeleteObject(hListFnt);
	hListFnt = NULL;
}

LRESULT CALLBACK _export LBNewProc(HWND hwnd, UINT message,
													WPARAM wParam, LPARAM lParam)
{
	UINT nLines;
	UINT nCurLin;
	int nTop;

	switch (message)
	{
		case WM_LBUTTONDBLCLK:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_MBUTTONDBLCLK:
		case WM_MBUTTONDOWN:
		case WM_MBUTTONUP:
		case WM_RBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
			return 0;

		case WM_KEYDOWN:
			switch (GET_WM_VKEYTOITEM_CODE(wParam,lParam))
			{
				case VK_HOME:
					SendMessage(hwnd, LB_SETTOPINDEX, 0, 0L);
					break;

				case VK_END:
					nLines = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
															LB_GETCOUNT, 0, 0L);
					SendMessage(hwnd, LB_SETTOPINDEX,
									(WPARAM)(nLines-nViewLin+1), 0L);
					break;

				case VK_UP:
					nCurLin = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
															 LB_GETTOPINDEX, 0, 0L);
					nTop = max(0, (int)nCurLin-1);
					SendMessage(hwnd, LB_SETTOPINDEX, nTop, 0L);
					break;

				case VK_DOWN:
					nLines = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
											LB_GETCOUNT, 0, 0L);
					nCurLin = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
											 LB_GETTOPINDEX, 0, 0L);
					nTop = min(nCurLin+1, nLines-nViewLin+1);
					SendMessage(hwnd, LB_SETTOPINDEX, nTop, 0L);
					break;

				case VK_PRIOR:
					nCurLin = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
															 LB_GETTOPINDEX, 0, 0L);
					nTop = max(0, (int)nCurLin-(int)nViewLin+1);
					SendMessage(hwnd, LB_SETTOPINDEX, nTop, 0L);
					break;

				case VK_NEXT:
					nLines = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
															LB_GETCOUNT, 0, 0L);
					nCurLin = (UINT)CallWindowProc(lpfnLBOldProc, hwnd,
															 LB_GETTOPINDEX, 0, 0L);
					nTop = min(nCurLin+nViewLin, nLines-nViewLin+1);
					SendMessage(hwnd, LB_SETTOPINDEX, nTop, 0L);
					break;
			}
			return 0;

		case WM_CLOSE:
			ClearFont();
			break;
	}
	return CallWindowProc(lpfnLBOldProc, hwnd, message, wParam, lParam);
}

