;testcfg  --  test frame grabber configuration
;
;  FG_PRESENT       IO_OK     image fg == DIS        conclusion
;--------------------------------------------------------------------------
;       0              0            0          0     no framegrabber
;       0              0            1          1        -
;       0              1            0          2        -
;       0              1            1          3        -
;       1              0            0          4     FG not OK
;       1              0            1          5     FG not OK 
;       1              1            0          6     FG OK, but not used
;       1              1            1          7     FG OK, installed OK
;
;Memory tests are only performed if result == 7  (MEM_OK adds 8)
;Therefore: 7 means: memory write error
;                15: all OK
;
;
;
#define MEM_OK     8
#define FG_PRESENT 4 
#define IO_OK      2
#define DISP       1

#define DIS_IM  0x10

parms 
  int report
endparms

int sysprop = 0
int imagprop = 0
int orgpix
string result
char textbuf[40]


imagprop = improp fg
if (imagprop & DIS_IM) == DIS_IM
  sysprop |= DISP
  sysprop |= FG_PRESENT
  if (testio) > 0
     sysprop |= IO_OK
  endif
endif

if sysprop == 7         ;continue only if fg is correctly installed
   orgpix = bgm fg 255  ;write a dot into the image and keep prev. value
   if (bgm fg) == 255
      bgm fg 0
      if (bgm fg) == 0
         sysprop |= MEM_OK
      endif
   endif
   bgm fg orgpix           ;write back orig. value
endif

if report == 1 stop sysprop  ;keer terug met waarde
        
switch sysprop
  case 0
    result = "No frame grabber present"
  case 4
     result = "Frame grabber error: possible wrong IO address"
  case 5
     result = "Frame grabber error: possible wrong IO address"
  case 6
     result = "Frame grabber is OK, but no FG images defined"
  case 7
     result = "Frame grabber error: possible wrong memory base address"
  case 15
     result = "Frame grabber functions correctly"
  default
     fprint textbuf 0 "Illegal combination of signals:  %xh", sysprop
     result = textbuf
endsw

stop result
