#ifndef __EVAL_P_H__
#define __EVAL_P_H__

extern _VOID_ init_eval_once _P_((void));
extern _VOID_ init_eval _P_((void));
extern Lisp_Object call_debugger _P_((Lisp_Object arg));
extern _VOID_ do_debug_on_call _P_((Lisp_Object code));
extern Lisp_Object internal_catch _P_((Lisp_Object tag,
                                       Lisp_Object (*func)(Lisp_Object arg),
                                       Lisp_Object arg));
extern Lisp_Object internal_condition_case _P_((Lisp_Object (*bfun)(void),
                                                Lisp_Object handlers,
                                                Lisp_Object
                                                (*hfun)(Lisp_Object arg)));
extern void _VARARGS_ error _P_((char *m, ...));
extern Lisp_Object un_autoload _P_((Lisp_Object oldqueue));
extern _VOID_ do_autoload _P_((Lisp_Object fundef, Lisp_Object funname));
extern Lisp_Object apply1 _P_((Lisp_Object fn, Lisp_Object arg));
extern Lisp_Object call0 _P_((Lisp_Object fn));
extern Lisp_Object call1 _P_((Lisp_Object fn, Lisp_Object arg1));
extern Lisp_Object call2 _P_((Lisp_Object fn, Lisp_Object arg1,
                              Lisp_Object arg2));
extern Lisp_Object call3 _P_((Lisp_Object fn, Lisp_Object arg1,
                              Lisp_Object arg2, Lisp_Object arg3));
extern Lisp_Object call4 _P_((Lisp_Object fn, Lisp_Object arg1,
                              Lisp_Object arg2, Lisp_Object arg3,
                              Lisp_Object arg4));
extern Lisp_Object call5 _P_((Lisp_Object fn, Lisp_Object arg1,
                              Lisp_Object arg2, Lisp_Object arg3,
                              Lisp_Object arg4, Lisp_Object arg5));
extern Lisp_Object call6 _P_((Lisp_Object fn, Lisp_Object arg1,
                              Lisp_Object arg2, Lisp_Object arg3,
                              Lisp_Object arg4, Lisp_Object arg5,
                              Lisp_Object arg6));
extern Lisp_Object apply_lambda _P_((Lisp_Object fun, Lisp_Object args,
                                     int eval_flag));
extern Lisp_Object funcall_lambda _P_((Lisp_Object fun, int nargs,
                                       Lisp_Object *arg_vector));
extern _VOID_ grow_specpdl _P_((void));
extern _VOID_ specbind _P_((Lisp_Object symbol, Lisp_Object value));
extern _VOID_ record_unwind_protect _P_((Lisp_Object
                                         (*function)(Lisp_Object arg),
                                         Lisp_Object arg));
extern Lisp_Object unbind_to _P_((int count, Lisp_Object value));
extern Lisp_Object top_level_value _P_((Lisp_Object symbol));
extern Lisp_Object top_level_set _P_((Lisp_Object symbol, Lisp_Object newval));
extern _VOID_ syms_of_eval _P_((void));

DEFUN_P(For, (Lisp_Object args));
DEFUN_P(Fand, (Lisp_Object args));
DEFUN_P(Fif, (Lisp_Object args));
DEFUN_P(Fcond, (Lisp_Object args));
DEFUN_P(Fprogn, (Lisp_Object args));
DEFUN_P(Fprog1, (Lisp_Object args));
DEFUN_P(Fprog2, (Lisp_Object args));
DEFUN_P(Fsetq, (Lisp_Object args));
DEFUN_P(Fquote, (Lisp_Object args));
DEFUN_P(Ffunction, (Lisp_Object args));
DEFUN_P(Finteractive_p, (void));
DEFUN_P(Fdefun, (Lisp_Object args));
DEFUN_P(Fdefmacro, (Lisp_Object args));
DEFUN_P(Fdefvar, (Lisp_Object args));
DEFUN_P(Fdefconst, (Lisp_Object args));
DEFUN_P(Fuser_variable_p, (Lisp_Object variable));
DEFUN_P(FletX, (Lisp_Object args));
DEFUN_P(Flet, (Lisp_Object args));
DEFUN_P(Fwhile, (Lisp_Object args));
DEFUN_P(Fmacroexpand, (register Lisp_Object form, Lisp_Object env));
DEFUN_P(Fcatch, (Lisp_Object args));
DEFUN_P(Fthrow, (register Lisp_Object tag, register Lisp_Object val));
DEFUN_P(Funwind_protect, (Lisp_Object args));
DEFUN_P(Fcondition_case, (Lisp_Object args));
DEFUN_P(Fsignal, (Lisp_Object sig, Lisp_Object data));
DEFUN_P(Fcommandp, (Lisp_Object function));
DEFUN_P(Fautoload, (Lisp_Object function, Lisp_Object file,
                      Lisp_Object docstring, Lisp_Object interactive,
                      Lisp_Object type));
DEFUN_P(Feval, (Lisp_Object form));
DEFUN_P(Fapply, (int nargs, Lisp_Object *args));
DEFUN_P(Ffuncall, (int nargs, Lisp_Object *args));
DEFUN_P(Fbacktrace_debug, (Lisp_Object level, Lisp_Object flag));
DEFUN_P(Fbacktrace, (Lisp_Object dummy));
DEFUN_P(Fbacktrace_frame, (Lisp_Object nframes));
    
#endif
