#ifndef __KEYMAP_P_H__
#define __KEYMAP_P_H__

extern _VOID_ initial_define_key _P_((Lisp_Object keymap, int key,
                                      char *defname));
extern _VOID_ initial_define_lispy_key _P_((Lisp_Object keymap, char *keyname,
                                            char *defname));
extern Lisp_Object get_keymap_1 _P_((Lisp_Object object, int error,
                                     int autoload));
extern Lisp_Object get_keymap _P_((Lisp_Object object));
extern Lisp_Object access_keymap _P_((Lisp_Object map, Lisp_Object idx,
                                      int t_ok, int noinherit));
extern Lisp_Object get_keyelt _P_((register Lisp_Object object));
extern Lisp_Object store_in_keymap _P_((Lisp_Object keymap,
                                        register Lisp_Object idx,
                                        register Lisp_Object def));
extern Lisp_Object append_key _P_((Lisp_Object key_sequence, Lisp_Object key));
extern int current_minor_maps _P_((Lisp_Object **modeptr,
                                   Lisp_Object **mapptr));
extern char * push_key_description _P_((register unsigned int c,
                                        register char *p));
extern char * push_text_char_description _P_((register unsigned int c,
                                              register char *p));
extern _VOID_ describe_map_tree _P_((Lisp_Object startmap, int partial,
                                     Lisp_Object shadow, Lisp_Object prefix,
                                     char *title));
extern _VOID_ describe_vector _P_((register Lisp_Object vector,
                                   Lisp_Object elt_prefix,
                                   void (*elt_describer)(Lisp_Object desc),
                                   int partial, Lisp_Object shadow));
extern _VOID_ syms_of_keymap _P_((void));
extern _VOID_ keys_of_keymap _P_((void));
    
DEFUN_P(Fmake_keymap, (Lisp_Object string));
DEFUN_P(Fmake_sparse_keymap, (Lisp_Object string));
DEFUN_P(Fkeymapp, (Lisp_Object object));
DEFUN_P(Fcopy_keymap, (Lisp_Object keymap));
DEFUN_P(Fdefine_key, (Lisp_Object keymap, Lisp_Object key, Lisp_Object def));
DEFUN_P(Flookup_key, (register Lisp_Object keymap, Lisp_Object key,
                      Lisp_Object accept_default));
DEFUN_P(Fkey_binding, (Lisp_Object key, Lisp_Object accept_default));
DEFUN_P(Flocal_key_binding, (Lisp_Object keys, Lisp_Object accept_default));
DEFUN_P(Fglobal_key_binding, (Lisp_Object keys, Lisp_Object accept_default));
DEFUN_P(Fminor_mode_key_binding, (Lisp_Object keys,
                                  Lisp_Object accept_default));
DEFUN_P(Fglobal_set_key, (Lisp_Object keys, Lisp_Object function));
DEFUN_P(Flocal_set_key, (Lisp_Object keys, Lisp_Object function));
DEFUN_P(Fglobal_unset_key, (Lisp_Object keys));
DEFUN_P(Flocal_unset_key, (Lisp_Object keys));
DEFUN_P(Fdefine_prefix_command, (Lisp_Object name, Lisp_Object mapvar));
DEFUN_P(Fuse_global_map, (Lisp_Object keymap));
DEFUN_P(Fuse_local_map, (Lisp_Object keymap));
DEFUN_P(Fcurrent_global_map, (void));
DEFUN_P(Fcurrent_local_map, (void));
DEFUN_P(Fcurrent_minor_mode_maps, (void));
DEFUN_P(Faccessible_keymaps, (Lisp_Object startmap, Lisp_Object prefix));
DEFUN_P(Fkey_description, (Lisp_Object keys));
DEFUN_P(Fsingle_key_description, (Lisp_Object key));
DEFUN_P(Ftext_char_description, (Lisp_Object chr));
DEFUN_P(Fwhere_is_internal, (Lisp_Object definition, Lisp_Object local_keymap,
                             Lisp_Object global_keymap, Lisp_Object firstonly,
                             Lisp_Object noindirect));
DEFUN_P(Fwhere_is, (Lisp_Object definition));
DEFUN_P(Fdescribe_bindings, (Lisp_Object prefix));
DEFUN_P(Fdescribe_vector, (Lisp_Object vector));
DEFUN_P(Fapropos_internal, (Lisp_Object string, Lisp_Object pred));

#endif
