/* taffin.c - Test the affinity APIs
*/

#include <windows.h>
#include <stdio.h>
#include "affin.h"

void main( )
{
   DWORD ProcAff;
   DWORD SysAff;
   DWORD ThdAff;

   printf( "\nGetting the process affinity mask...\n" );
   if (!GetProcessAffinityMask( GetCurrentProcess(), &ProcAff, &SysAff) )
      printf( "GetProcessAffinityMask failed\n" );
   else
      printf( "System Affinity = %x\nProcess affinity = %x\n\n", SysAff, ProcAff );

   printf( "Setting the thread affinity mask to the process affinity mask...\n" );
   ThdAff = SetThreadAffinityMask( GetCurrentThread(), ProcAff );
   if ( !ThdAff )
      printf( "SetThreadAffinityMask(%x) failed\n\n", ProcAff );
   else printf( "Previous thread affinity %x\n\n", ThdAff );

   printf( "Setting the thread affinity mask to 2...\n" );
   ThdAff = SetThreadAffinityMask( GetCurrentThread(), 2 );
   if ( !ThdAff )
      printf( "SetThreadAffinityMask(2) failed\n\n" );
   else printf( "Previous thread affinity %x\n\n", ThdAff );

   printf( "Setting the thread affinity mask to 3...\n" );
   ThdAff = SetThreadAffinityMask( GetCurrentThread(), 3 );
   if ( !ThdAff )
      printf( "SetThreadAffinityMask(3) failed\n\n" );
   else printf( "Previous thread affinity %x\n\n", ThdAff );
}
