/*-------------------------------------------------------------------------
 AppExit.c

 A Exit Windows utility for AppBar.

 by
 GMP van kempen
 NEVERnever Software 1993

4.00.1 Initial release
4.00.2 added "now" commandline option to exit Windows immediately.
       made "OK" button default push button.

---------------------------------------------------------------------------*/
//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <ctl3d.h>
#include <stdio.h>
#include <string.h>
#include "appexit.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKEDEFBUTTON(a,b,c,d,e,f) MAKECHILD("button",a,BS_DEFPUSHBUTTON,b,c,d,e,f)
#define MAKETEXT(a,b,c,d,e)	   MAKECHILD("static",a,SS_CENTER,b,c,d,e,(HMENU) -1)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU) -1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

char	    szAppName[] = "AppExit";
HINSTANCE   hInst;


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    int 	xScreen, yScreen, yCaption, xSize, ySize;

    if(_fstrstr(lpszCmdLine, "now"))
	{
	ExitWindows(NULL, NULL);
	return msg.wParam;
	}

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, szAppName);
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    hInst = hInstance;

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    yCaption = GetSystemMetrics(SM_CYCAPTION);

    Ctl3dRegister(hInstance);
    Ctl3dAutoSubclass(hInstance);

    xSize = 260;
    ySize = 93 + yCaption;

    hWnd = CreateWindow(szAppName, "AppExit 4.0",
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			(xScreen - xSize)/2, yScreen/2 - ySize,
			xSize, ySize,
			NULL, (HMENU) NULL, hInstance, NULL);

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInstance);

    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    char *Button[3] = {"&No","&Yes","&Restart"};
    HBRUSH hbrush;
    HWND hWndButton[3];

    switch (message)
	{
	case WM_CREATE:
	    // create static frame around text fields
	    Ctl3dSubclassCtl(MAKEBORDER(0, 0, 258, 92));
	    Ctl3dSubclassCtl(MAKESTATIC(9, 9, 242, 42));
	    hWndButton[0] = MAKEBUTTON(Button[0], 10, 60, 80, 24, IDC_BUTTONS);
	    hWndButton[1] = MAKEDEFBUTTON(Button[1], 10+80, 60, 80, 24, IDC_BUTTONS+1);
	    hWndButton[2] = MAKEBUTTON(Button[2], 10+160, 60, 80, 24, IDC_BUTTONS+2);
	    Ctl3dSubclassCtl(MAKETEXT("Leave Windows?", 20, 16, 220, 20));
	    return 0;

	case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
	   break;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

       case WM_KEYDOWN:
	    if(wParam == VK_RETURN)
		SendMessage(hWnd, WM_COMMAND, IDC_BUTTONS+1, 0);
	    return 0;

       case WM_COMMAND:
	    switch(wParam)
		{
		case IDC_BUTTONS: /* No */
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;

		case IDC_BUTTONS+1:  /* Yes */
		    ExitWindows(NULL, NULL);
		    break;

		case IDC_BUTTONS+2: /* Restart */
		    ExitWindows(EW_RESTARTWINDOWS, NULL);
		    break;
		}
	    break;

       case WM_DESTROY:	// kill the whole program
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */
