/*
    exec.c

    This module contains the ExecApp and IsAppRunning functions
    It relies on the global ghInstance;

*/

//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "apprun.h"

// local data
static char *szProgramsSection = "programs"; // WIN.INI section

// local functions
static int TryWinExec(LPSTR pszPath, LPSTR pszParams);

//
// Run a named application
//

UINT ExecApp(HWND hwndParent, LPSTR pszPath, LPSTR pszParams)
{
    char szPath[_MAX_PATH];
    char szNewPath[_MAX_PATH];
    char szDrive[_MAX_DRIVE];
    char szDir[_MAX_DIR];
    char szFname[_MAX_FNAME];
    char szExt[_MAX_EXT];
    int i;

    //
    // Copy the path and convert to upper case
    //

    _fstrcpy(szPath, pszPath);
    _fstrupr(szPath);

    //
    // Split up the components of the path
    //

    _splitpath(szPath, szDrive, szDir, szFname, szExt);

    //
    // See if it already has an extension
    // and if not, provide .EXE
    //

    if (!_fstrlen(szExt)) {

        _fstrcpy(szExt, ".EXE");

    } else {

        //
        // Make sure it's EXE and not something bogus
        //

        if (!_fstricmp(szExt, ".EXE")) {

            return INVALID_NAME;
        }
    }

    //
    // Try and run it.
    //

    _makepath(szNewPath, szDrive, szDir, szFname, szExt);

    i = TryWinExec(szNewPath, pszParams);

    if ((i == RAN_OK) || (i == SOME_ERROR)) {
        return i;
    }

    //
    // It couldn't be found because it either wasn't on the search
    // path or because the path supplied was invalid.
    // See if we have a WIN.INI entry for it.
    //

    _makepath(szPath, "", "", szFname, szExt);
    i = GetProfileString(szProgramsSection,	// [programs]
                         szPath,                // <app>.EXE
                         "",                    // default
                         szNewPath,             // result
                         sizeof(szNewPath));

    if (i != 0)
	return TryWinExec(szNewPath, pszParams);
    else
	return SOME_ERROR;
}

//
// Try running an app by calling WinExec.  If it works, return some
// info about the app in the struct pointed to by pInfo.
// It returns RAN_OK, NOT_FOUND or SOME_ERROR.
//

static int TryWinExec(LPSTR pszPath, LPSTR pszParams)
{
    char szCmdLine[_MAX_PATH + 256];
    UINT uiResult;

    _fstrcpy(szCmdLine, pszPath);
    _fstrcat(szCmdLine, " ");
    _fstrcat(szCmdLine, pszParams);
    uiResult = WinExec(szCmdLine, SW_SHOWNORMAL);

    if ((uiResult == 2) || (uiResult == 3)) {
        return NOT_FOUND;
    }

    if (uiResult < 32) {
        return SOME_ERROR;
    }

    return RAN_OK;
}
