/*-------------------------------------------------------------------------
 AppPlay.c

 A Wave file Player for AppBar.

 by
 GMP van kempen
 NEVERnever Software 1993

History:

4.00.1 Initial release
4.00.2 Added change Button, improved looks
4.00.3 Made "OK" button default push button. Improved handling of
       the commandline.

---------------------------------------------------------------------------*/
//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <shellapi.h>
#include <ctl3d.h>
#include <stdio.h>
#include <string.h>
#include "appplay.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKEDEFBUTTON(a,b,c,d,e,f) MAKECHILD("button",a,BS_DEFPUSHBUTTON,b,c,d,e,f)
#define MAKETEXT(a,b,c,d,e)	   MAKECHILD("static",a,SS_LEFT,b,c,d,e,(HMENU) -1)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU) -1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

char	    szAppName[] = "AppPlay";
HINSTANCE   hInst;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    int 	xScreen, yScreen, yCaption, xSize, ySize;

    lstrcpy(szBuffer, lpszCmdLine);
    if(strlen(szBuffer))
	{
	sndPlaySound(szBuffer, SND_ASYNC | SND_NODEFAULT);
	return msg.wParam;
	}

    if(!hPrevInstance)
	{
	wndclass.style		    = NULL;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, szAppName);
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    hInst = hInstance;

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    yCaption = GetSystemMetrics(SM_CYCAPTION);

    Ctl3dRegister(hInstance);

    xSize = 260;
    ySize = 123 + yCaption;

    hWnd = CreateWindow(szAppName, "AppPlay 4.0",
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			(xScreen - xSize)/2, yScreen/2 - ySize,
			xSize, ySize,
			NULL, (HMENU) NULL, hInstance, NULL);

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInstance);

    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    char *Button[3] = {"&Help","&OK","&Change"};
    char Text[2][256];
    int i, DroppedFiles;
    HBRUSH hbrush;
    HWND hWndButton[3];

    switch (message)
	{
	case WM_CREATE:
	    // create static frame around text fields
	    Ctl3dSubclassCtl(MAKEBORDER(0, 0, 258, 122));
	    Ctl3dSubclassCtl(MAKESTATIC(9, 9, 242, 72));
	    strcpy(Text[0], "A Wavefile play utility for AppBar");
	    GetPrivateProfileString("drivers","Wave", "<none>",
					szBuffer, 255, "system.ini");
	    sprintf(Text[1], "Current sound driver: %s",szBuffer);
	    hWndButton[0] = MAKEBUTTON(Button[0], 10, 90, 80, 24, IDC_BUTTONS);
	    hWndButton[1] = MAKEDEFBUTTON(Button[1], 10+80, 90, 80, 24, IDC_BUTTONS+1);
	    hWndButton[2] = MAKEBUTTON(Button[2], 10+160, 90, 80, 24, IDC_BUTTONS+2);
	    for(i=0;i<2;i++)
		MAKETEXT(Text[i], 16, 16+i*22, 230, 20);
	    DragAcceptFiles(hWnd, TRUE);
	    return 0;

	case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
	   break;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

       case WM_KEYDOWN:
	    if(wParam == VK_RETURN)
		SendMessage(hWnd, WM_COMMAND, IDC_BUTTONS+1, 0);
	    return 0;

       case WM_DROPFILES:
	    DroppedFiles = DragQueryFile((HANDLE) wParam, 0xFFFF, (LPSTR) NULL, 0);
		for(i=0;i<DroppedFiles;i++)
		    {
		    DragQueryFile((HANDLE) wParam, i, szBuffer, sizeof(szBuffer));
		    sndPlaySound(szBuffer, SND_ASYNC | SND_NODEFAULT);
		    }
	    DragFinish((HANDLE) wParam);
	    return 0;

       case WM_COMMAND:
	    switch(wParam)
		{
		case IDC_BUTTONS: /* help */
		    WinHelp(hWnd, "AppTools.hlp",HELP_CONTENTS, 0L);
		    break;

		case IDC_BUTTONS+1:  /* Ok */
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;

		case IDC_BUTTONS+2: /* Change */
		    WinExec("control.exe",SW_SHOWNORMAL);
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;
		}
	    break;

       case WM_DESTROY:	// kill the whole program
	    DragAcceptFiles(hWnd, FALSE);
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */
