/*-------------------------------------------------------------------------
 AppBar.c

 A buttonbar to launch applications from.

 by
 GMP van kempen
 NEVERnever Software 1991-1993

history:
    0.xx    tryout versions
    3.1     first serious version, added move option,
	    use of ini-file.
    3.14    added QuickView
    3.141   improved fool-proofness, added toggle start/close
	    an application, second button now terminates Windows.
	    first released version.
    3.1415  added greyed buttons when a program is active, improved
	    the looks of appbar. Nicer aboutbox.
	    Exit option built-in. Made use of Columns possible
	    and increased maximum number of buttons up to 24.
    3.1415a For closing a program now using WM_CLOSE instead of
	    WM_DESTROY. Adding possibility to specify a StartDirectory.
    3.1415b Added option to skip the closing feature.
    3.1415c Changed the way a HWND of a started programs was got.
	    Changed initialization of IcoFileName, ProgFileName, StartDir.
    3.14159 Upgraded to Win3.1. Changed redrawing code for icons.
	    Added Setup program. Added Restart Option. Fixed bug
	    in startDir function: current drive is also changed.
	    Added click or DoubleClick mode. Added Start normal, maximized or
	    minimized. Increased maximum buttons to 32.
	    Load= and Run= statements in win.ini are supported when
	    AppBar is shell. StayInFront option is added. Changed Aboutbox.
	    Improved StayInfront. Skipped close option for all *.com and *.pif
	    files. Start AppSetup when appbar not initialized. Changed ini-file format.
	    Changed the looks of exitWindows Dialog window.
APPBAR_NEW
    for Windows 3.1
    3.20    Source ported to Windows 3.1. Uses ExtractIcon getting the Icon
	    from a file. Displaying with DrawIcon. Added DropFile function.
	    Added Sound. Made Dialog Boxes resolution independent. Fixed dialog
	    EndPaint bugs. Improved Close function by checking if AppBar
	    is shell. Fixed redraw button problem. Used a timer to check
	    program states regularly. When AppBar is Shell, the Close button
	    will Exit Windows. The groupfile specified by ShellGroup= will
	    be executed when AppBar is Shell.
    3.30    made drop of multiple files possible. If Shell, AppBar won't
	    launch itself when it is also specified in load=, run= or ShellGroup.
	    Use ShellExecute instead of WinExec. Now possible to specify
	    Datafiles and StartUpParameters. Added QuickLoad Option.
	    Max Buttons = 48. Added Run Option. Start ShellGroup programs
	    minimized. Improved closefunction by subclassing closing window,
	    (Thanks to Erkki Riekkola). Bug fixed in max-columns, is now
	    MAXBUTTONS, was MAXAPPS. Added maxsize option. Added save option
	    to move button. Removed IsDosExe(), rely on IsDosWindow() now.
	    Made AppBar restartable when it is Shell. Also will it execute
	    the options given to win.com when it is shell. Made Shellcheck
	    on "appbar.exe" case insensitive. Use Shellexecute in IsShell()
	    when executing load= & run= lines. If Buttons % Rows isn't zero,
	    add Buttons up till it is. Added WM_APPBAR_RESTART message. Added
	    minimize button.
    4.00    - Made use of ctl3D.dll for 3D looks on dialog boxes.
	    - Changed clicking mode:
	      MOUSE_CLICK:		launch program, if NOTALIVE
					bring to from, if still ALIVE
	      MOUSE_DOUBLECLICK:	kill program if ALIVE
	      (double_click option is abandonned)
	    - Fixed ALT-F4 bug: AppBar will exit windows if it is shell and
	      ALT-F4 is pressed.
	    - Improved the executing of groupfiles. (but ShellGroup now only
	      accepts one groupfile!)
	    - Added RestartWindows option to ExitWindows Dialog.
	    - Added simple keyboard interface:
	      ESCAPE:	   toggles between keyboard interface on/off
	      ENTER:	   is MOUSE_CLICK on current button
	      DELETE:	   is MOUSE_DOUBLECLICK on current button
	      UP ARROW:    move current button 1 up
	      DOWN ARROW:  move current button 1 down
	    - Added Help system.
	    - Added optional multiple systembuttons. Not only exit button,
	      but run button also. (If AppBar is shell, the exit button will
	      always be included)
	    - Improved error messages.
	    - added NoSound option. AppBar will not play the program-start sound
	      if this option is chosen.
	    - restored Doubleclick option
	    - Added BigButtons & borders
	    - Moved Run button to separate App.
	    (4.00.4)
	    - fixed a bug with the exit button, it will now always be shown
	      if AppBar is shell, even if no Exit Button is selected.
	    - fixed problem with dropping files and bordersize.
	    - fixed bug with updating closed programs (CheckProgramStatus())
	    - added a StayInFront toggle button to the systembuttons.
	    - fixed bug that AppBar only closes and not exit Windows when
	      it is shell and restarted.
	    - removed Exit Button, and made it a separate App.
	    (4.00.5)
	    - fixed a bug in reading minimized bit in groupfiles (thanks
	      to Andy Jacobs).
	    - Made "NoSound" also work on dropped files.
	    - removed QuickExit option for the removed Exit Button.
	    - moved some functions to APPLIB.DLL
	    (4.00.6)
	    - moved IsAppBarShell back from applib.dll to appbar.exe
	    - changed ReadButtonIni and SvaButtonIni functions
	    - improved value checking of AppSystem.Top & AppSystem.Left
	    - significantly improved the communication speed of AppBar and
	      Tip, by dropping more then one filename at the time.
	    - fixed a bug with Notepad when dropping extensionless files, by
	      adding a dot to the filename.

---------------------------------------------------------------------------*/

//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <string.h>
#include <stdio.h>
#include <ctl3d.h>
#include <memory.h>
#include "appbar.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)	   MAKECHILD("button",a,BS_PUSHBUTTON | BS_OWNERDRAW,b,c,d,e,f)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU)-1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

APPBARBUTTONS	 AppButton[MAXAPPS], AppEmptyButton;
APPSYSTEM	 AppSystem;
APPSOUND	 AppSound;
APPWINDOW	 AppWindow = {1, MAXBUTTONS, 32, 32};
APPMAXSIZE	 AppMaxSize;
char		 szAppName[] = "AppBar";
int		 iCurrent = 0, iActive = 0, iKey = 1;
int		 cxChar, cyChar, iShuffledButton, FirstAppButton = 1;
HWND		 hWndMain, hWndButton[MAXBUTTONS], hWndCurrentButton;
HINSTANCE	 hInst, hPrevInst;
HBITMAP		 hAppLogo, hNNever, hbBlank, hbKeyb;
HBITMAP 	 hbPressed;
HICON		 hSystem, hBlank, hPressed, hQuickLoad, hKeybOn;
HICON		 hPressed2, hSystem2;
LPDRAWITEMSTRUCT lpIconDIS;
BOOL		 bQuickLoad = FALSE, bMoveButton = FALSE;
BOOL		 bKeyboardOn = FALSE, bExecuteProg = TRUE, bShuffleButton = FALSE;
short		 Rows, xSize, ySize;


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    short	xScreen, yScreen;

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, MAKEINTRESOURCE(1000));
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    SetCursor(LoadCursor(NULL, IDC_WAIT));

    hInst = hInstance;
    hPrevInst = hPrevInstance;

    Ctl3dRegister(hInst);
    Ctl3dAutoSubclass(hInst);

    // read the settings from AppBar.ini
    IniRead();

    if(AppSystem.BigButtons)
	AppWindow.cxButton = AppWindow.cyButton = 38;

    LoadAppBarResources();

    // if AppBar is Shell, execute the load=, run=, startup groupfiles
    // and cmdline parameters given to win.com (at start of Windows)
    // only at the first instance of AppBar.
    if(!hPrevInstance)
	{
	if(IsAppBarShell())
	    {
	    WinExec(lpszCmdLine, SW_SHOWNORMAL);
	    DoShellTasks();
	    }
	}

    AppWindow.nButtons = AppSystem.Buttons+FirstAppButton;
    AppWindow.nColumns = AppSystem.Columns;

    // try to add enough buttons to fill all the columns
    while(AppWindow.nButtons % AppWindow.nColumns)
	{
	AppWindow.nButtons++;
	if(AppWindow.nButtons > MAXAPPS)
	    break;
	}
    if(AppWindow.nButtons % AppWindow.nColumns)
	{
	AppWindow.nButtons = AppSystem.Buttons+FirstAppButton;
	AppWindow.nColumns = 1;
	}

    AppMaxSize = CalculateAppMaxSize();

    if(AppSystem.Left == -1) // -1 is default, right top of the screen.
	{
	xScreen = GetSystemMetrics(SM_CXSCREEN) - AppSystem.Border;
	xScreen -= (AppWindow.cxButton+AppSystem.Border)*AppWindow.nColumns;
	}
    else
	xScreen = AppSystem.Left;
    if(AppSystem.Top == -1)
	yScreen = 0;
    else
	yScreen = AppSystem.Top;

    Rows = AppWindow.nButtons/AppWindow.nColumns;
    xSize = AppWindow.cxButton*AppWindow.nColumns;
    xSize += (AppWindow.nColumns+1)*AppSystem.Border;
    ySize = AppWindow.cyButton*Rows + (Rows+1)*AppSystem.Border;

    hWnd = CreateWindow(szAppName, "AppBar 4.0",
			WS_POPUP | WS_VISIBLE,
			xScreen, yScreen, xSize, ySize,
			NULL, NULL, hInstance,NULL);

    hWndMain = hWnd;
    SetTimer(hWnd, ID_TIMER, 1000, NULL);
    SetCursor(LoadCursor(NULL, IDC_ARROW));
    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInst);
    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnSystemDlgProc;
    static HICON   hIcon[MAXAPPS];
    TEXTMETRIC	   tm;
    HBRUSH	   hbrush;
    int 	   i, xPos, yPos;

    switch (message)
	{
	case WM_CREATE:
	    if(AppSystem.Initialized < APPBARVERSION)
		if(WinExec("AppSetup.exe",SW_SHOWNORMAL) >= 32)
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
	    tm = RetrieveTextMetrics(hWnd);
	    cxChar = tm.tmAveCharWidth;
	    cyChar = tm.tmHeight;
	    if(AppSystem.Border)
		Ctl3dSubclassCtl(MAKEBORDER(0, 0, xSize, ySize));
	    for(i=0;i<AppWindow.nButtons;i++)
		{
		xPos=AppSystem.Border+(AppSystem.Border+AppWindow.cxButton)*(i/(AppWindow.nButtons/AppWindow.nColumns));
		yPos=AppSystem.Border+(AppSystem.Border+AppWindow.cyButton)*(i%(AppWindow.nButtons/AppWindow.nColumns));
		if(AppSystem.Border)
		    Ctl3dSubclassCtl(MAKESTATIC(xPos-1, yPos-1,
				AppWindow.cxButton+2, AppWindow.cyButton+2));
		hWndButton[i] = MAKEBUTTON(NULL, xPos, yPos,
				AppWindow.cxButton, AppWindow.cyButton,
				ID_BUTTON1+i);
		}
	    LoadAllButtonIcons(hIcon);
	    SetNormalChildCursor();
	    DragAcceptFiles(hWnd, TRUE);
	    InitTip();
	    if(AppSound.EnableSound != 0)
		if(stricmp(AppSound.AppBarStart, "<none>") != 0)
		    sndPlaySound(AppSound.AppBarStart, SND_ASYNC | SND_NODEFAULT);
	    return 0;

	case WM_SYSCOLORCHANGE:
	    Ctl3dColorChange();
	    return 0;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

	case WM_SYSCHAR:
	case WM_SYSKEYUP:
	    return 0;

	case WM_SYSKEYDOWN:
	    return ProcessSystemKeys((int) wParam);

	case WM_KEYDOWN:
	    return KeyboardInterface((int)wParam);

	case WM_DRAWITEM:
	    DrawItem((LPDRAWITEMSTRUCT)lParam, hIcon);
	    return 0;

	case WM_TIMER:
	    CheckProgStatus();
	    if(AppSystem.StayInFront == 1 && GetActiveWindow() != hWndMain)
		SetWindowPos(hWnd, NULL, 0, 0, 0, 0,
			     SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
	    return 0;

	case WM_COMMAND:
	     // If a button was clicked, then it is the currently selected tool.
	    if(HIWORD(lParam) == BN_CLICKED || HIWORD(lParam) == BN_DOUBLECLICKED)
		{
		if((wParam >= (UINT) ID_BUTTON1) && (wParam <= (UINT) (ID_BUTTON1 + AppWindow.nButtons)))
		    {
		    iCurrent = 0;
		    while((ID_BUTTON1 + iCurrent) != (int) wParam)
			iCurrent++; // just increment i !!
		    iKey = iCurrent; // sync keyb interface with mouse click
		    if(iCurrent < FirstAppButton)
			{
			if((HIWORD(lParam) == BN_CLICKED && !AppSystem.DoubleClick) || (HIWORD(lParam) == BN_DOUBLECLICKED && AppSystem.DoubleClick))
			    {
			    if(iCurrent == SYSTEM_BUTTON)
				{
				lpfnSystemDlgProc = (DLGPROC) MakeProcInstance((FARPROC)SystemDlgProc, hInst);
				DialogBox(hInst, "SystemDlg", hWnd, lpfnSystemDlgProc);
				FreeProcInstance( (FARPROC) lpfnSystemDlgProc);
				break;
				}
			    }
			}
		    if(iCurrent >= FirstAppButton)
			{
			if(!bQuickLoad)
			    {
			    CheckProgStatus();
			    StartOrCloseProgram(iCurrent-FirstAppButton, HIWORD(lParam)); // start and close programs linked to a button.
			    }
			else //QuickLoad is active
			    {
			    if(bShuffleButton)
				{
				bShuffleButton = FALSE;
				SetNormalChildCursor();
				AppButton[iCurrent-FirstAppButton] = AppButton[iShuffledButton-FirstAppButton];
				hIcon[iCurrent-FirstAppButton] = hIcon[iShuffledButton-FirstAppButton];
				SaveButtonIni(AppButton[iCurrent-FirstAppButton], iCurrent-FirstAppButton, (LPSTR) INI_BUTTON, (LPSTR) INI_FILE);
				InvalidateRect(hWndButton[iCurrent], NULL, TRUE);
				InvalidateRect(hWndButton[iShuffledButton], NULL, TRUE);
				UpdateWindow(hWnd);
				}
			    else
				{
				bShuffleButton = TRUE;
				SetShuffleChildCursor();
				iShuffledButton = iCurrent;
				}
			    }
			}
		    }
		}
	    if(wParam == WM_APPBAR_RESTART)
		if(WinExec("AppBar.exe", SW_SHOWNORMAL) > 32)
		    PostMessage(hWndMain, WM_CLOSE, 0, 0);

	    if(wParam == WM_APPBAR_CLOSE)
		{
		InvalidateRect(hWndButton[0], NULL, TRUE);
		UpdateWindow(hWnd);
		SendMessage(hWndMain, WM_DESTROY, 0, 0);
		}

	    if(wParam == PM_TIP_SETICON)
		TipSetIcon((WORD) (lParam-1), hIcon);

	    return 0;	 /* end WM_COMMAND */

       case WM_DROPFILES:
	    ProcessDropFiles((HANDLE) wParam, hIcon);
	    return 0;

	case WM_LBUTTONDOWN:	// Allows moving of a whole window
	    SetCursor(LoadCursor(NULL, IDC_SIZE));
	    bMoveButton = TRUE;
	    return(DefWindowProc(hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam));

	case WM_MOVE:
	    if(bMoveButton)
		{
		bMoveButton = FALSE;
		if(MessageBox(NULL,"Save AppBar's new position","AppBar 4.0",MB_YESNO) ==IDYES)
		    {
		    /* horizontal position */
		    AppSystem.Left = (int) LOWORD(lParam);
		    /* vertical position */
		    AppSystem.Top = (int) HIWORD(lParam);
		    sprintf(szBuffer,"%d", AppSystem.Left);
		    WritePrivateProfileString(INI_SYSTEM, LEFT, szBuffer, INI_FILE);
		    sprintf(szBuffer,"%d", AppSystem.Top);
		    WritePrivateProfileString(INI_SYSTEM, TOP, szBuffer, INI_FILE);
		    }
		}
	    return 0;

	case WM_ACTIVATEAPP:
	    if(wParam == 0)
		if(GetActiveWindow() != NULL)
		    if(iActive != 0)
			{
			AppButton[iActive-1].hWndApp = GetActiveWindow();
			if(AppButton[iActive-1].ShowMode == 3)
			    SetWindowPos(AppButton[iActive-1].hWndApp,
					 NULL,
					 AppMaxSize.left,
					 AppMaxSize.top,
					 AppMaxSize.width,
					 AppMaxSize.height,
					 SWP_NOACTIVATE | SWP_NOZORDER);
			if(AppButton[iActive-1].Close)
			    AppButton[iActive-1].Close = !IsDosWindow(AppButton[iActive-1].hWndApp);
			if(AppButton[iActive-1].Close)
			    AppButton[iActive-1].ProgStatus = ALIVE;
			else
			    AppButton[iActive-1].ProgStatus = NOTALIVE;
			iActive = 0;
			InvalidateRect(hWndCurrentButton, (LPRECT) NULL, FALSE);
			UpdateWindow(hWndCurrentButton);
			}
	    return 0;

       case WM_DESTROY:	// kill the whole program
	    KillTimer(hWnd, ID_TIMER);
	    FreeAppBarResources();
	    DragAcceptFiles(hWnd, FALSE);
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */
