#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <string.h>
#include "appbar.h"

/*************************************************************************/
/*  FUNCTION: DlgAboutProc()						 */
/*									 */
/*  WindowProc for the AboutBox						 */
/*************************************************************************/
BOOL WINAPI AboutDlgProc(HWND hDlgAbout, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static HANDLE hLibrary;
    HDC hDC;
    RECT rc;
    PAINTSTRUCT ps;

    switch(message)
	{
	case WM_INITDIALOG:
	    hLibrary = LoadLibrary("APPLIB.DLL");
	    hAppLogo = LoadBitmap(hLibrary, "AppLogo");
	    hNNever = LoadBitmap(hLibrary, "NNever");
	    return TRUE;

	case WM_PAINT:
	    hDC = BeginPaint(hDlgAbout, &ps);
	    rc = ps.rcPaint;
	    // draw two Bitmaps in the AboutBox
	    DrawBitmap(hDC, rc.left+4*cxChar, rc.top+cyChar, hAppLogo);
	    DrawBitmap(hDC, rc.left+3*cxChar, rc.top+cyChar*5, hNNever);
	    EndPaint(hDlgAbout, &ps);
	    return 0;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDOK:
		    FreeLibrary(hLibrary);
		    EndDialog(hDlgAbout, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    } /* end DlgAboutProc */

/*************************************************************************/
/*  FUNCTION: SystemDlgProc						 */
/*									 */
/*  Dialog for the SystemButtonBar					 */
/*************************************************************************/
BOOL WINAPI SystemDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnAboutDlgProc, lpfnExitWDlgProc;

    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_COMMAND:
	   if(HIWORD(lParam) == BN_CLICKED)
		{
		switch(wParam)
		    {
		    case ID_CLOSE:
			if(!IsAppBarShell())
			    {
			    if(AppSound.EnableSound != 0)
				if(stricmp(AppSound.AppBarExit, "<none>") != 0)
				    sndPlaySound(AppSound.AppBarExit, SND_ASYNC | SND_NODEFAULT);
			    SendMessage(hWndMain, WM_COMMAND, WM_APPBAR_CLOSE, 0L);
			    EndDialog(hDlg, TRUE);
			    }
			else
			    {
			    EndDialog(hDlg, TRUE);
			    lpfnExitWDlgProc = (DLGPROC) MakeProcInstance((FARPROC)ExitWDlgProc, hInst);
			    DialogBox(hInst, "ExitWDlg", hWndMain, lpfnExitWDlgProc);
			    FreeProcInstance((FARPROC)lpfnExitWDlgProc);
			    }
			break;

		    case ID_ABOUT:
			lpfnAboutDlgProc = (DLGPROC) MakeProcInstance((FARPROC)AboutDlgProc, hInst);
			DialogBox(hInst, "AboutDlg", hDlg, lpfnAboutDlgProc);
			FreeProcInstance((FARPROC)lpfnAboutDlgProc);
			EndDialog(hDlg, 0);
			return TRUE;

		    case ID_MOVE:	// Changes the window style to size it
			EndDialog(hDlg, TRUE);
			bMoveButton = TRUE;
			SendMessage(hWndMain, (UINT) WM_LBUTTONDOWN, wParam, lParam);
			break;

		    case ID_SETUP:
			EndDialog(hDlg, TRUE);
			WinExec("appsetup.exe", SW_SHOWNORMAL);
			break;

		    case ID_RESTART:
			EndDialog(hDlg, TRUE);
			SendMessage(hWndMain, WM_COMMAND, WM_APPBAR_RESTART, 0L);
			break;

		    case ID_HELP:
			EndDialog(hDlg, TRUE);
			WinHelp(hWndMain,"appbar.hlp", HELP_CONTENTS, 0L);
			break;

		    case ID_MINIMIZE:
			EndDialog(hDlg, TRUE);
			bKeyboardOn = FALSE;
			ShowWindow(hWndMain, SW_SHOWMINIMIZED);
			break;

		    case ID_INFRONT:
			EndDialog(hDlg, TRUE);
			if(AppSystem.StayInFront == 1)
			    AppSystem.StayInFront = 0;
			else
			    AppSystem.StayInFront = 1;
			break;

		    case ID_QUICKLOAD:
			bQuickLoad = !bQuickLoad;
			if(!bQuickLoad)
			    SetNormalChildCursor();
			EndDialog(hDlg, TRUE);
			InvalidateRect(hWndButton[0], NULL, FALSE);
			UpdateWindow(hWndButton[0]);
			return TRUE;

		    case ID_CANCEL:
			EndDialog(hDlg, 0);
			return TRUE;
		    }
		}
	   break; /* end WM_COMMAND */
	}
    return FALSE;
    } /* end DlgSysProc */

/*-------------------------------------------------------------------------*/
BOOL WINAPI ExitWDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDEXITW_YES:
		    EndDialog(hDlg, 0);
		    if(AppSound.EnableSound != 0)
			if(stricmp(AppSound.WindowsExit, "<none>") != 0)
			    sndPlaySound(AppSound.WindowsExit, SND_ASYNC | SND_NODEFAULT);
		    ExitWindows(NULL, NULL);
		    return TRUE;

		case IDEXITW_RESTART:
		    EndDialog(hDlg, 0);
		    if(AppSound.EnableSound != 0)
			if(stricmp(AppSound.WindowsExit, "<none>") != 0)
			    sndPlaySound(AppSound.WindowsExit, SND_ASYNC | SND_NODEFAULT);
		    ExitWindows(EW_RESTARTWINDOWS, NULL);
		    return TRUE;

		case IDEXITW_NO:
		    EndDialog(hDlg, 0);
		    InvalidateRect(hWndMain, NULL, NULL);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }

/*-------------------------------------------------------------------------*/
BOOL WINAPI AskDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDASK_PARAMS:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDASK_PARAMS, szBuffer, MAXFILECHARS-1);
			SetDlgItemText(hDlg, IDRUN_PROGRAM, szBuffer);
			}
		    return TRUE;

		case IDASK_OK:
		    GetDlgItemText(hDlg, IDASK_PARAMS, szBuffer, MAXFILECHARS-1);
		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDASK_CANCEL:
		    EndDialog(hDlg, 0);
		    strcpy(szBuffer, "  ");
		    // ProgExec() will not start the program
		    bExecuteProg = FALSE;
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
