#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdarg.h>
#include <stdio.h>
#include <ctype.h>
#include <direct.h>
#include <string.h>
#include "appbar.h"

char szError[256];

/*--------------------------------------------------------------------------*/
/* FUNCTION: ProgExec(LPSTR lpCmdLine, int nCmdShow)			    */
/*									    */
/* PURPOSE:  changes current drive & directory and executes a program	    */
/*--------------------------------------------------------------------------*/
BOOL PASCAL ProgExec(HWND hWndParent, LPSTR lpszFile, LPSTR lpszParams, LPSTR lpszDir, int nCmdShow)
    {
    UINT ExecStatus;
    UINT ShowMode[3] = {SW_SHOWNORMAL, SW_SHOWMAXIMIZED, SW_SHOWMINIMIZED};
    char szParameters[256];

    // show maximum sized files as normal, resizing is done later
    if(nCmdShow == 3)
	nCmdShow = 0;

    bExecuteProg = TRUE;

    lstrcpy((LPSTR) szParameters, lpszParams);
    // if lpszParams contains "?" ask for commandline parameters
    if(strchr(szParameters, '?'))
	AskForParameters(szParameters);

    // execute file
    if(bExecuteProg)
	{
	ExecStatus = (UINT) ShellExecute(hWndParent, "open", lpszFile, szParameters, lpszDir, ShowMode[nCmdShow]);
	if(ExecStatus <= 32)
	    {
	    lstrcpy((LPSTR) szError, (LPCSTR) lpszFile);
	    ExecuteErrorHandle(ExecStatus, szError);
	    return FALSE;
	    }
	else
	    return TRUE;
	}
    return TRUE;
    }

/*--------------------------------------------------------------------------*/
VOID DoShellTasks(VOID)
    {
    char IniString[4*MAXFILECHARS], *szTemp;

    /* launch programs specified by load= */
    GetProfileString("windows", "load", "  ", IniString, (4*MAXFILECHARS)-1);
    if((szTemp = strtok(IniString, " ")) != NULL)
	{
	WinExec(szTemp, SW_SHOWMINIMIZED);
	while((szTemp = strtok(NULL, " ")) != NULL)
	    WinExec(szTemp, SW_SHOWMINIMIZED);
	}

    /* launch programs specified by run= */
    GetProfileString("windows", "run", "  ", IniString, (4*MAXFILECHARS)-1);
    if((szTemp = strtok(IniString, " ")) != NULL)
	{
	WinExec(szTemp, SW_SHOWNORMAL);
	while((szTemp = strtok(NULL, " ")) != NULL)
	    WinExec(szTemp, SW_SHOWNORMAL);
	}

    /* launch programs from specified groupfiles */
    GetPrivateProfileString("Shell", "ShellGroup", "startup.grp", szBuffer,
			    255, "appbar.ini");
    if((szTemp = strtok(szBuffer, " ")) != NULL)
	{
	ExecGroupFile(szTemp);
	while((szTemp = strtok(NULL, " ")) != NULL)
	    ExecGroupFile(szTemp);
	}
    }

/*---------------------------------------------------------------------------/
   Function : StartOrCloseProgram()
/---------------------------------------------------------------------------*/
VOID PASCAL StartOrCloseProgram(int iClose, UINT ClickMode)
    {
    CheckProgStatus();
    if(AppSystem.DoubleClick == 0)
	{
	if(ClickMode == BN_CLICKED)
	    {
	    if(AppButton[iClose].ProgStatus == ALIVE)
		BringWindowToTop(AppButton[iClose].hWndApp);

	    if(AppButton[iClose].ProgStatus == NOTALIVE)
		{
		SetCursor(LoadCursor(NULL, IDC_WAIT));
		iActive = iClose+1;
		if((AppSound.EnableSound != 0) && (AppButton[iClose].NoSound == 0))
		    {
		    if(stricmp(AppSound.ProgramStart, "<none>") != 0)
			sndPlaySound(AppSound.ProgramStart, SND_ASYNC | SND_NODEFAULT);
		    }
		ProgExec(hWndMain, (LPSTR)AppButton[iClose].ProgName, (LPSTR)AppButton[iClose].Params, (LPSTR)AppButton[iClose].StartDir, AppButton[iClose].ShowMode);
		if(AppButton[iClose].Close)
		    AppButton[iClose].ProgStatus = ALIVE;
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		}
	    }

	if(ClickMode == BN_DOUBLECLICKED && AppButton[iClose].Close)
	    {
	    if((AppSound.EnableSound != 0) && (AppButton[iClose].NoSound == 0))
		if(stricmp(AppSound.ProgramClose, "<none>") != 0)
		    sndPlaySound(AppSound.ProgramClose, SND_ASYNC | SND_NODEFAULT);
	    if(CloseApp(AppButton[iClose].hWndApp, hInst))
		AppButton[iClose].ProgStatus = NOTALIVE;
	    InvalidateRect(hWndCurrentButton, (LPRECT) NULL, FALSE);
	    UpdateWindow(hWndCurrentButton);
	    }
	}

    if((AppSystem.DoubleClick == 1) && (ClickMode == BN_DOUBLECLICKED))
	{
	if(AppButton[iClose].ProgStatus == NOTALIVE || !AppButton[iClose].Close)
	    {
	    SetCursor(LoadCursor(NULL, IDC_WAIT));
	    iActive = iClose+1;
	    if((AppSound.EnableSound != 0) && (AppButton[iClose].NoSound == 0))
		if(stricmp(AppSound.ProgramStart, "<none>") != 0)
		    sndPlaySound(AppSound.ProgramStart, SND_ASYNC | SND_NODEFAULT);
	    ProgExec(hWndMain, (LPSTR)AppButton[iClose].ProgName, (LPSTR)AppButton[iClose].Params, (LPSTR)AppButton[iClose].StartDir, AppButton[iClose].ShowMode);
	    SetCursor(LoadCursor(NULL, IDC_ARROW));
	    }
	else
	    {
	    //if program still exists, kill it.
	    if(IsWindow(AppButton[iClose].hWndApp))
		{
		if((AppSound.EnableSound != 0) && (AppButton[iClose].NoSound == 0))
		    if(stricmp(AppSound.ProgramClose, "<none>") != 0)
			sndPlaySound(AppSound.ProgramClose, SND_ASYNC | SND_NODEFAULT);
		if(CloseApp(AppButton[iClose].hWndApp, hInst))
		    AppButton[iClose].ProgStatus = NOTALIVE;
		InvalidateRect(hWndCurrentButton, (LPRECT) NULL, FALSE);
		UpdateWindow(hWndCurrentButton);
		}
	    else   // program doesn't exist anymore, start it again.
		{
		iActive = iClose+1;
		if((AppSound.EnableSound != 0) && (AppButton[iClose].NoSound == 0))
		    if(stricmp(AppSound.ProgramStart, "<none>") != 0)
			sndPlaySound(AppSound.ProgramStart, SND_ASYNC | SND_NODEFAULT);
		ProgExec(hWndMain, (LPSTR)AppButton[iClose].ProgName, (LPSTR)AppButton[iClose].Params, (LPSTR)AppButton[iClose].StartDir, AppButton[iClose].ShowMode);
		}
	    }
	}
    if((AppSystem.DoubleClick == 1) && (ClickMode == BN_CLICKED))
	if(AppButton[iClose].ProgStatus == ALIVE)
	    BringWindowToTop(AppButton[iClose].hWndApp);
    }

/*---------------------------------------------------------------------------/
/									     /
/  Function : CheckProgStatus() 					     /
/									     /
/  Purpose  : Updates the status of a program to the current status.	     /
/									     /
/---------------------------------------------------------------------------*/
VOID PASCAL CheckProgStatus(VOID)
    {
    int iCheck;

    for(iCheck=0;iCheck<AppWindow.nButtons;iCheck++)
	{
	if(AppButton[iCheck].ProgStatus == ALIVE)	   // Appbar thinks app[i] exists
	    {
	    if(!IsWindow(AppButton[iCheck].hWndApp))	   // app[i] doesn't exists anymore
		{
		AppButton[iCheck].ProgStatus = NOTALIVE;   // Appbar knows that now
		InvalidateRect(hWndButton[iCheck+FirstAppButton], (LPRECT) NULL, FALSE);
		}
	    }
	}
    }

/*--------------------------------------------------------------------------*/
int AskForParameters(char *szParameters)
    {
    static DLGPROC lpfnAskDlgProc;
    char szParams[256], szTemp[256], *szParam;

    strcpy(szParams, szParameters);

    szParam = strtok(szParams, "?");
    strcpy(szTemp, szParam);
    lpfnAskDlgProc = (DLGPROC) MakeProcInstance((FARPROC)AskDlgProc, hInst);
    DialogBox(hInst, "AskDlg", hWndMain, lpfnAskDlgProc);
    FreeProcInstance((FARPROC)lpfnAskDlgProc);
    if(bExecuteProg)
	{
	strcat(szTemp, " ");
	strcat(szTemp, szBuffer);
	}
    else
	return FALSE;

    while((szParam = strtok(NULL, "?")) != NULL)
	{
	strcat(szTemp, szParam);
	lpfnAskDlgProc = (DLGPROC) MakeProcInstance((FARPROC)AskDlgProc, hInst);
	DialogBox(hInst, "AskDlg", hWndMain, lpfnAskDlgProc);
	FreeProcInstance((FARPROC)lpfnAskDlgProc);
	if(bExecuteProg)
	    {
	    strcat(szTemp, " ");
	    strcat(szTemp, szBuffer);
	    }
	else
	    return FALSE;
	}
    strcpy(szParameters, szTemp);
    }
