//----------------------------------------------------------------------
// File name: showgrp.h                            Creation date: 920701 
//
// Abstract:  Header file for program to show how to read group files
//
// Development Team: bts
//
// Written by Microsoft Product Support Services, Windows Developer Support.
//
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//----------------------------------------------------------------------

// Group file header - Note: this is slightly different than what
// was given in previous documentation of the structure.  The IconFormat
// member was previously documented as being two words: wBitsPerPixel
// and wPlanes.  In actuality, this information is stored in one 
// word with the the high byte containing the number of planes and the
// low byte containing the number of bits per pixel.  It should also
// be noted that the number of planes is 0 based.

typedef struct tagGROUPHEADER {
  char    cIdentifier [4];            // PMCC
  WORD    wCheckSum;                  // Negative sum of all words
  WORD    cbGroup;                    // Number of bytes in group file
  WORD    nCmdShow;                   // How to show the group
  RECT    rcNormal;                   // Coordinates of the window
  POINT   ptMin;                      // Lower left corner
  WORD    pName;                      // Offset to group file name
  WORD    wLogPixelsX;                // icons horz resolution
  WORD    wLogPixelsY;                // icons vert resolution
  WORD    wIconFormat;                // Plane and bits per pixel
  WORD    wReserved;                  // Unused at this time
  WORD    cItems;                     // Count of items in group
} PMGROUPHEADER;

// Item structure for the items in the group file.  Probably the most
// important aspect of the item structure is that the icons are stored
// in a device dependent manner with-in the group file.  A consequence
// of this is that when you change display drivers, Windows has to
// rebuild the group files.  To create the new bit masks.

typedef struct tagITEMDATA {
  POINT   pt;                         // Lower left location of item icon
  WORD    iIcon;                      // Index value for icon
  WORD    cbHeader;                   // Bytes in icon resource
  WORD    cbANDPlane;                 // Bytes in icon AND plane
  WORD    cbXORPlane;                 // Bytes in icon XOR plane
  WORD    pHeader;                    // Offset to resource header
  WORD    pANDPlane;                  // Offset to AND plane
  WORD    pXORPlane;                  // Offset to XOR plane
  WORD    pName;                      // Offset to item name
  WORD    pCommand;                   // Offset to .exe name
  WORD    pIconPath;                  // Offset to .exe name containing icon
} PMITEMDATA;

char FAR * lpGroupFileData;

// Function prototypes
BOOL ReadGroupFile (LPSTR lpszGroupFileName, PHANDLE ghMemGroupFileData);
