#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "morsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI SectionDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC   lpfnSaveDlgProc;
    HDC 	hDC;
    RECT	rc;
    PAINTSTRUCT ps;
    char IniString[20], NewSectionName[MAXFILECHARS], CurrentSectionName[MAXFILECHARS];
    int i, SectionNumber, Index;

    switch(message)
	{
	case WM_INITDIALOG:
	    SetDlgItemText(hDlg, IDSECTION_CURRENT, AppSystem.SectionName);
	    for(i=0;i<AppSystem.NumberOfSections;i++)
		{
		sprintf(IniString,"%d",i+1);
		GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
				szBuffer, MAXFILECHARS-1, INI_FILE);
		SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_ADDSTRING, 0, (LONG) szBuffer);
		}
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDSECTION_ADD:
		    GetDlgItemText(hDlg, IDSECTION_NEW, NewSectionName, MAXFILECHARS-1);
		    AddSectionName(NewSectionName);
		    SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_ADDSTRING, 0, (LONG) NewSectionName);
		    strcpy(NewSectionName, "");
		    SetDlgItemText(hDlg, IDSECTION_NEW, NewSectionName);
		    return TRUE;

		case IDSECTION_NEW:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDSECTION_NEW, NewSectionName, MAXFILECHARS-1);
			SetDlgItemText(hDlg, IDSECTION_NEW, NewSectionName);
			}
		    return TRUE;

		case IDSECTION_OK:
		    Index = (WORD) SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_GETCURSEL, 0, 0L);
		    SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_GETTEXT, Index, (LONG) CurrentSectionName);
		    if(bSave && (stricmp(AppSystem.SectionName, "<none>") != 0))
			{
			lpfnSaveDlgProc = (DLGPROC) MakeProcInstance(SaveDlgProc, hInst);
			DialogBox(hInst, "SaveDlg", hDlg, lpfnSaveDlgProc);
			FreeProcInstance((FARPROC) lpfnSaveDlgProc);
			}
		    SectionNumber = VerifySectionName(CurrentSectionName);
		    if(SectionNumber)
			{
			AppSystem.SectionNumber = SectionNumber;
			IniRead();
			for(i=0;i<MAXAPPS;i++)
			    LoadIconFromFile(&hIcon[i], i);
			for(i=0;i<NUMICONS;i++)
			    bCurrentIcon[i] = FALSE;
			iBlackIcon = 0;
			iCurrent = 0;
			bCurrentIcon[iBlackIcon] = TRUE;
			SetScrollPos(hwndScroll, SB_CTL, 0, TRUE);
			UpdateScrollIcons(iBlackIcon);
			Button_SetCheck(hwndCloseProg, AppButton[iCurrent].Close);
			Button_SetCheck(hwndButtonLook, AppButton[iCurrent].ButtonLook);
			bSave = FALSE;
			}
		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDSECTION_DELETE:
		    Index = (WORD) SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_GETCURSEL, 0, 0L);
		    SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_GETTEXT, Index, (LONG) CurrentSectionName);
		    DeleteSectionName(CurrentSectionName);
		    SendDlgItemMessage(hDlg, IDSECTION_LIST, LB_DELETESTRING, Index, 0L);
		    return TRUE;

		case IDSECTION_CANCEL:
		    EndDialog(hDlg, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
