#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <string.h>
#include "morsetup.h"

int nSoundFocus = 0;

/*-------------------------------------------------------------------------*/
BOOL WINAPI SoundDlgProc(HWND hDlgSound, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnSelectDirDlgProc;

    switch(message)
	{
	case WM_INITDIALOG:
	    SetCaption(hDlgSound, "Sound Setup");
	    AppSoundNew = AppSound;
	    CheckDlgButton(hDlgSound, IDSOUND_ENABLE, AppSoundNew.EnableSound);
	    SetDlgItemText(hDlgSound, IDSOUND_PROGSTART, AppSoundNew.ProgramStart);
	    SetDlgItemText(hDlgSound, IDSOUND_PROGCLOSE, AppSoundNew.ProgramClose);
	    SetDlgItemText(hDlgSound, IDSOUND_DROPFILE, AppSoundNew.DropFile);
	    SetDlgItemText(hDlgSound, IDSOUND_ERROR, AppSoundNew.ErrorMessage);
	    SetDlgItemText(hDlgSound, IDSOUND_SOUNDDIR, AppSoundNew.SoundDirectory);
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDSOUND_PROGSTART:
		    nSoundFocus = 3;
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlgSound, IDSOUND_PROGSTART, AppSoundNew.ProgramStart, MAXFILECHARS-1);
			SetDlgItemText(hDlgSound, IDSOUND_PROGSTART, AppSoundNew.ProgramStart);
			}
		    return TRUE;

		case IDSOUND_PROGCLOSE:
		    nSoundFocus = 4;
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlgSound, IDSOUND_PROGCLOSE, AppSoundNew.ProgramClose, MAXFILECHARS-1);
			SetDlgItemText(hDlgSound, IDSOUND_PROGCLOSE, AppSoundNew.ProgramClose);
			}
		    return TRUE;

		case IDSOUND_DROPFILE:
		    nSoundFocus = 5;
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlgSound, IDSOUND_DROPFILE, AppSoundNew.DropFile, MAXFILECHARS-1);
			SetDlgItemText(hDlgSound, IDSOUND_DROPFILE, AppSoundNew.DropFile);
			}
		    return TRUE;

		case IDSOUND_ERROR:
		    nSoundFocus = 6;
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlgSound, IDSOUND_ERROR, AppSoundNew.ErrorMessage, MAXFILECHARS-1);
			SetDlgItemText(hDlgSound, IDSOUND_ERROR, AppSoundNew.ErrorMessage);
			}
		    return TRUE;

		case IDSOUND_SOUNDDIR:
		    nSoundFocus = 7;
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlgSound, IDSOUND_SOUNDDIR, AppSoundNew.SoundDirectory, MAXFILECHARS-1);
			SetDlgItemText(hDlgSound, IDSOUND_SOUNDDIR, AppSoundNew.SoundDirectory);
			}
		    return TRUE;

		case IDSOUND_BROWSE:
		    switch(nSoundFocus)
			{
			case 3:
			    if(BrowseFile(szBuffer, hDlgSound, WAVEFILES))
				{
				strcpy(AppSoundNew.ProgramStart, szBuffer);
				SetDlgItemText(hDlgSound, IDSOUND_PROGSTART, AppSoundNew.ProgramStart);
				}
			    break;

			case 4:
			    if(BrowseFile(szBuffer, hDlgSound, WAVEFILES))
				{
				strcpy(AppSoundNew.ProgramClose, szBuffer);
				SetDlgItemText(hDlgSound, IDSOUND_PROGCLOSE, AppSoundNew.ProgramClose);
				}
			    break;

			case 5:
			    if(BrowseFile(szBuffer, hDlgSound, WAVEFILES))
				{
				strcpy(AppSoundNew.DropFile, szBuffer);
				SetDlgItemText(hDlgSound, IDSOUND_DROPFILE, AppSoundNew.DropFile);
				}
			    break;

			case 6:
			    if(BrowseFile(szBuffer, hDlgSound, WAVEFILES))
				{
				strcpy(AppSoundNew.ErrorMessage, szBuffer);
				SetDlgItemText(hDlgSound, IDSOUND_ERROR, AppSoundNew.ErrorMessage);
				}
			    break;

			case 7:
			    lpfnSelectDirDlgProc = (DLGPROC) MakeProcInstance(SelectDirDlgProc, hInst);
			    DialogBox(hInst, "SelectDirDlg", hDlgSound, lpfnSelectDirDlgProc);
			    FreeProcInstance((FARPROC) lpfnSelectDirDlgProc);
			    InvalidateRect(hDlgSound, NULL, TRUE);
			    UpdateWindow(hDlgSound);
			    if(bNewDir)
				{
				strcpy(AppSound.SoundDirectory, Directory);
				SetDlgItemText(hDlgSound, IDSOUND_SOUNDDIR, AppSound.SoundDirectory);
				bNewDir = FALSE;
				}
			    break;

			}
		    return TRUE;

		case IDSOUND_TEST:
		    switch(nSoundFocus)
			{
			case 3:
			    SendDlgItemMessage(hDlgSound, IDSOUND_PROGSTART, EM_SETSEL, 0, MAKELONG(0, -1));
			    if(stricmp(AppSoundNew.ProgramStart, "<none>") != 0)
				sndPlaySound(AppSoundNew.ProgramStart, SND_ASYNC | SND_NODEFAULT);
			    break;

			case 4:
			    SendDlgItemMessage(hDlgSound, IDSOUND_PROGCLOSE, EM_SETSEL, 0, MAKELONG(0, -1));
			    if(stricmp(AppSoundNew.ProgramClose, "<none>") != 0)
				sndPlaySound(AppSoundNew.ProgramClose, SND_ASYNC | SND_NODEFAULT);
			    break;

			case 5:
			    SendDlgItemMessage(hDlgSound, IDSOUND_DROPFILE, EM_SETSEL, 0, MAKELONG(0, -1));
			    if(stricmp(AppSoundNew.DropFile, "<none>") != 0)
				sndPlaySound(AppSoundNew.DropFile, SND_ASYNC | SND_NODEFAULT);
			    break;

			case 6:
			    SendDlgItemMessage(hDlgSound, IDSOUND_ERROR, EM_SETSEL, 0, MAKELONG(0, -1));
			    if(stricmp(AppSoundNew.ErrorMessage, "<none>") != 0)
				sndPlaySound(AppSoundNew.ErrorMessage, SND_ASYNC | SND_NODEFAULT);
			    break;
			}
		    return TRUE;

		case IDSOUND_NONE:
		    switch(nSoundFocus)
			{
			case 3:
			    strcpy(AppSoundNew.ProgramStart, "<none>");
			    SetDlgItemText(hDlgSound, IDSOUND_PROGSTART, AppSoundNew.ProgramStart);
			    break;

			case 4:
			    strcpy(AppSoundNew.ProgramClose, "<none>");
			    SetDlgItemText(hDlgSound, IDSOUND_PROGCLOSE, AppSoundNew.ProgramClose);
			    break;

			case 5:
			    strcpy(AppSoundNew.DropFile, "<none>");
			    SetDlgItemText(hDlgSound, IDSOUND_DROPFILE, AppSoundNew.DropFile);
			    break;

			case 6:
			    strcpy(AppSoundNew.ErrorMessage, "<none>");
			    SetDlgItemText(hDlgSound, IDSOUND_ERROR, AppSoundNew.ErrorMessage);
			    break;
			}
		    return TRUE;

		case IDSOUND_HELP:
		    WinHelp(hWnd, "AppMore.hlp",HELP_CONTENTS, 0L);
		    return TRUE;

		case IDSOUND_OK:
		    bSave = TRUE;
		    if(IsDlgButtonChecked(hDlgSound, IDSOUND_ENABLE))
			AppSoundNew.EnableSound = 1;
		    else
			AppSoundNew.EnableSound = 0;
		    AppSound = AppSoundNew;
		    EndDialog(hDlgSound, 0);
		    return TRUE;

		case IDSOUND_CANCEL:
		    EndDialog(hDlgSound, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
