#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "morsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI SystemDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC   lpfnAboutDlgProc;
    HWND	     hCtrl;
    char	     intstring[MAXDIGITS];
    short	     nCtrlID;
    BOOL	     bSigned = TRUE;

    switch(message)
	{
	case WM_INITDIALOG:
	    SetCaption(hDlg, "System Setup");
	    AppSystemNew = AppSystem;
	    CheckDlgButton(hDlg, IDD_STAYINFRONT, AppSystem.StayInFront);
	    CheckDlgButton(hDlg, IDD_CLOSEALL, AppSystem.CloseAll);
	    CheckDlgButton(hDlg, IDD_ONELAUNCH, AppSystem.OneLaunch);
	    CheckDlgButton(hDlg, IDD_DOUBLECLICK, AppSystemNew.DoubleClick);
	    CheckDlgButton(hDlg, IDD_BIGBUTTONS, AppSystem.BigButtons);
	    SetDlgItemInt(hDlg, IDD_LEFT, (int) AppSystemNew.Left, bSigned);
	    SetDlgItemInt(hDlg, IDD_TOP, (int) AppSystemNew.Top, bSigned);
	    SetDlgItemInt(hDlg, IDD_BUTTONS, AppSystemNew.Buttons, bSigned);
	    SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
	    SetDlgItemInt(hDlg, IDD_BORDER, AppSystemNew.Border, bSigned);
	    return TRUE;

	case WM_VSCROLL:
	    hCtrl = (HWND) HIWORD(lParam);
	    nCtrlID = GetWindowWord(hCtrl, GWW_ID);
	    switch(wParam)
		{
		case SB_LINEDOWN:
		    switch(nCtrlID)
			{
			case IDD_SCROLLLEFT:
			    GetDlgItemText(hDlg, IDD_LEFT, intstring, MAXDIGITS);
			    AppSystemNew.Left = atoi(intstring);
			    AppSystemNew.Left = min(MAXRES, AppSystemNew.Left);
			    AppSystemNew.Left = max(-1, AppSystemNew.Left-1);
			    SetDlgItemInt(hDlg, IDD_LEFT, (int) AppSystemNew.Left, bSigned);
			    break;

			case IDD_SCROLLTOP:
			    GetDlgItemText(hDlg, IDD_TOP, intstring, MAXDIGITS);
			    AppSystemNew.Top = atoi(intstring);
			    AppSystemNew.Top = min(MAXRES, AppSystemNew.Top);
			    AppSystemNew.Top = max(-1, AppSystemNew.Top-1);
			    SetDlgItemInt(hDlg, IDD_TOP, (int) AppSystemNew.Top, bSigned);
			    break;

			case IDD_SCROLLBUTTONS:
			    GetDlgItemText(hDlg, IDD_BUTTONS, intstring, MAXDIGITS);
			    AppSystemNew.Buttons = atoi(intstring);
			    AppSystemNew.Buttons = min(MAXAPPS, AppSystemNew.Buttons);
			    AppSystemNew.Buttons = max(1, AppSystemNew.Buttons-1);
			    SetDlgItemInt(hDlg, IDD_BUTTONS, AppSystemNew.Buttons, bSigned);
			    if(AppSystemNew.Columns > AppSystemNew.Buttons+2) // add two systembutton's
				{
				AppSystemNew.Columns = AppSystemNew.Buttons+2;
				SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
				}
			    break;

			case IDD_SCROLLROWS:
			    GetDlgItemText(hDlg, IDD_ROWS, intstring, MAXDIGITS);
			    AppSystemNew.Columns = atoi(intstring);
			    AppSystemNew.Columns = min(AppSystemNew.Buttons+2, AppSystemNew.Columns);
			    AppSystemNew.Columns = max(1, AppSystemNew.Columns-1);
			    SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
			    break;

			case IDD_SCROLLBORDER:
			    GetDlgItemText(hDlg, IDD_BORDER, intstring, MAXDIGITS);
			    AppSystemNew.Border = atoi(intstring);
			    AppSystemNew.Border = min(MAXBORDER, AppSystemNew.Border);
			    AppSystemNew.Border = max(0, AppSystemNew.Border-1);
			    if(AppSystemNew.Border < 3)
				AppSystemNew.Border = 0;
			    SetDlgItemInt(hDlg, IDD_BORDER, AppSystemNew.Border, bSigned);
			    break;
			 }
		    break;

		case SB_LINEUP:
		    switch(nCtrlID)
			{
			case IDD_SCROLLLEFT:
			    GetDlgItemText(hDlg, IDD_LEFT, intstring, MAXDIGITS);
			    AppSystemNew.Left = atoi(intstring);
			    AppSystemNew.Left = max(-1, AppSystemNew.Left);
			    AppSystemNew.Left = min(MAXRES, AppSystemNew.Left+1);
			    SetDlgItemInt(hDlg, IDD_LEFT, (int) AppSystemNew.Left, bSigned);
			    break;

			case IDD_SCROLLTOP:
			    GetDlgItemText(hDlg, IDD_TOP, intstring, MAXDIGITS);
			    AppSystemNew.Top = atoi(intstring);
			    AppSystemNew.Top = max(-1, AppSystemNew.Top);
			    AppSystemNew.Top = min(MAXRES, AppSystemNew.Top+1);
			    SetDlgItemInt(hDlg, IDD_TOP, (int) AppSystemNew.Top, bSigned);
			    break;

			case IDD_SCROLLBUTTONS:
			    GetDlgItemText(hDlg, IDD_BUTTONS, intstring, MAXDIGITS);
			    AppSystemNew.Buttons = atoi(intstring);
			    AppSystemNew.Buttons = max(1, AppSystemNew.Buttons);
			    AppSystemNew.Buttons = min(MAXAPPS, AppSystemNew.Buttons+1);
			    SetDlgItemInt(hDlg, IDD_BUTTONS, AppSystemNew.Buttons, bSigned);
			    break;

			case IDD_SCROLLROWS:
			    GetDlgItemText(hDlg, IDD_ROWS, intstring, MAXDIGITS);
			    AppSystemNew.Columns = atoi(intstring);
			    AppSystemNew.Columns = max(1, AppSystemNew.Columns);
			    AppSystemNew.Columns = min(AppSystemNew.Buttons+2, AppSystemNew.Columns+1);
			    SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
			    break;

			case IDD_SCROLLBORDER:
			    GetDlgItemText(hDlg, IDD_BORDER, intstring, MAXDIGITS);
			    AppSystemNew.Border = atoi(intstring);
			    AppSystemNew.Border = max(0, AppSystemNew.Border);
			    AppSystemNew.Border = min(MAXBORDER, AppSystemNew.Border+1);
			    if(AppSystemNew.Border < 3)
				AppSystemNew.Border = 3;
			    SetDlgItemInt(hDlg, IDD_BORDER, AppSystemNew.Border, bSigned);
			    break;
			}
		    break;
		}
		return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDD_STAYINFRONT:
		    if(IsDlgButtonChecked(hDlg,IDD_STAYINFRONT))
			AppSystemNew.StayInFront = 0;
		    else
			AppSystemNew.StayInFront = 1;
		    CheckDlgButton(hDlg, IDD_STAYINFRONT, AppSystemNew.StayInFront);
		    return TRUE;

		case IDD_CLOSEALL:
		    if(IsDlgButtonChecked(hDlg,IDD_CLOSEALL))
			AppSystemNew.CloseAll = 0;
		    else
			AppSystemNew.CloseAll = 1;
		    CheckDlgButton(hDlg, IDD_CLOSEALL, AppSystemNew.CloseAll);
		    return TRUE;

		case IDD_ONELAUNCH:
		    if(IsDlgButtonChecked(hDlg,IDD_ONELAUNCH))
			AppSystemNew.OneLaunch = 0;
		    else
			AppSystemNew.OneLaunch = 1;
		    CheckDlgButton(hDlg, IDD_ONELAUNCH, AppSystemNew.OneLaunch);
		    return TRUE;

		case IDD_DOUBLECLICK:
		    if(IsDlgButtonChecked(hDlg,IDD_DOUBLECLICK))
			AppSystemNew.DoubleClick = 0;
		    else
			AppSystemNew.DoubleClick = 1;
		    CheckDlgButton(hDlg, IDD_DOUBLECLICK, AppSystemNew.DoubleClick);
		    return TRUE;

		case IDD_BIGBUTTONS:
		    if(IsDlgButtonChecked(hDlg,IDD_BIGBUTTONS))
			AppSystemNew.BigButtons = 0;
		    else
			AppSystemNew.BigButtons = 1;
		    CheckDlgButton(hDlg, IDD_BIGBUTTONS, AppSystemNew.BigButtons);
		    return TRUE;

		case IDD_LEFT:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDD_LEFT, intstring, MAXDIGITS);
			AppSystemNew.Left = atoi(intstring);
			AppSystemNew.Left = min(MAXRES, AppSystemNew.Left);
			AppSystemNew.Left = max(-1, AppSystemNew.Left);
			SetDlgItemInt(hDlg, IDD_LEFT, (int) AppSystemNew.Left, bSigned);
			}
		    return TRUE;

		case IDD_TOP:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDD_TOP, intstring, MAXDIGITS);
			AppSystemNew.Top = atoi(intstring);
			AppSystemNew.Top = min(MAXRES, AppSystemNew.Top);
			AppSystemNew.Top = max(-1, AppSystemNew.Top);
			SetDlgItemInt(hDlg, IDD_TOP, (int) AppSystemNew.Top, bSigned);
			}
		    return TRUE;

		case IDD_BUTTONS:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDD_BUTTONS, intstring, MAXDIGITS);
			AppSystemNew.Buttons = atoi(intstring);
			AppSystemNew.Buttons = min(MAXAPPS, AppSystemNew.Buttons);
			AppSystemNew.Buttons = max(1, AppSystemNew.Buttons);
			SetDlgItemInt(hDlg, IDD_BUTTONS, AppSystemNew.Buttons, bSigned);
			if(AppSystemNew.Columns > AppSystemNew.Buttons)
			    {
			    AppSystemNew.Columns = AppSystemNew.Buttons;
			    SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
			    }
			}
		    return TRUE;

		case IDD_ROWS:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDD_ROWS, intstring, MAXDIGITS);
			AppSystemNew.Columns = atoi(intstring);
			AppSystemNew.Columns = min(AppSystem.Buttons, AppSystemNew.Columns);
			AppSystemNew.Columns = max(1, AppSystemNew.Columns);
			SetDlgItemInt(hDlg, IDD_ROWS, AppSystemNew.Columns, bSigned);
			}
		    return TRUE;

		case IDD_BORDER:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDD_BORDER, intstring, MAXDIGITS);
			AppSystemNew.Border = atoi(intstring);
			AppSystemNew.Border = min(MAXBORDER, AppSystemNew.Border);
			AppSystemNew.Columns = max(0, AppSystemNew.Border);
			if(AppSystemNew.Border < 3)
			    AppSystemNew.Border = 0;
			SetDlgItemInt(hDlg, IDD_BORDER, AppSystemNew.Border, bSigned);
			}
		    return TRUE;

		case IDD_DEFAULT:
		    AppSystemNew.Left = (LEFT_DEFAULT);
		    AppSystemNew.Top = (TOP_DEFAULT);
		    AppSystemNew.Columns = (COLUMNS_DEFAULT);
		    AppSystemNew.Buttons = (BUTTONS_DEFAULT);
		    AppSystemNew.OneLaunch = (ONELAUNCH_DEFAULT);
		    AppSystemNew.CloseAll = (CLOSEALL_DEFAULT);
		    AppSystemNew.StayInFront = (STAYINFRONT_DEFAULT);
		    AppSystemNew.DoubleClick = (DOUBLECLICK_DEFAULT);
		    AppSystemNew.BigButtons = (BIGBUTTONS_DEFAULT);
		    CheckDlgButton(hDlg, IDD_STAYINFRONT, AppSystemNew.StayInFront);
		    CheckDlgButton(hDlg, IDD_CLOSEALL, AppSystemNew.CloseAll);
		    CheckDlgButton(hDlg, IDD_ONELAUNCH, AppSystemNew.OneLaunch);
		    CheckDlgButton(hDlg, IDD_DOUBLECLICK, AppSystemNew.DoubleClick);
		    SetDlgItemText(hDlg, IDD_LEFT, (LPSTR) LEFT_DEFAULT);
		    SetDlgItemText(hDlg, IDD_TOP, (LPSTR) TOP_DEFAULT);
		    SetDlgItemText(hDlg, IDD_BUTTONS, (LPSTR) BUTTONS_DEFAULT);
		    SetDlgItemText(hDlg, IDD_ROWS, (LPSTR) COLUMNS_DEFAULT);
		    SetDlgItemText(hDlg, IDD_BORDER, (LPSTR) BORDER_DEFAULT);
		    return TRUE;

		case IDD_ABOUT:
		    lpfnAboutDlgProc = (DLGPROC) MakeProcInstance(AboutDlgProc, hInst);
		    DialogBox(hInst, "AboutDlg", hWnd, lpfnAboutDlgProc);
		    FreeProcInstance((FARPROC) lpfnAboutDlgProc);
		    break;

		case IDD_HELP:
		    WinHelp(hWnd, "AppMore.hlp",HELP_CONTENTS, 0L);
		    return TRUE;

		case IDOK:
		    AppSystem = AppSystemNew;
		    bSave = TRUE;
		    EndDialog(hDlg, 0);
		    InvalidateRect(hWnd, NULL, 0);
		    return TRUE;

		case IDCANCEL:
		    EndDialog(hDlg, 0);
		    InvalidateRect(hWnd, NULL, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
