#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI ExitDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    HWND	hWndAppBar;

    switch(message)
	{
	case WM_INITDIALOG:
	    CheckDlgButton(hDlg, IDEXIT_RESTART, 1);
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDEXIT_OK:
		    IniSave();
		    if(IsDlgButtonChecked(hDlg, IDEXIT_RESTART))
			if((hWndAppBar = GetAppBarWindow()) != NULL)
			    SendMessage(hWndAppBar, WM_COMMAND, WM_APPBAR_RESTART, 0L);
		    EndDialog(hDlg, 0);
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    return TRUE;

		case IDEXIT_NO:
		    EndDialog(hDlg, 0);
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    return TRUE;

		case IDEXIT_CANCEL:
		    EndDialog(hDlg, 0);
		    InvalidateRect(hWnd, NULL, 0);
		    return TRUE;

		case IDEXIT_RESTART:
		    CheckDlgButton(hDlg, IDEXIT_RESTART, !IsDlgButtonChecked(hDlg, IDEXIT_RESTART));
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
