#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI SaveDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC  lpfnRestartDlgProc;
    OFSTRUCT	of;

    switch(message)
	{
	case WM_INITDIALOG:
	    if(!bAlreadyShell)
		{
		GetPrivateProfileString("boot","shell","",szBuffer,255,"system.ini");
		WritePrivateProfileString(INI_SHELL, OLDSHELL, szBuffer, INI_FILE);
		if(OpenFile("appbar.exe", &of, OF_EXIST | OF_SEARCH) != -1)
		    strcpy(szBuffer, of.szPathName);
		else
		    strcpy(szBuffer, "appbar.exe");
		}
	    else
		GetPrivateProfileString("shell",OLDSHELL,"program.exe",szBuffer,255,"appbar.ini");
	    SetDlgItemText(hDlg, IDSAVE_PATH, szBuffer);
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDSAVE_YES:
		    WritePrivateProfileString("boot", "shell", szBuffer, "system.ini");
		    lpfnRestartDlgProc = (DLGPROC) MakeProcInstance(RestartDlgProc, hInst);
		    DialogBox(hInst, "RestartDlg", hDlg, lpfnRestartDlgProc);
		    FreeProcInstance((FARPROC) lpfnRestartDlgProc);
		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDSAVE_NO:
		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDSAVE_BROWSE:
		    if(BrowseFile(szBuffer, hDlg, EXEFILES))
			SetDlgItemText(hDlg, IDSAVE_PATH, szBuffer);
		    return TRUE;

		case IDSAVE_PATH:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDSAVE_PATH, szBuffer, MAXFILECHARS-1);
			SetDlgItemText(hDlg, IDSAVE_PATH, szBuffer);
			}
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
