#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <string.h>
#include "appmore.h"

/*************************************************************************/
/*  FUNCTION: DlgAboutProc()						 */
/*									 */
/*  WindowProc for the AboutBox						 */
/*************************************************************************/
BOOL WINAPI AboutDlgProc(HWND hDlgAbout, UINT message, WPARAM wParam, LPARAM lParam)
    {
    HDC hDC, hDCMem;
    PAINTSTRUCT ps;
    RECT rc;
    BITMAP bm;

    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_PAINT:
	    hDC = BeginPaint(hDlgAbout, &ps);
	    rc = ps.rcPaint;
	    // make aboutbox LTGRAY
	    FillRect(hDC, (LPRECT) &rc, GetStockBrush(LTGRAY_BRUSH));

	    // draw two Bitmaps in the AboutBox
	    hDCMem = CreateCompatibleDC(hDC);
	    GetObject(hAppLogo, sizeof(BITMAP), (LPSTR) &bm);
	    SelectBitmap(hDCMem, hAppLogo);
	    BitBlt(hDC, ps.rcPaint.left+3*(cxChar/2), ps.rcPaint.top+cyChar, bm.bmWidth, bm.bmHeight, hDCMem, 0, 0, SRCCOPY);
	    GetObject(hNNever, sizeof(BITMAP), (LPSTR) &bm);
	    SelectBitmap(hDCMem, hNNever);
	    BitBlt(hDC, ps.rcPaint.left+3*(cxChar/2), ps.rcPaint.top+cyChar*5, bm.bmWidth, bm.bmHeight, hDCMem, 0, 0, SRCCOPY);
	    DeleteDC(hDCMem);

	    EndPaint(hDlgAbout, &ps);
	    return 0;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDOK:
		    EndDialog(hDlgAbout, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    } /* end DlgAboutProc */
