#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <string.h>
#include "appmore.h"

/*************************************************************************/
/*  FUNCTION: SystemDlgProc						 */
/*									 */
/*  Dialog for the SystemButtonBar					 */
/*************************************************************************/
BOOL WINAPI SystemDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_COMMAND:
	   if(HIWORD(lParam) == BN_CLICKED)
		{
		switch(wParam)
		    {
		    case ID_CLOSE:
			EndDialog(hDlg, TRUE);
			SendMessage(hWndMain, WM_DESTROY, 0, 0);
			break;

		    case ID_MOVE:	// Changes the window style to size it
			EndDialog(hDlg, TRUE);
			bMoveButton = TRUE;
			SendMessage(hWndMain, (UINT) WM_LBUTTONDOWN, wParam, lParam);
			break;

		    case ID_SETUP:
			EndDialog(hDlg, TRUE);
			ShellExecute(hWndMain, "open", "morsetup.exe", AppSystem.SectionName, NULL, SW_SHOWNORMAL);
			break;

		    case ID_QUICKLOAD:
			bQuickLoad = !bQuickLoad;
			if(!bQuickLoad)
			    SetNormalChildCursor();
			EndDialog(hDlg, TRUE);
			InvalidateRect(hWndButton[0], NULL, FALSE);
			UpdateWindow(hWndButton[0]);
			return TRUE;

		    case ID_CANCEL:
			EndDialog(hDlg, 0);
			return TRUE;
		    }
		}
	   break; /* end WM_COMMAND */
	}
    return FALSE;
    } /* end DlgSysProc */
