/* appbar.h */

#include <mmsystem.h>

#define ID_TIMER	101

#define SYSTEM_BUTTON	  0
#define SYSTEM_MENU	  0
#define FIRST_APPLICATION 1

#define ID_BUTTON1	1000

#define INI_APPMORE	"AppMore"
#define INI_FILE	"appmore.ini"

#define ID_CLOSE	400
#define ID_MOVE		402
#define ID_OK		403
#define ID_CANCEL	404
#define ID_SETUP	405
#define ID_QUICKLOAD	406

#define IDMOVE_YES	700
#define IDMOVE_NO	701

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define CLOSEALL	"CloseAll"
#define DOUBLECLICK	"DoubleClick"
#define STAYINFRONT	"StayInFront"
#define ONELAUNCH	"OneLaunch"
#define INITIALIZED	"Initialized"
#define NUMBEROFSECTIONS "NumberOfSections"

#define SOUNDENABLE	"EnableSound"
#define PROGSTART	"ProgramStart"
#define PROGCLOSE	"ProgramClose"
#define DROPFILE	"DropFile"
#define ERRORMESSAGE	"ErrorMessage"

#define LEFT_DEFAULT	    "-1"
#define TOP_DEFAULT	    "-1"
#define COLUMNS_DEFAULT	    "1"
#define BUTTONS_DEFAULT     "-1"
#define CLOSEALL_DEFAULT    "1"
#define DOUBLECLICK_DEFAULT "0"
#define CLOSEPROG_DEFAULT   "1"
#define SHOWMODE_DEFAULT    "0"
#define STAYINFRONT_DEFAULT "0"
#define ONELAUNCH_DEFAULT   "0"
#define ICONNUMBER_DEFAULT  "0"
#define BUTTONLOOK_DEFAULT  "0"
#define INITIALIZED_DEFAULT "0"
#define SECTIONS_DEFAULT    "0"
#define SECTIONNAME_DEFAULT "<none>"

#define SOUNDENABLE_DEFAULT	"0"
#define PROGSTART_DEFAULT	"<none>"
#define PROGCLOSE_DEFAULT	"<none>"
#define DROPFILE_DEFAULT	"<none>"
#define ERRORMESSAGE_DEFAULT	"<none>"


#define MAXFILECHARS	70
#define MAXDIGITS	5
#define NUMICONS	4
#define NUMEDITS	3
#define MAXAPPS 	48
#define MAXRES		1280

typedef struct {
       int	nColumns;
       int	nButtons;
       int	cxButton;
       int	cyButton;
       } APPWINDOW;

typedef enum {NOTALIVE = FALSE, ALIVE = TRUE} STATUS;

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	char	Params[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	BOOL	ButtonLook;
	STATUS	ProgStatus;
	BOOL	Close;
	short	ShowMode;
	BOOL	NoSound;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	BOOL	QuickExit;
	BOOL	CloseAll;
	BOOL	StayInFront;
	int	Initialized;
	BOOL	BigButtons;
	BOOL	DoubleClick;
	int	Border;
	int	OneLaunch;
	int	SectionNumber;
	int	NumberOfSections;
	char	SectionName[MAXFILECHARS];
	char	DefaultIconDir[MAXFILECHARS];
	} APPSYSTEM;

typedef struct {
	int	EnableSound;
	char	ProgramStart[MAXFILECHARS];
	char	ProgramClose[MAXFILECHARS];
	char	DropFile[MAXFILECHARS];
	char	ErrorMessage[MAXFILECHARS];
	} APPSOUND;

typedef struct {
	int left;
	int top;
	int width;
	int height;
	} APPMAXSIZE;

char szBuffer[256];

extern APPBARBUTTONS	AppButton[MAXAPPS], AppButtonDefault;
extern APPSYSTEM	AppSystem;
extern APPWINDOW	AppWindow;
extern APPSOUND 	AppSound;
extern APPMAXSIZE	AppMaxSize;
extern HWND		hWndMain, hWndCurrentButton, hWndButton[MAXAPPS];
extern HINSTANCE	hInst;
extern HBITMAP		hAppLogo, hNNever;
extern HBITMAP		hbPressed, hbBlank, hbKeyb;
extern HICON		hSystem, hBlank, hPressed, hQuickLoad;
extern HICON		hRun, hKeybOn, hPressed2, hSystem2;
extern BOOL		bMoveButton, bQuickLoad;
extern int		iCurrent, iKey, iActive, cxChar, cyChar, FirstAppButton;
extern char		szError[256];
extern BOOL		bKeyboardOn, bExecuteProg, bShuffleButton;

/* defined in AppMore.c */
extern int  PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow);
extern long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in AppTools.c*/
extern VOID OkMsgBox(char *szCaption, char *szFormat, ...);
extern VOID ErrorMsgBox(char *szCaption, char *szFormat, ...);
extern APPMAXSIZE CalculateAppMaxSize(VOID);
extern TEXTMETRIC RetrieveTextMetrics(HWND hWnd);
extern VOID PASCAL IniRead(VOID);
extern VOID PASCAL SaveButton(int i);
extern int VerifySectionName(LPSTR szSectionName);
extern VOID InitDefaultButton(VOID);
extern VOID SetNormalChildCursor(VOID);
extern VOID SetShuffleChildCursor(VOID);
extern void LoadAllButtonIcons(HICON *hIcon);
extern void LoadAppMoreResources(void);
extern void FreeAppMoreResources(void);

/* defined in AppDlgs.c */
extern BOOL WINAPI SystemDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern BOOL WINAPI MoveDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in AppExec.c */
extern BOOL PASCAL ProgExec(HWND hWndParent, LPSTR lpszFile, LPSTR lpszParams, LPSTR lpszDir, int nCmdShow);
extern VOID PASCAL StartOrCloseProgram(int);
extern VOID PASCAL CheckProgStatus(VOID);
extern VOID ExecuteErrorHandle(int iError);

/* define in AppClose.c */
extern long WINAPI WaitForWMCloseWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern VOID PASCAL WaitForWMClose(HWND hWndClose);
extern BOOL PASCAL CloseApp(HWND hWndClose);

/* defined in AppAbout.c */
extern BOOL WINAPI AboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in AppDraw.c */
extern void DrawItem(LPDRAWITEMSTRUCT lpIconDIS, HICON *hIcon);
extern void DrawBitmap(HDC hDC, short x, short y, HBITMAP hBitmap);

/* defined in AppKeyb.c */
extern int KeyboardInterface(int Key);
extern int ProcessSystemKeys(int SysKey);

/* Undocumented Windows function in taskman.exe (PCM/FEB92) */
extern BOOL WINAPI IsWinOldApTask(HTASK);

#define IsDosWindow(hWnd)   IsWinOldApTask(GetWindowTask(hWnd))
