/****************************************************************************************
TGraf : A simple plotting class for line and scatter plots for VC++, BC++.
	  ------

	Author	: David I. Hong
	e-mail	: hong@ece.ucdavis.edu

	usenet
	groups	: comp.std.c++, comp.lang.c++, comp.os.linux, comp.os.ms_windows

	Date	: Feburary 5, 1995
	Version	: Alpha 0.1.1

	Terms	: No registeration fee required. I mean it's FREE.
		  Giving a credit would be nice, though.
		  If it is found to be useful, please drop me a line.

	comments:
        --------
	. Upgraded from Alpha 0.1.0 which was released on January 12, 1995.
	. Now it is in DLL instead of static lib.
	. TPW is no longer supported. (I mean there is no TPW Unit for DLL)
	. User can set back ground color.
	. Text can be attached to each data point.
	. Line_Dot plot has been added.
	. Number of plot types : 4. 	(pt_XXXX)
	. Number of colors : 16.   	(pc_XXXX)
	. Number of line types : 4.	(PS_XXXX) from windows
	. Number of dot types : 2.	(dt_XXXX)
	. Each dot can be different dot types and color.
	. Uses Win3.1 COMMDLG.DLL.

	Work in progress:
	----------------
	. Increase number of dot types.
	. Support for VBX.
	. Support for Polar plot.
	. Support for Log-Log and ln-ln plot.
	. Support for Area Plot.
	. Simple Curve fitting ( power series.)
	. DFFT for spectrum analysis.
****************************************************************************************/
#ifndef __TGRAF_H
#define __TGRAF_H

//Define plot types, dot types, dot styles, line styles and colors
//define pc, pen colors
#define pc_blue			RGB(0,0,255)	/* blue */
#define pc_green		RGB(0,255,0)	/* green */
#define pc_red			RGB(255,0,0)	/* red */
#define pc_magenta		RGB(255,0,255)  /* magenta */
#define pc_dark_blue		RGB(0,0,128)	/* dark blue */
#define pc_dark_red		RGB(128,0,0)	/* dark red */
#define pc_dark_cyan		RGB(0,128,128)	/* dark cyan */
#define pc_black 		RGB(0,0,0)	/* black */
#define pc_grey 		RGB(128,128,128) /* grey */
#define pc_very_dark_cyan	RGB(0,128,64)	/* very dark cyan */
#define pc_dark_yellow		RGB(128,128,0)  /* dark yellow */
#define pc_dark_magenta		RGB(128,0,128)	/* dark magenta */
#define pc_light_grey		RGB(192,192,192) /* light grey */
#define pc_cyan 		RGB(0,255,255)	/* cyan */
#define pc_yellow		RGB(255,255,0)	/* yellow */
#define pc_white		RGB(255,255,255)/* white */

//define pt, plot types
#define pt_text		0x0000
#define pt_line		0x0001
#define pt_line_dot	0x0002
#define pt_point	0x0003
#define	pt_scatter	0x0004

//define ds, dot styles
#define ds_circle	0x0001
#define ds_square	0x0002

//define dt, dot types
#define dt_solid	0x0001


class _export TGraf
{							// TGraf Class
public:
	TGraf(HWND, int, int, int, int);		//Set parent HWindow, and location
	TGraf(HWND);                                    //hwindow, left, top, right, bottom
	virtual ~TGraf();
	LPSTR GetClassName();
	void FAR New_Plot();				//Erases current plot
	void FAR New_Set();				//Creates a new set to hold data points
	void FAR Set_Plot_Type(int);			//Plot type
	void FAR Set_Line_Style(int);			//Line style
	void FAR Set_Dot_Style(int);			//Dot style
	void FAR Set_Color(COLORREF);			//Color
	void FAR Set_Back_Ground_Color(COLORREF);	//Back Ground Color
	void FAR Set_Scale(double,double,double,double);//Xmin, ymin, xmax, ymax in user coordinate
	void FAR Set_Tics(int , int, int, int);		//no. of x_major,y_major,x_minor,y_minor
	void FAR Set_Titles(char*, char*, char*);       //Titles (main, x, y)
	void FAR Set_X_Label_Format(char*);		//x label format : ex. "10.2f"
	void FAR Set_Y_Label_Format(char*);		//y label format : ex. "10.2f"
	void FAR Add_Point(double, double);		//add data point (x,y)
	void FAR Add_Point(double, double, char*);	//attach text to the data point(x,y,text)
	void FAR Show_Tics();				//show tics
	void FAR Hide_Tics();				//hide tics
	void FAR Show_Axis();				//show axis
	void FAR Hide_Axis();				//hide axis
	void FAR Show_Grid();				//show grid
	void FAR Hide_Grid();				//hide grid
	void FAR Show_Data_Text();			//show texts attached to a data point
	void FAR Hide_Data_Text();			//hide texts attached to a data point
	void FAR Plot(RECT);                            //plot in new region RECT
	void FAR Plot();				//plot in current region
	void FAR Print();				//hardcopy
	void FAR About();				//Hey! About me
private:
	void FAR *GRAF;					//Plotting Engine
};

#endif