//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code dumps the access token of a process. Get a
// process ID from PVIEW.
//***************************************************************

// patidump.cpp

#include <windows.h>
#include <iostream.h>
#include <iomanip.h>

VOID main(VOID)
{
  BOOL ret;
  HANDLE procToken;
  HANDLE procHandle;
  DWORD procID;
  TOKEN_INFORMATION_CLASS tic;
  VOID *tokenData;
  DWORD sizeRqd;
  CHAR str[80];
  DWORD strSize;
  CHAR str2[80];
  DWORD str2Size;
  SID_NAME_USE sidType;
  UINT x;
  DWORD langID;
  ACL_SIZE_INFORMATION aclSize;
  ACCESS_ALLOWED_ACE *pace;

  cout << "Enter process ID to query: ";
  cin >> procID;

  // get a handle for the process
  procHandle=OpenProcess(PROCESS_QUERY_INFORMATION,
    FALSE, procID);
  if (procHandle == NULL)
  {
    cerr << "Unable to open the process for query."
      << endl;
    return;
  }

  // get a handle for the access token used
  // by the process
  ret=OpenProcessToken(procHandle,
    TOKEN_QUERY, &procToken);
  if (!ret)
  {
    cerr
      << "Unable to open the access token."
      << endl;
    return;
  }

  // close process handle
  CloseHandle(procHandle);

  // ----- Get user information -----

  // specify to return user info
  tic=TokenUser;

  // find out how much mem is needed
  ret=GetTokenInformation(procToken, tic, NULL, 0,
    &sizeRqd);

  // allocate that memory
  tokenData=(TOKEN_USER *) GlobalAlloc(GPTR,
    sizeRqd);
  if (tokenData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the user info
  ret=GetTokenInformation(procToken, tic,
    tokenData, sizeRqd, &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get user info." << endl;
    return;
  }

  // specify size of string buffers
  strSize=str2Size=80;

  // convert user SID into a name and domain
  ret=LookupAccountSid(NULL,
    ((TOKEN_USER *)tokenData)->User.Sid,
    str, &strSize, str2, &str2Size, &sidType);
  if (!ret)
  {
    cerr << "Unable to look up SID." << endl;
    return;
  }

  // release memory
  if(GlobalFree(tokenData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  cout << "Token user: \"" << str << "\" from \""
    << str2 << "\"." << endl;

  // ----- Get group information -----

  // specify to return group info
  tic=TokenGroups;

  // find out how much mem is needed
  ret=GetTokenInformation(procToken, tic, NULL, 0,
    &sizeRqd);

  // allocate that memory
  tokenData=(TOKEN_GROUPS *) GlobalAlloc(GPTR,
    sizeRqd);
  if (tokenData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the group info
  ret=GetTokenInformation(procToken, tic,
    tokenData, sizeRqd, &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get group info." << endl;
    return;
  }

  for (x=0; 
    x<((TOKEN_GROUPS *)tokenData)->GroupCount; 
    x++)
  {
    // specify size of string buffers
    strSize=str2Size=80;

    // convert group SID into a name and domain
    ret=LookupAccountSid(NULL,
      ((TOKEN_GROUPS *)tokenData)->Groups[x].Sid,
      str, &strSize, str2, &str2Size, &sidType);
    if (!ret)
    {
      if (((TOKEN_GROUPS *)
        tokenData)->Groups[x].Attributes &
        SE_GROUP_LOGON_ID)
      {
        strcpy(str, "Logon Identifier");
        strcpy(str2, "");
      }
      else
      {
        strcpy(str, "     !UNKNOWN!");
        strcpy(str2, "");
      }
    }

    cout << "Token group: \"" << setw(18)
      << setiosflags(ios::left) << str 
      << "\" from \""
      << setw(12) << str2 << "\" w/ attributes 0x"
      << setiosflags(ios::internal)
      << hex << setw(8) << setfill('0')
      << ((TOKEN_GROUPS *)
            tokenData)->Groups[x].Attributes
      << resetiosflags(ios::internal)
      << setfill(' ') << endl;
  }

  // release memory
  if(GlobalFree(tokenData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  // ----- Get privilege information -----

  // specify to return privilege info
  tic=TokenPrivileges;

  // find out how much mem is needed
  ret=GetTokenInformation(procToken, tic, NULL, 0,
    &sizeRqd);

  // allocate that memory
  tokenData=(TOKEN_PRIVILEGES *)
    GlobalAlloc(GPTR, sizeRqd);
  if (tokenData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the privilege info
  ret=GetTokenInformation(procToken, tic,
    tokenData, sizeRqd, &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get privilege info." 
      << endl;
    return;
  }

  for (x=0; 
    x<((TOKEN_PRIVILEGES *)
        tokenData)->PrivilegeCount; 
    x++)
  {
    // specify size of string buffers
    strSize=str2Size=80;

    // convert privilege LUID into a name and desc
    ret=LookupPrivilegeName(NULL,
      &((TOKEN_PRIVILEGES *)
      tokenData)->Privileges[x].Luid,
      str, &strSize);
    if (!ret)
    {
      cerr << "Unable to look up LUID." << endl;
      return;
    }

    ret=LookupPrivilegeDisplayName(NULL, str,
      str2, &str2Size, &langID);
    if (!ret)
    {
      cerr << "Unable to look up desc." << endl;
      return;
    }

    cout << setiosflags(ios::left)
      << "Token privilege: \""
      << setw(26) << str << "\" w/ attributes 0x"
      << setiosflags(ios::internal)
      << hex << setw(8) << setfill('0')
      << ((TOKEN_PRIVILEGES *)
         tokenData)->Privileges[x].Attributes
      << setfill(' ') 
      << resetiosflags(ios::internal)
      << endl << "           Desc: \"" << str2 
      << "\""
      << endl;
  }

  // release memory
  if(GlobalFree(tokenData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  // ----- Get default user information -----

  // specify to return owner info
  tic=TokenOwner;

  // find out how much mem is needed
  ret=GetTokenInformation(procToken, tic, NULL, 0,
    &sizeRqd);

  // allocate that memory
  tokenData=(TOKEN_OWNER *) GlobalAlloc(GPTR,
    sizeRqd);
  if (tokenData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the owner info
  ret=GetTokenInformation(procToken, tic,
    tokenData, sizeRqd, &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get owner info." << endl;
    return;
  }

  // specify size of string buffers
  strSize=str2Size=80;

  // convert owner SID into a name and domain
  ret=LookupAccountSid(NULL,
    ((TOKEN_OWNER *)tokenData)->Owner,
    str, &strSize, str2, &str2Size, &sidType);
  if (!ret)
  {
    cerr << "Unable to look up SID." << endl;
    return;
  }

  // release memory
  if(GlobalFree(tokenData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  cout << "Token default owner: \""
    << str << "\" from \""
    << str2 << "\"." << endl;

  // ----- Get default group information -----

  // specify to return def DACL info
  tic=TokenDefaultDacl;

  // find out how much mem is needed
  ret=GetTokenInformation(procToken, tic, NULL, 0,
    &sizeRqd);

  // allocate that memory
  tokenData=(TOKEN_DEFAULT_DACL *)
    GlobalAlloc(GPTR, sizeRqd);
  if (tokenData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the def DACL info
  ret=GetTokenInformation(procToken, tic,
    tokenData, sizeRqd, &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get default DACL info." 
      << endl;
    return;
  }

  if (((TOKEN_DEFAULT_DACL *)tokenData)->
    DefaultDacl == NULL)
  {
    cout << "Token default DACL: NULL"
      << " (Unrestricted Access)" << endl;
  }
  else
  {
    // get size info about this DACL
    ret=GetAclInformation(
      ((TOKEN_DEFAULT_DACL *)tokenData)->
        DefaultDacl,
      &aclSize, sizeof(ACL_SIZE_INFORMATION),
      AclSizeInformation);
    if (!ret)
    {
      cerr << "Unable to get ACL size info." 
        << endl;
      return;
    }

    for (x=0; x<aclSize.AceCount; x++)
    {
      // get ACE info
      ret=GetAce(
        ((TOKEN_DEFAULT_DACL *)tokenData)->
          DefaultDacl,
        x, (LPVOID *) &pace);

      // specify size of string buffers
      strSize=str2Size=80;

      // convert ACE SID into a name and domain
      ret=LookupAccountSid(NULL, &pace->SidStart,
        str, &strSize, str2, &str2Size, &sidType);
      if (!ret)
      {
        strcpy(str, "     !UNKNOWN!");
        strcpy(str2, "");
      }

      cout << "Token default DACL ACE: Type 0x"
        << setiosflags(ios::internal)
        << hex << setw(2) << setfill('0')
        << pace->Header.AceType
        << ", Mask 0x" << setw(8) << pace->Mask
        << resetiosflags(ios::internal) 
        << setfill(' ')
        << endl << "                        for \""
        << setw(18) << setiosflags(ios::left)
        << str << "\" from \""
        << setw(12) << str2 << "\"." << endl;
    }
  }

  // release memory
  if(GlobalFree(tokenData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  // close handle to access token
  CloseHandle(procToken);
}
