//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code dumps the security descriptor of a process.
// Get a process ID from PVIEW.
//***************************************************************

// psdidump.cpp

#include <windows.h>
#include <iostream.h>
#include <iomanip.h>

VOID main(VOID)
{
  BOOL ret;
  HANDLE procHandle;
  DWORD procID;
  SECURITY_DESCRIPTOR *sdData;
  PSID psid;
  PACL pacl;
  BOOL byDef;
  BOOL haveDACL;
  DWORD sizeRqd;
  CHAR str[80];
  DWORD strSize;
  CHAR str2[80];
  DWORD str2Size;
  SID_NAME_USE sidType;
  UINT x;
  ACL_SIZE_INFORMATION aclSize;
  ACCESS_ALLOWED_ACE *pace;

  cout << "Enter process ID to query: ";
  cin >> procID;

  // get a handle for the process
  procHandle=OpenProcess(READ_CONTROL,
    FALSE, procID);
  if (procHandle == NULL)
  {
    cerr << "Unable to open the process for query."
      << endl;
    return;
  }

  // find out how much mem is needed
  ret=GetKernelObjectSecurity(procHandle,
    OWNER_SECURITY_INFORMATION |
    GROUP_SECURITY_INFORMATION |
    DACL_SECURITY_INFORMATION,
    NULL, 0,
    &sizeRqd);

  // allocate that memory
  sdData=(SECURITY_DESCRIPTOR *)
    GlobalAlloc(GPTR, sizeRqd);
  if (sdData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the SD info
  ret=GetKernelObjectSecurity(procHandle,
    OWNER_SECURITY_INFORMATION |
    GROUP_SECURITY_INFORMATION |
    DACL_SECURITY_INFORMATION,
    sdData, sizeRqd,
    &sizeRqd);
  if (!ret)
  {
    cerr << "Unable to get SD info." << endl;
    return;
  }

  // close process handle
  CloseHandle(procHandle);

  // get the owner info
  ret=GetSecurityDescriptorOwner(sdData, &psid,
    &byDef);
  if (!ret)
  {
    cerr << "Unable to get owner info." << endl;
    return;
  }

  if (psid == NULL)
  {
    cout << "SD Owner: NULL"
      << " (No owner)" << endl;
  }
  else
  {
    // specify size of string buffers
    strSize=str2Size=80;

    // convert owner SID into a name and domain
    ret=LookupAccountSid(NULL, psid,
      str, &strSize, str2, &str2Size, &sidType);
    if (!ret)
    {
      cerr << "Unable to look up SID." << endl;
      return;
    }

    cout << "SD owner: \"" << str << "\" from \""
      << str2 << "\"." << endl;
  }

  // get the group info
  ret=GetSecurityDescriptorGroup(sdData, &psid,
    &byDef);
  if (!ret)
  {
    cerr << "Unable to get group info." << endl;
    return;
  }

  if (psid == NULL)
  {
    cout << "SD Group: NULL"
      << " (No group)" << endl;
  }
  else
  {
    // specify size of string buffers
    strSize=str2Size=80;

    // convert group SID into a name and domain
    ret=LookupAccountSid(NULL, psid,
      str, &strSize, str2, &str2Size, &sidType);
    if (!ret)
    {
      cerr << "Unable to look up SID." << endl;
      return;
    }

    cout << "SD group: \"" << str << "\" from \""
      << str2 << "\"." << endl;
  }

  // get the DACL info
  ret=GetSecurityDescriptorDacl(sdData,
    &haveDACL, &pacl, &byDef);
  if (!ret)
  {
    cerr << "Unable to get DACL info." << endl;
    return;
  }

  if (!haveDACL)
  {
    cout << "SD DACL: NULL"
      << " (Unrestricted Access)" << endl;
  }
  else
  {
    // get size info about this DACL
    ret=GetAclInformation(
      pacl, &aclSize, sizeof(ACL_SIZE_INFORMATION),
      AclSizeInformation);
    if (!ret)
    {
      cerr << "Unable to get ACL size info."
        << endl;
      return;
    }

    for (x=0; x<aclSize.AceCount; x++)
    {
      // get ACE info
      ret=GetAce(
        pacl, x, (LPVOID *) &pace);

      // specify size of string buffers
      strSize=str2Size=80;

      // convert ACE SID into a name and domain
      ret=LookupAccountSid(NULL,
        &pace->SidStart,
        str, &strSize, str2, &str2Size, &sidType);
      if (!ret)
      {
        strcpy(str, "     !UNKNOWN!");
        strcpy(str2, "");
      }

      cout << "SD DACL ACE: Type 0x"
        << setiosflags(ios::internal)
        << hex << setw(2) << setfill('0')
        << pace->Header.AceType
        << ", Mask 0x" << setw(8) << pace->Mask
        << resetiosflags(ios::internal) 
        << setfill(' ')
        << endl << "                        for \""
        << setw(18) << setiosflags(ios::left)
        << str << "\" from \""
        << setw(12) << str2 << "\"." << endl;
    }
  }

  // release memory
  if(GlobalFree(sdData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

}
