//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates how to change character colors in a 
// console.
//***************************************************************

// color.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

// Changes the colors of a range of cells. 
// Make sure that the console you are 
// using is not so big that the area 
// colored is not off the screen.
void ChangeColors(HANDLE consoleStdin, 
	HANDLE consoleStdout)
{
	COORD c;
	WORD color;
	DWORD numWrite;
	BOOL success;

	// Fill in the color of a range of 200 cells.
	color = BACKGROUND_RED | FOREGROUND_GREEN;
	c.X = 20;
	c.Y = 10;
	success = FillConsoleOutputAttribute(
		consoleStdout, color, 200, c, &numWrite);
	cout << numWrite << endl;
	if (!success)
		ErrorHandler("In FillConsoleOutputAttribute",
			GetLastError());
}

VOID main(void)
{
	HANDLE consoleStdout, consoleStdin;

	// Get handles for standard in and out
	consoleStdin = GetStdHandle(STD_INPUT_HANDLE);
	consoleStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	if (consoleStdin == consoleStdout) 
		ErrorHandler("In GetStdHandle",
			GetLastError());

	// Process user I/O
	ChangeColors(consoleStdin, consoleStdout);
}
