//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates how to create an independent shell
// separate from the originating shell useing the "AllocConsole"
// function.
//***************************************************************

// cooked2.cpp

#include <windows.h>
#include <iostream.h>
#include <string.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void ProcessIO(HANDLE consoleStdin,
	HANDLE consoleStdout)
{
	char buffer[1000];
	DWORD numRead, numWrite;

	do
	{
		ReadFile(consoleStdin, buffer, 
			1000, &numRead, 0);
		buffer[numRead]='\0';
		WriteFile(consoleStdout, buffer, 
			strlen(buffer), &numWrite, 0);
	} while  (strncmp(buffer, "exit", 4) != 0);
}

VOID main(void)
{
	HANDLE consoleStdout, consoleStdin;
	BOOL success;

	success = FreeConsole();
	if (!success)
		ErrorHandler("In FreeConsole", 
			GetLastError());
	success = AllocConsole();
	if (!success)
		ErrorHandler("In AllocConsole", 
			GetLastError());

	// Get handles for standard in and out
	consoleStdin = GetStdHandle(STD_INPUT_HANDLE);
	consoleStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	// they must be invalid if equal
	if (consoleStdin == consoleStdout) 
		ErrorHandler("In GetStdHandle",
			GetLastError());

	// Process user I/O
	ProcessIO(consoleStdin, consoleStdout);

	success = FreeConsole();
	if (!success)
		ErrorHandler("In FreeConsole",
			GetLastError());
}
