//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the GetSystemInfo function.
//***************************************************************

// sigsi.cpp

#include <windows.h>
#include <iostream.h>
#include <iomanip.h>

void main()
{
	SYSTEM_INFO si;

	GetSystemInfo(&si);
	cout << "OEM: " << si.dwOemId << endl;
	cout << "PageSize: " << si.dwPageSize << endl;
	cout << "Minimum app address: " 
		<< si.lpMinimumApplicationAddress << endl;
	cout << "Maximum app address: " 
		<< si.lpMaximumApplicationAddress << endl;
	cout << "Active processor mask: " << hex 
		<< si.dwActiveProcessorMask << endl;
	cout << "Number of processors: " 
		<< si.dwNumberOfProcessors << endl;
	cout << "Processor type: " 
		<< si.dwProcessorType << endl;
}
