//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code creates a DLL with an entry-point function.
//***************************************************************

// snd.cpp

#include <windows.h>

#include "snd.h"

BOOL WINAPI SndEntryPoint(HINSTANCE dllHandle,
  DWORD reason, LPVOID situation)
{
  CHAR buf[80];

  switch(reason)
  {
    case DLL_PROCESS_ATTACH:
      if (situation)
        wsprintf(buf, "DLL statically loaded.");
      else
        wsprintf(buf, "DLL dynamically loaded.");
      break;

    case DLL_THREAD_ATTACH:
      wsprintf(buf, "New thread starting.");
      break;

    case DLL_PROCESS_DETACH:
      if (situation)
        wsprintf(buf, "DLL released by system.");
      else
        wsprintf(buf, "DLL released by program.");
      break;

    case DLL_THREAD_DETACH:
      wsprintf(buf, "Thread terminating.");
      break;

    default:
      return FALSE;
  }

  MessageBox(NULL, buf, "DLL Info",
    MB_OK | MB_ICONINFORMATION);
  return TRUE;
}

void MultiHonk(DWORD iterations)
{
  UINT i;

  for (i=0; i<iterations; i++)
  {
    Beep(200, 50);
    Sleep(1000);
  }
}
