//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code sets up the proper registry values for an 
// application that wants to write to the event viewer. 
// Typically this functionality goes in an installation 
// program.
//***************************************************************

// instsrc.cpp

#include <windows.h>
#include <iostream.h>
#include <stdlib.h>

VOID ShowUsage(VOID)
{
  cout << "Install an Event Logging Source" 
    << endl;
  cout << "Usage: instsrc <sourcename> "
    << "<msg&ctgy file> "
    << "<category count>" << endl << endl;
  cout 
    << "sourcename   = name that application uses"
    << endl
    << "               to report events" 
    << endl;
  cout 
    << "msg&ctgy file= complete pathname to file"
    << endl 
    << "               which has the message table"
    << endl 
    << "               for event and category ID's"
    << endl;
  cout 
    << "catgy count  = number of categories used"
    << endl << "               to classify events"
    << endl
    << endl;
  cout 
    << "Example: instsrc TTT C:\\ttt\\ttt.dll 2"
    << endl;
}

VOID main(int argc, char *argv[])
{
  LONG ret;
  HKEY keyHandle;
  DWORD eventTypes;
  CHAR strBuf[80];
  DWORD disposition;
  DWORD categoryCount;

  if (argc != 4)
  {
    ShowUsage();
    return;
  }

  // build the path for the new key
  strcpy(strBuf, "SYSTEM\\CurrentControlSet\\");
  strcat(strBuf,
    "Services\\EventLog\\Application\\");
  strcat(strBuf, argv[1]);

  // add a key for the new source
  ret=RegCreateKeyEx(HKEY_LOCAL_MACHINE,
    strBuf, 0, NULL, REG_OPTION_NON_VOLATILE,
    KEY_SET_VALUE, NULL, &keyHandle, &disposition);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to create key: "
      << argv[1] << endl
      << "Check and make sure you"
      << " are a member of Administrators."
      << endl;
    return;
  }

  if (disposition == REG_OPENED_EXISTING_KEY)
  {
    cout << "Updating existing source information."
      << endl;
  }

  // add the EventMessageFile value to key
  ret=RegSetValueEx(keyHandle, "EventMessageFile",
    0, REG_EXPAND_SZ, (LPBYTE) argv[2],
    strlen(argv[2]) + 1);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to add value to key"
      << endl;
    return;
  }

  // specify the event types supported
  eventTypes=EVENTLOG_ERROR_TYPE |
    EVENTLOG_WARNING_TYPE |
    EVENTLOG_INFORMATION_TYPE;

  // add the TypesSupported value to key
  ret=RegSetValueEx(keyHandle, "TypesSupported",
        0, REG_DWORD, (LPBYTE) &eventTypes,
        sizeof(DWORD));
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to add value to key"
      << endl;
    return;
  }

  categoryCount=(DWORD) atoi(argv[3]);

  if (categoryCount)
  {
    // add the CategoryCount value to key
    ret=RegSetValueEx(keyHandle, "CategoryCount",
          0, REG_DWORD, (LPBYTE) &categoryCount,
          sizeof(DWORD));
    if (ret != ERROR_SUCCESS)
    {
      cerr << "Unable to add value to key"
        << endl;
      return;
    }

    // add the CategoryMessageFile value to key
    ret=RegSetValueEx(keyHandle,
      "CategoryMessageFile",
      0, REG_EXPAND_SZ, (LPBYTE) argv[2],
      strlen(argv[2]) + 1);
    if (ret != ERROR_SUCCESS)
    {
      cerr << "Unable to add value to key"
        << endl;
      return;
    }
  }

  // close the key
  RegCloseKey(keyHandle);
}
