//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to set the system time. You must have
// the set-time privilege for this code to work.
//***************************************************************

// settime.cpp

#include <windows.h>
#include <iostream.h>

BOOL AdjustPrivilege(LPCTSTR privilege,
  DWORD attribute)
{
  BOOL ret;
  HANDLE procToken;
  LUID luid;
  TOKEN_PRIVILEGES tp;
  
  // get a handle to the access token used
  // by this process
  ret=OpenProcessToken(GetCurrentProcess(),
    TOKEN_ADJUST_PRIVILEGES, &procToken);
  if (!ret)
    return(FALSE);

  // get LUID for privilege
  ret=LookupPrivilegeValue(NULL, privilege,
    &luid);
  if (!ret)
  {
    CloseHandle(procToken);
    return(FALSE);
  }

  // fill in token privileges struct
  tp.PrivilegeCount=1;
  tp.Privileges[0].Luid=luid;
  tp.Privileges[0].Attributes=attribute;
  
  // attempt to enable privilege
  AdjustTokenPrivileges(procToken, FALSE, &tp,
    NULL, NULL, NULL);

  if (GetLastError() != ERROR_SUCCESS)
    ret=FALSE;
  else
    ret=TRUE;

  CloseHandle(procToken);

  return(ret);
}

VOID DumpTimeStruct(LPSYSTEMTIME st)
{
  cout << "Year        : "
    << st->wYear << endl;
  cout << "Month       : "
    << st->wMonth << endl;
  cout << "Day of Week : "
    << st->wDayOfWeek << endl;
  cout << "Day         : "
    << st->wDay << endl;
  cout << "Hour        : "
    << st->wHour << endl;
  cout << "Minute      : "
    << st->wMinute << endl;
  cout << "Second      : "
    << st->wSecond << endl;
  cout << "Milliseconds: "
    << st->wMilliseconds << endl;
}

VOID main(VOID)
{
  SYSTEMTIME st;

  // get local time
  GetLocalTime(&st);

  cout << endl << "Current time (local):"
    << endl;
  DumpTimeStruct(&st);

  st.wYear++;

  // enable set system time privilege
  if (!AdjustPrivilege(SE_SYSTEMTIME_NAME,
    SE_PRIVILEGE_ENABLED))
  {
    cerr << "Must have set system time "
      << "privilege." << endl;
    return;
  }

  // set new time
  SetLocalTime(&st);

  // get local time
  GetLocalTime(&st);

  cout << endl << "New current time (local):"
    << endl;
  DumpTimeStruct(&st);

  st.wYear--;
 
  // reset time
  SetLocalTime(&st);

  // get local time
  GetLocalTime(&st);

  cout << endl << "Current time (local):"
    << endl;
  DumpTimeStruct(&st);

  // disable set system time privilege
  AdjustPrivilege(SE_SYSTEMTIME_NAME, 0);
}
