//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates a simple single-threaded mandelbrot
// set application.
//***************************************************************

// mandel0.cpp

#include <afxwin.h>
#include "menus.h"

#define NUM_ITERATIONS 64

const double left = -1.0;
const double right = 1.0;
const double top = -1.0;
const double bottom = 1.0;

DWORD colors[64];

typedef struct
{
	double real;
	double imag;
} complex;

// Define the application object class
class CManApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

// Define the edit window class
class CManWindow : public CFrameWnd
{
public:
	CManWindow();
	void RunMandel();
	void SetPix(int x, int y, WORD iter);
	afx_msg void OnPaint();
	afx_msg void OnDoDraw();
	afx_msg void OnExit();
	DECLARE_MESSAGE_MAP()
};

// Create an instance of the application object
CManApp manApp;

// member function used to set pixel colors in
// the window
void CManWindow::SetPix(int x, int y, WORD iter)
{
	CClientDC dc(this);
	dc.SetPixel(x, y, colors[iter]);
}

// member function used to redraw the 
// mandelbrot set
void CManWindow::RunMandel()
{
	CRect r;
	double xstep, ystep;
	double x, y;
	int i,j;
	WORD iter;
	complex k;
	complex z;
	double real, imag, spread;

	GetClientRect(&r);

	ystep = (double) (bottom - top) / r.Height();
	xstep = (double) (right - left) / r.Width();
	
	for (y=top, j=0; y <= bottom; y += ystep, j++)
	{
		for (x=left, i=0; x<=right; x += xstep, i++)
		{
			k.real = x;
			k.imag = y;
			z.real=z.imag=0.0;

			for (iter=0; iter<NUM_ITERATIONS-1;
				iter++)
			{
				real = z.real + k.real;
				imag = z.imag + k.imag;
				z.real = real * real - 
					imag * imag;
				z.imag = 2 * real * imag;
				spread = z.real * z.real + 
					z.imag * z.imag;
				if (spread > 4.0)
					break;
			}
			((CManWindow *)manApp.m_pMainWnd)->
				SetPix(i, j, iter);
		}
	}
}

// The message map
BEGIN_MESSAGE_MAP(CManWindow, CFrameWnd)
	ON_WM_PAINT()
	ON_COMMAND(IDM_DODRAW, OnDoDraw)
	ON_COMMAND(IDM_EXIT, OnExit)
END_MESSAGE_MAP()

// Handler for the Draw menu option
void CManWindow::OnDoDraw()
{
	// clear the window
	CClientDC dc(this);
	CRect r;
	GetClientRect(&r);
	dc.PatBlt(0, 0, r.Width(), r.Height(),
		WHITENESS);
	// Redraw the set
	RunMandel();
}

// Handler for WM_PAINT messages
void CManWindow::OnPaint()
{
	// Do not do anything in response to
	// paint events
	ValidateRect(NULL);
}

// Handler for the Exit menu option
void CManWindow::OnExit()
{
	DestroyWindow();
}

// CManWindow constructor
CManWindow::CManWindow()
{
	WORD x;
	BYTE red=0, green=0, blue=0;

	Create( NULL, "Normal Mandel Example", 
		WS_OVERLAPPEDWINDOW,
		CRect(0,0,150,150), NULL, "MainMenu" );
	for (x=0; x<64; x++)
	{
		colors[x] = RGB(red, green, blue);
		if (!(red += 64)) 
			if (!(green += 64)) 
				blue += 64;
	}
	colors[63] = RGB(255,255,255);
}

// Initialize the CManApp m_pMainWnd data member
BOOL CManApp::InitInstance()
{
	m_pMainWnd = new CManWindow();
	m_pMainWnd -> ShowWindow( m_nCmdShow );
	m_pMainWnd -> UpdateWindow();

	return TRUE;
}
