//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates passing a parameter to a thread
// function.
//***************************************************************

// thread1.cpp

#include <windows.h>
#include <stdlib.h>
#include <iostream.h>

// The function to run in a thread
void HonkThread(DWORD iter)
{
  DWORD i;

  for (i=0; i<iter; i++)
  {
    Beep(200, 50);
    Sleep(1000);
  }
}

void main(void)
{
  HANDLE honkHandle;
  DWORD threadID;
  DWORD iterations;
  CHAR iterStr[100];

  cout << "Enter the number of beeps to produce: ";
  cin.getline(iterStr, 100);

  // convert string into integer
  iterations=atoi(iterStr);

  // create a thread which 
  // executes the "HonkThread" function
  honkHandle=CreateThread(0, 0,
    (LPTHREAD_START_ROUTINE) HonkThread,
    (VOID *) iterations, 0, &threadID);

  // wait until the thread has finished
  int count=0;
  while ( WaitForSingleObject(honkHandle, 0) 
    == WAIT_TIMEOUT)
  {
    cout 
      << "waiting for the thread to finish "
      << count++
      << endl;
  }
}
