//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates a simple multi-threaded program.
//***************************************************************

// thread1a.cpp

#include <windows.h>
#include <iostream.h>

volatile UINT count;

void CountThread()
{
  while(1)
  {
    count++;
    Sleep(100);
  }
}

void main(void)
{
  HANDLE countHandle;
  DWORD threadID;
  CHAR retStr[100];

  count=0;

  // create a thread which 
  // executes the "CountThread" function
  countHandle=CreateThread(0, 0,
    (LPTHREAD_START_ROUTINE) CountThread,
    0, 0, &threadID);
  if (countHandle==0)
    cout << "Cannot create thread: " 
      << GetLastError() << endl;  

  while(1)
  {
    cout 
      << "Press <ENTER> to display the count... ";
    cin.getline(retStr, 100);
    cout << "The count is: " << count << endl 
      << endl;
  }
}
