//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the use of completion routines.
//***************************************************************

// fileovex.cpp

#include <windows.h>
#include <iostream.h>

VOID WINAPI CompletionRoutine(
	DWORD error, DWORD transferred, 
	LPOVERLAPPED overlapped)
{
	if (error != 0)
	{
		cout << "Completion Error = " 
			<< error << endl;
		return;
	}
	// update the file pointer
	overlapped->Offset += transferred;
	cout << "Inside completion routine. \n";
	cout << "Number of bytes read = ";
	cout << transferred << endl;
}

void main()
{
	HANDLE fileHandle;
	BOOL success;
	char s[300000];
	char filename[1000];
	OVERLAPPED overlappedInfo;
	HANDLE event;

	// get the file name
	cout << "Enter filename: ";
	cin >> filename;

	// Open the file
	fileHandle = CreateFile(filename, GENERIC_READ,
		0, 0, OPEN_EXISTING, 
		FILE_FLAG_OVERLAPPED, 0);
	if (fileHandle == INVALID_HANDLE_VALUE)
	{
		cout << "Error number " << GetLastError() 
			<< endl;
		return;
	}

	// set up the overlapped structure
	overlappedInfo.Offset = 0;
	overlappedInfo.OffsetHigh = 0;
	event = CreateEvent(0, TRUE, FALSE, 0);
	overlappedInfo.hEvent = event;

	// Read from the file
	success = ReadFileEx(fileHandle, s, 10000, 
		&overlappedInfo, CompletionRoutine);
	if (!success)
	{
		cout << "Error number " << GetLastError() 
			<< endl;
		return;
	}
	
	// Sleep until I/O is complete
	SleepEx(INFINITE, TRUE);
	cout << "\nSleep complete.\n";

	// Close the file
	CloseHandle(event);
	CloseHandle(fileHandle);  
}
