//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a UDP receiver.
//***************************************************************

// mciprecv.cpp

#include <windows.h>
#include <iostream.h>
#include <winsock.h>

#define NO_FLAGS_SET 0

#define PORT (u_short) 44966
#define MAXBUFLEN 256

INT main(VOID)
{
  WSADATA Data;
  SOCKADDR_IN recvSockAddr;
  SOCKET recvSocket;
  int status;
  int numrcv;
  char buffer[MAXBUFLEN];

  /* initialize the Windows Socket DLL */
  status=WSAStartup(MAKEWORD(1, 1), &Data);
  if (status != 0)
    cerr << "ERROR: WSAStartup unsuccessful"
      << endl;

  /* zero the sockaddr_in structure */
  memset(&recvSockAddr, 0, sizeof(recvSockAddr));
  /* specify the port portion of the address */
  recvSockAddr.sin_port=htons(PORT);
  /* specify the address family as Internet */
  recvSockAddr.sin_family=AF_INET;
  /* specify that the address does not matter */
  recvSockAddr.sin_addr.s_addr=htonl(INADDR_ANY);

  /* create a socket */
  recvSocket=socket(AF_INET, SOCK_DGRAM, 0);
  if (recvSocket == INVALID_SOCKET)
    cerr << "ERROR: socket unsuccessful" << endl;

  /* associate the socket with the address */
  status=bind(recvSocket, 
    (LPSOCKADDR) &recvSockAddr,
    sizeof(recvSockAddr));
  if (status == SOCKET_ERROR)
    cerr << "ERROR: bind unsuccessful" << endl;

  while(1)
  {
    numrcv=recvfrom(recvSocket, buffer, MAXBUFLEN,
      NO_FLAGS_SET, NULL, NULL);
    if (numrcv == SOCKET_ERROR)
    {
      cerr << "ERROR: recvfrom unsuccessful" 
        << endl;
      status=closesocket(recvSocket);
      if (status == SOCKET_ERROR)
        cerr << "ERROR: closesocket unsuccessful"
          << endl;
      status=WSACleanup();
      if (status == SOCKET_ERROR)
        cerr << "ERROR: WSACleanup unsuccessful"
          << endl;
      return(1); 
    }
    cout << buffer << endl;
  } /* while */
}
