//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC client.
//***************************************************************

// ctxtclnt.cpp

#include <windows.h>
#include <iostream.h>
#include <rpc.h>
#include <stdlib.h>
#include "sum.h"
#include "memstub"

INT main(VOID)
{
  long theSum;
  UCHAR *stringBinding;                   
  SumUpContext sumupContext;

  // put together string binding
  if (RpcStringBindingCompose(NULL,            
    (UCHAR *) "ncalrpc", NULL,
    NULL, NULL, &stringBinding))
  {
    cerr 
      << "ERROR: Unable to compose string binding"
      << endl;
    return(1);
  }

  // bind to server using string binding info
  if (RpcBindingFromStringBinding(stringBinding,
    &SumUpHandle))
  {
    cerr << "ERROR: Unable to bind" << endl;
    return(1);
  }

  // free the string binding info
  if (RpcStringFree(&stringBinding))
  {
    cerr << "ERROR: Unable to free string binding"
      << endl;
    return(1);
  }

  // establish sum context
  InitSum(&sumupContext);

  // release initial binding to server
  if (RpcBindingFree(&SumUpHandle))
  {
    cerr << "ERROR: Unable to free binding" 
      << endl;
    return(1);
  }

  do
  {
    theSum=SumUp(sumupContext, 5);

    cout << "The running sum is: " 
      << theSum << endl;

    Sleep(1000);
  } while (theSum < 150);

  // release sum context
  UnInitSum(&sumupContext);

  return(0);
}
