//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server function.
//***************************************************************

// ccrpc.cpp

#include <windows.h>
#include "ccrpc.h"

#define NUM_ITERATIONS 64

short CalcColor(complex k)
{
	complex z;
	double real, imag, spread;
	WORD iter;

	z.real=z.imag=0.0;

	for (iter=0; iter<NUM_ITERATIONS-1; iter++)
	{
		real = z.real + k.real;
		imag = z.imag + k.imag;
		z.real = real * real - imag * imag;
		z.imag = 2 * real * imag;
		spread = z.real * z.real + z.imag * z.imag;
		if (spread > 4.0)
			break;
	}
	
	return(iter);
}
