// mfcdevw.cpp : implementation of the CMfcdemoView class
//

#include "stdafx.h"
#include "mfcdemo.h"

#include "mfcdedoc.h"
#include "mfcdevw.h" 
               
#include "demotbl.h"
#include "demoopt.h"  
#include "celltype.h"
#include "scrolldi.h"
#include "labeldia.h" 
#include "actiondi.h"
#include "insertro.h"
#include "viewopti.h"   
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView

IMPLEMENT_DYNCREATE(CMfcdemoView, CView)

BEGIN_MESSAGE_MAP(CMfcdemoView, CView)
	//{{AFX_MSG_MAP(CMfcdemoView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_TOOLS_OPTIONS_ACTIONS, OnToolsOptionsActions)
	ON_COMMAND(ID_TOOLS_OPTIONS_LABELS, OnToolsOptionsLabels)
	ON_COMMAND(ID_TOOLS_OPTIONS_SCROLLING, OnToolsOptionsScrolling)
	ON_COMMAND(ID_TOOLS_OPTIONS_SIZE, OnToolsOptionsSize)
	ON_COMMAND(ID_FORMAT_CELLS_TYPE, OnFormatCellsType)
	ON_COMMAND(ID_INSERT_COLUMNS, OnInsertColumns)
	ON_COMMAND(ID_INSERT_ROWS, OnInsertRows)
	ON_COMMAND(ID_FORMAT_BACKGROUNDCOLOR, OnFormatBackgroundcolor)
	ON_COMMAND(ID_FORMAT_FOREGORUNDCOLOR, OnFormatForegorundcolor)
	ON_COMMAND(ID_FORMAT_FONT, OnFormatFont)
	ON_COMMAND(ID_TOOLS_OPTIONS_VIEW, OnToolsOptionsView)
	ON_COMMAND(ID_EDIT_DELETECOLUMNS, OnEditDeletecolumns)
	ON_COMMAND(ID_EDIT_DELETEROWS, OnEditDeleterows)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView construction/destruction

CMfcdemoView::CMfcdemoView()
{
	// TODO: add construction code here
	
	cktbl = new	CDemoTableControl;           
}

CMfcdemoView::~CMfcdemoView()
{     
	delete cktbl;         
}
         
/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView archive    

void CMfcdemoView::SerializeRaw(CArchive& ar)
{
	ASSERT_VALID(this);  
	ASSERT_VALID(cktbl);
	cktbl->SerializeRaw(ar);   
	ASSERT_VALID(this);
}
         
/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView drawing

void CMfcdemoView::OnDraw(CDC* pDC)
{
	CMfcdemoDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView printing
                      
void CMfcdemoView::OnPrint( CDC* pDC, CPrintInfo* pInfo )
{                                 
	// use CKTBL printing routine
	cktbl->SetMargins( pDC, pInfo );  		// Sets margins in pInfo
 	cktbl->OnPrint( pDC, pInfo );           // Prints page specified in pInfo
}
            
        
BOOL CMfcdemoView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMfcdemoView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add extra initialization before printing 
	
	CView::OnBeginPrinting( pDC, pInfo );          
	cktbl->OnBeginPrinting( pDC, pInfo );	// Initializes pInfo
	cktbl->SetMargins( pDC, pInfo );		// Sets margins in pInfo
	cktbl->Paginate( pDC, pInfo );			// Paginates into pInfo
}

void CMfcdemoView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}
    
                    
/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView diagnostics

#ifdef _DEBUG
void CMfcdemoView::AssertValid() const
{
	CView::AssertValid();
}

void CMfcdemoView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMfcdemoDoc* CMfcdemoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMfcdemoDoc)));
	return (CMfcdemoDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoView message handlers

int CMfcdemoView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{              
	RECT rect;
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	//GetClientRect(&rect);
	SetRect( &rect, 0,0,0,0 );
	if (!cktbl->Create( WS_CHILD|WS_VISIBLE|WS_HSCROLL|WS_VSCROLL, rect, this )) 
		return -1; 
			
	cktbl->SetSize( 32, 32 );	
	cktbl->SetFlags( CKTBL_DEFAULT_FLAGS|CKTBL_HSCROLL_STOP|CKTBL_VSCROLL_STOP );
    return 0;
}

void CMfcdemoView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	cktbl->MoveWindow( 0, 0, cx, cy, TRUE);
}
  

void CMfcdemoView::OnToolsOptionsActions()
{
	// TODO: Add your command handler code here

	CActionDialog dialog;  
	dialog.InitializeFrom(cktbl);
	dialog.DoModal();	
}

void CMfcdemoView::OnToolsOptionsLabels()
{
	// TODO: Add your command handler code here
	 
	CLabelDialog dialog;
	dialog.InitializeFrom(cktbl);
	dialog.DoModal();
}

void CMfcdemoView::OnToolsOptionsScrolling()
{
	// TODO: Add your command handler code here
	
	CScrollDialog dialog;
	dialog.InitializeFrom(cktbl);
	dialog.DoModal();
}

void CMfcdemoView::OnToolsOptionsSize()
{
	// TODO: Add your command handler code here  
	
	CDemoOptionsDialog dialog;
	dialog.InitializeFrom(cktbl);
	dialog.DoModal();

}       

void CMfcdemoView::OnToolsOptionsView()
{
	// TODO: Add your command handler code here
	CViewOptionsDialog dialog;
	dialog.InitializeFrom(cktbl);
	dialog.DoModal();
}

void CMfcdemoView::OnFormatCellsType()
{
	// TODO: Add your command handler code here  
	
	CCellTypeDialog dialog; 	
	dialog.InitializeFrom( cktbl );	
	dialog.DoModal();
}

void CMfcdemoView::OnInsertColumns()
{
	// TODO: Add your command handler code here
	CInsertRowColDialog dialog;
	dialog.InsertColumnsDialog();
	dialog.InitializeFrom( cktbl );	
	dialog.DoModal();
}

void CMfcdemoView::OnInsertRows()
{
	// TODO: Add your command handler code here
	CInsertRowColDialog dialog;  
    dialog.InsertRowsDialog();
	dialog.InitializeFrom( cktbl );	
	dialog.DoModal();
}

void CMfcdemoView::OnFormatBackgroundcolor()
{
	// TODO: Add your command handler code here
	CKTBL_ATTRIB attrib;
	
	cktbl->GetAttr( cktbl->GetCurrentRow(), cktbl->GetCurrentColumn(), &attrib );
	
	CColorDialog dialog(attrib.backColor);
	if(dialog.DoModal()==IDOK) {	
		attrib.backColor = dialog.GetColor();
		cktbl->ModifySelAttr( &attrib, CKTBL_ATTR_BACKCOLOR, 0 );
	}

}

void CMfcdemoView::OnFormatForegorundcolor()
{
	// TODO: Add your command handler code here
	CKTBL_ATTRIB attrib;

	cktbl->GetAttr( cktbl->GetCurrentRow(), cktbl->GetCurrentColumn(), &attrib ); 
	
	CColorDialog dialog( attrib.foreColor);
	if(dialog.DoModal()==IDOK) {	
		attrib.foreColor = dialog.GetColor();
		cktbl->ModifySelAttr( &attrib, CKTBL_ATTR_FORECOLOR, 0 );
	}
}

void CMfcdemoView::OnFormatFont()
{
	// TODO: Add your command handler code here
	LOGFONT		lf;
	CWindowDC	dummyDC(0);  
	int			logpixelSY;	
	CKTBL_ATTRIB attrib;
        
	// get defaults from current cell
 
	cktbl->GetAttr( cktbl->GetCurrentRow(), cktbl->GetCurrentColumn(), &attrib ); 
	
	// fill logfont with current font
	// size is cumbersome beacause LOGFONT does not have the size in points

  	memset(&lf, 0, sizeof(LOGFONT));

	logpixelSY = dummyDC.GetDeviceCaps( LOGPIXELSY );
    lf.lfHeight = - (int)((long)attrib.fontSize * logpixelSY / 720 );
	lf.lfWidth  = 0;

	// rest is easy
	
	strncpy( lf.lfFaceName, attrib.fontName, LF_FACESIZE );
	lf.lfWeight = (attrib.fontBold)?FW_BOLD:FW_NORMAL; 		// why not a boolean ? :-)
	lf.lfItalic = attrib.fontItalic;						// why not an angle ? :-)
	lf.lfUnderline = attrib.fontUnderline;
	lf.lfStrikeOut = attrib.fontStrikeOut;
	lf.lfOutPrecision	= OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision 	= CLIP_DEFAULT_PRECIS;
	lf.lfQuality 		= PROOF_QUALITY;
	lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
	
	// do dialog
	CFontDialog dialog( &lf );  
	dialog.m_cf.rgbColors = attrib.foreColor;
	if(dialog.DoModal()==IDOK) { 
		CHOOSEFONT 	*lpCF = &dialog.m_cf;
		LOGFONT 	*lpLF = dialog.m_cf.lpLogFont;

		// modify attribute
	
		attrib.fontName = lpLF->lfFaceName;
		attrib.fontSize = lpCF->iPointSize;  			// logfont does not have the size in points
		attrib.fontBold = lpLF->lfWeight==FW_BOLD;
		attrib.fontItalic = lpLF->lfItalic;
		attrib.fontUnderline = lpLF->lfUnderline;
		attrib.fontStrikeOut = lpLF->lfStrikeOut;
		attrib.foreColor = lpCF->rgbColors;

		cktbl->EndEdit( TRUE );
		cktbl->ModifySelAttr( &attrib, CKTBL_ATTR_FONT|CKTBL_ATTR_FORECOLOR, 0 );
		
		// make sure font fits in cells	       
		cktbl->UpdateSelectionRowHeighths();
	}    
	       
}
                      

void CMfcdemoView::OnEditDeletecolumns()
{
	// TODO: Add your command handler code here
	CRect rect;  
	
	if(cktbl->GetSelectionSize()==0) {
		CString msg,title;
		msg.LoadString(IDS_NOSELECTION);
		title.LoadString(AFX_IDS_APP_TITLE);
		MessageBox( msg, title, MB_ICONINFORMATION|MB_OK);
		return;
	}   
	
	if(cktbl->GetSelectionSize()>1) {
		CString msg,title;
		msg.LoadString(IDS_NOMULTIPLESEL);
		title.LoadString(AFX_IDS_APP_TITLE);
		MessageBox( msg, title, MB_ICONINFORMATION|MB_OK);
		return;
	}  
	
	cktbl->GetSelection(&rect, 1);
	cktbl->RemoveColumns( max(rect.left,1), min(rect.right,cktbl->GetColumns()) );  
	if(cktbl->GetColumns()==0) cktbl->SetColumns(1);

}

void CMfcdemoView::OnEditDeleterows()
{
	// TODO: Add your command handler code here
	CRect rect;  
	
	if(cktbl->GetSelectionSize()==0) {
		CString msg,title;
		msg.LoadString(IDS_NOSELECTION);
		title.LoadString(AFX_IDS_APP_TITLE);
		MessageBox( msg, title, MB_ICONINFORMATION|MB_OK);
		return;
	}   
	
	if(cktbl->GetSelectionSize()>1) {
		CString msg,title;
		msg.LoadString(IDS_NOMULTIPLESEL);
		title.LoadString(AFX_IDS_APP_TITLE);
		MessageBox( msg, title, MB_ICONINFORMATION|MB_OK);
		return;
	}   
	
    cktbl->GetSelection(&rect, 1);
	cktbl->RemoveRows( max(rect.top,1), min(rect.bottom,cktbl->GetRows()) );
	if(cktbl->GetRows()==0) cktbl->SetRows(1);
}
