#include <windows.h>
#if !defined(_WIN32) && !defined(WIN32)
#include <ver.h>
#endif
#include "des3.h"

#if !defined (APIENTRY)
#define APIENTRY PASCAL
#endif

BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

HINSTANCE hInst;

#ifdef WIN16
char szAppName[] = "W16VALID";  
char szTitle[]   = "ECB Certification of the DES Algorithm in WIN16"; 
#endif
#ifdef WIN32
char szAppName[] = "W32VALID";
char szTitle[]   = "ECB Certification of the DES Algorithm in WIN32";
#endif

#define IDM_RUN 100
/* size of standard DES block, in bits */
#define	BITSZ	(64)
/* size of standard DES block, in bytes */
#define	BLKSZ	(8)
/* how many standard DES blocks defined in ANSI X9.9 Appendix B */
#define	X99MX	(4)

#pragma argsused
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  MSG msg;
  if (!hPrevInstance) {
    if (!InitApplication(hInstance)) {
      return (FALSE);
    }
  }
  if (!InitInstance(hInstance, nCmdShow)) {
    return (FALSE);
  }
  while (GetMessage(&msg,NULL,0,0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return (msg.wParam);
}

BOOL InitApplication(HINSTANCE hInstance)
{
  WNDCLASS  wc;

  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = (WNDPROC)WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, szAppName);
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = szAppName;
  return (RegisterClass(&wc));
}

#pragma argsused
BOOL InitInstance(HINSTANCE hInstance,int nCmdShow)
{
  HWND hWnd;
  hInst = hInstance;
  hWnd = CreateWindow(szAppName,szTitle, WS_OVERLAPPEDWINDOW,
                     0, 0, 0, 0, NULL, NULL, hInstance, NULL);
  if (!hWnd) return (FALSE);
  PostMessage(hWnd, WM_COMMAND, IDM_RUN, 0L);
  return (TRUE);
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam)
{
  int wmId,i;
  /* for validation, keybits and patterns taken from ANSI X9.9 Appendix B */
  static uchar keybits[BLKSZ] = { 0xe6,0xa1,0x2f,0x07,0x9d,0x15,0xc4,0x37 };
  static uchar pattern[X99MX][BLKSZ] = {
       { 0x0a,0x20,0x20,0x20,0x54,0x4f,0x20,0x59 },
       { 0x51,0x44,0x2d,0x38,0x30,0x20,0x30,0x37 },
       { 0x54,0x4f,0x20,0x59,0x4f,0x55,0x52,0x20 },
       { 0x51,0x44,0x2d,0x38,0x30,0x20,0x30,0x37 }
  };
  static uchar results[X99MX][BLKSZ], clrtext[X99MX][BLKSZ], round[BITSZ], buf[X99MX*BITSZ];
  switch (message) {
     case WM_COMMAND:
#if defined (_WIN32) || defined(WIN32)
       wmId    = LOWORD(uParam);
#else
       wmId    = uParam;
#endif
       switch (wmId) {
         case IDM_RUN:
           desinit(keybits);
           for (i = 0; i < X99MX; i++) {
             ecbencode(pattern[i],results[i]);
             ecbdecode(results[i],clrtext[i]);
           }
           for (i = 0; i < X99MX; i++) {
             wsprintf(round,"ECB %02x%02x%02x%02x%02x%02x%02x%02x -> %02x%02x%02x%02x%02x%02x%02x%02x -> %02x%02x%02x%02x%02x%02x%02x%02x\n",
             pattern[i][0], pattern[i][1], pattern[i][2], pattern[i][3],
             pattern[i][4], pattern[i][5], pattern[i][6], pattern[i][7],
             results[i][0], results[i][1], results[i][2], results[i][3],
             results[i][4], results[i][5], results[i][6], results[i][7],
             clrtext[i][0], clrtext[i][1], clrtext[i][2], clrtext[i][3],
             clrtext[i][4], clrtext[i][5], clrtext[i][6], clrtext[i][7]);
             lstrcat(buf,round);
           }
           MessageBox(hWnd,buf,szTitle,MB_OK);
           SendMessage(hWnd, WM_DESTROY, 0, 0L);
           break;
         default:
           return (DefWindowProc(hWnd, message, uParam, lParam));
       }
       break;
     case WM_DESTROY:
       PostQuitMessage(0);
       break;
    default:
      return (DefWindowProc(hWnd, message, uParam, lParam));
   }
   return (0);
}
