/**************************************************************************************************

    SPELLCHK
    Spelling checker.

    Written and copyright by Brian J Quinion 1994.

    Version for Microsoft Windows.
    Version:  0.01 (Production)
    Date:     26 May 1994
    Module:   SPELL.H

**************************************************************************************************/

#if !defined(__DIR_H)
#include <dir.h>
#endif

#if !defined(__WINDOWS_H)
#include <windows.h>
#endif

#define MAXSPELL                        255
typedef WORD HUNDO;

/************************************************************************************************

    There are two ways to access the DLLs.  This first method is the full interface  It is 
    quite complicated but allows full control of the DLL.  Its design is based on that used
    for the common dialog boxes.  The functions mentioned are contained in the spellchk DLL. 

    See Help file

************************************************************************************************/

// Custom dictionaries

    // Defines
	#define MAXDICTITLE             20

	#define CD_READONLY             1
	#define CD_DISABLED             2
	#define CD_CHANGED              4

    // Structure
	typedef struct
	{
	    char                        DicFile[MAXPATH];
	    char                        DicTitle[MAXDICTITLE];
	    BYTE                        Options;
	// Reserved
	    BYTE                         Reserved[8];
	} CUSTDIC, far * LPCUSTDIC;


// Main options block 

    // Defines - Setting for the CheckWordOptions flag
	#define CWO_ALLOWCHANGE                 1
	#define CWO_AUTOSUGGEST                 2
	#define CWO_SUGGESTCUST                 4
	#define CWO_NOOPTIONS                   8
	#define CWO_UNDO                        16
	#define CWO_NOHELP                      32

	#define CWO_USEMAINHOOK                 64
	#define CWO_USEOPTIONSHOOK              128
	#define CWO_USECUSTOMMAINDLG            256
	#define CWO_USECUSTOMOPTIONSDLG         512
	#define CWO_SENDMSGTOMAINHOOK           1024
	#define CWO_SENDMSGTOOPTIONSHOOK        2048

	#define CWO_CHECKMULTIPLE               4096

	#define CWO_DONTUSEFULL                 8192

    // Structure

	typedef struct
	{
	    WORD                wSizeOfBlock;

	    HWND                hWndParent,
				hWndDlg;

	    WORD                CheckWordOptions;
	    char                szLanguage[13];
	    HGLOBAL             hCustomDics;
	    BYTE                NumCustom;
	    BYTE                CurCustom;

	    HINSTANCE           hInstance;
	    DLGPROC             fpMainHook;
	    DLGPROC             fpOptionsHook;
	    LPSTR               lpMainDlg;
	    LPSTR               lpOptionsDlg;

	    DWORD               dwCustData;
	    DWORD               dwCustData2;

	    char                ToCheck[MAXSPELL];
	    char                Changed[MAXSPELL];
	    BOOL                bCurWordChanged;

// Private data space for the program
	    BYTE                Reserved[26+MAXSPELL];
	} CHECKWORD, FAR * LPCHECKWORD;

    // Functions
	BOOL WINAPI SPCHK_CheckWord(LPCHECKWORD);
	void WINAPI SPCHK_Options(LPCHECKWORD);

    // Notification messages/requests
	#define SPELL_GETNEXT                      (WM_USER+240)
	#define SPELL_WORDNOTFOUND                 (WM_USER+241)
	#define SPELL_WORDCHANGED                  (WM_USER+242)
	#define SPELL_CANUNDO                      (WM_USER+243)
	#define SPELL_STOREUNDO                    (WM_USER+244)
	    #define UNDO_FAIL           0
	    #define UNDO_IGNORE         1
	    #define UNDO_IGNOREALL      2
	    #define UNDO_CHANGE         3
	    // > 3 means an ADD
	#define SPELL_UNDOLAST                     (WM_USER+245)
	#define SPELL_GETCUSTOMDEFPATH             (WM_USER+246)
        #define SPELL_HELPMAIN                     (WM_USER+247)
        #define SPELL_HELPOPTIONS                  (WM_USER+248)
        #define SPELL_HELPEDITDIC                  (WM_USER+249)

/************************************************************************************************

    This second method is far simpler, and simply allow your program to call the existing code
    as if the keyboard hot key had been pressed (in fact exactly the same routines are used).
    The functions mentioned are contained in the spelledt DLL. 

    See Help file

************************************************************************************************/

// Functions
     BOOL CALLBACK SPEDT_CheckEdit(HWND);
     void CALLBACK SPEDT_SetupBox(HWND);
