/**************************************************************************************************

    SPELTEST
    Program to test spelling checker.

    Written and copyright by Brian J Quinion 1995.

    Version for Microsoft Windows.
    Version:  0.01 (Production)
    Date:     19 Feb 1995
    Module:   ST-MAIN.C

**************************************************************************************************/

    /* include files common to all modules */
#define EXTERN
    #include "speltest.h"

    /* include files for this module only */
    #pragma  hdrstop
    /* NONE */

/***************************************************************************************************

    WinMain
    -------
    Main function for windows program

    Parameters : WinMain standard
    Called by  : Windows OS
    Calls      : 
    Modifies   : 
    Returns    : As standard

***************************************************************************************************/
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    HWND            hWnd;
    MSG             msg;

    if(hPrevInstance)
    {
	// Don't run another
	return FALSE;
    }

    // Make a copy of hInstance for global use
    g.hInst=hInstance;

    // Get the program path
    GetModuleFileName(g.hInst, g.szProgDir, MAXDIR);
    *(strrchr(g.szProgDir, '\\'))='\0';

    // Load settings
    LoadSettings();
    LoadResources();

    // Start the main window
    RegisterSPELTEST_MAIN();
    hWnd=CreateWindow("SPELTEST_MAIN", "Spell Checker Tester", WS_OVERLAPPEDWINDOW, 10, 10, 400, 300,
                      NULL, NULL, g.hInst, NULL);
    ShowWindow(hWnd, SW_SHOW);

    // Enter the message loop
    while (GetMessage(&msg, (HWND) NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    // Save settings
    SaveSettings();
    FreeResources();

    return 0;
}

/***************************************************************************************************

	LoadSettings
	------------
	Load settings from the ini file and the dat file

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
		o.SaveOptions		-
	Returns    :

***************************************************************************************************/
void LoadSettings(void)
{
}

/***************************************************************************************************

	SaveSettings
	------------
	Save settings to the ini file and the dat file

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   : ini and dat files
	Returns    : nothing

***************************************************************************************************/
void SaveSettings(void)
{
}

/***************************************************************************************************

	LoadResources
	-------------
	Load resources, and initalise

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
void LoadResources(void)
{
}

/***************************************************************************************************

	FreeResources
	-------------
	Free resources

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
void FreeResources(void)
{
}

/***************************************************************************************************

	WritePrivateProfileInt
	----------------------
	Suppliment function to GetPrivateProfileInt

	Parameters : 
	Called by  : 
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
BOOL WritePrivateProfileInt(LPSTR lpSection, LPSTR lpItem, DWORD Int, LPSTR lpFileName)
{
	char			Buffer[20];

	itoa((int)Int, Buffer, 10);
	return WritePrivateProfileString(lpSection, lpItem, (LPSTR)Buffer, lpFileName);
}
